/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;

public class CancelHandler {
    private boolean isCanceled;
    private List<ProgressMonitor.CancelListener> listeners = new ArrayList<ProgressMonitor.CancelListener>();

    public synchronized void cancel() {
        if (!this.isCanceled) {
            this.isCanceled = true;
            for (ProgressMonitor.CancelListener listener : this.listeners) {
                listener.operationCanceled();
            }
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void addCancelListener(ProgressMonitor.CancelListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeCancelListener(ProgressMonitor.CancelListener listener) {
        this.listeners.remove(listener);
    }
}

