/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.gui.dialogs.relation.RunnableAction;
import org.openstreetmap.josm.gui.tagging.TagCellEditor;
import org.openstreetmap.josm.gui.tagging.TagCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagTable
extends JTable {
    private static final Logger logger = Logger.getLogger(TagTable.class.getName());
    private TagCellEditor editor = null;
    private final CopyOnWriteArrayList<Component> doNotStopCellEditingWhenFocused = new CopyOnWriteArrayList();
    private CellEditorRemover editorRemover;
    private RunnableAction deleteAction = null;
    private RunnableAction addAction = null;

    public RunnableAction getDeleteAction() {
        return this.deleteAction;
    }

    public RunnableAction getAddAction() {
        return this.addAction;
    }

    protected void init() {
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(1);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(107, 2), "addTag");
        this.getActionMap().put("addTag", this.addAction);
        this.setTagCellEditor(new TagCellEditor());
    }

    public TagTable(TagEditorModel model) {
        super(model, new TagTableColumnModel(model.getColumnSelectionModel()), model.getRowSelectionModel());
        this.init();
    }

    public Dimension getPreferredSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 127) {
            if (this.isEditing() && this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            this.getDeleteAction().run();
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        if (autoCompletionList == null) {
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionList(autoCompletionList);
        }
    }

    public void setAutoCompletionManager(AutoCompletionManager autocomplete) {
        if (autocomplete == null) {
            logger.warning("argument autocomplete should not be null. Aborting.");
            Thread.dumpStack();
            return;
        }
        if (this.editor != null) {
            this.editor.setAutoCompletionManager(autocomplete);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        if (this.editor != null) {
            return this.editor.getAutoCompletionList();
        }
        return null;
    }

    public TagCellEditor getTableCellEditor() {
        return this.editor;
    }

    public void addOKAccelatorListener(KeyListener l) {
        this.addKeyListener(l);
        if (this.editor == null) {
            logger.warning("editor is null. cannot register OK accelator listener.");
        } else {
            this.editor.getEditor().addKeyListener(l);
        }
    }

    public void setTagCellEditor(TagCellEditor editor) {
        if (this.isEditing()) {
            this.editor.cancelCellEditing();
        }
        this.editor = editor;
        this.getColumnModel().getColumn(0).setCellEditor(editor);
        this.getColumnModel().getColumn(1).setCellEditor(editor);
    }

    public void requestFocusInCell(int row, int col) {
        Rectangle r = this.getCellRect(row, col, false);
        Point p = new Point(r.x + r.width / 2, r.y + r.height / 2);
        SwingUtilities.convertPointToScreen(p, this);
        Point before = MouseInfo.getPointerInfo().getLocation();
        try {
            Robot robot = new Robot();
            robot.mouseMove(p.x, p.y);
            robot.mousePress(16);
            robot.mouseRelease(16);
            robot.mouseMove(before.x, before.y);
        }
        catch (AWTException e) {
            logger.log(Level.SEVERE, "failed to simulate mouse click event at (" + r.x + "," + r.y + "). Exception: " + e.toString());
            return;
        }
    }

    public void addComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.addIfAbsent(component);
    }

    public void removeComponentNotStoppingCellEditing(Component component) {
        if (component == null) {
            return;
        }
        this.doNotStopCellEditingWhenFocused.remove(component);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        return super.editCellAt(row, column, e);
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeEditor();
    }

    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!TagTable.this.isEditing()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == TagTable.this) {
                    return;
                }
                if (TagTable.this.doNotStopCellEditingWhenFocused.contains(c)) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(TagTable.this) || TagTable.this.getCellEditor().stopCellEditing()) break;
                TagTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    class AddAction
    extends RunnableAction
    implements PropertyChangeListener {
        public AddAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.putValue("ShortDescription", I18n.tr("Add a new tag"));
            TagTable.this.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        public void run() {
            TableCellEditor editor = TagTable.this.getCellEditor();
            if (editor != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            ((TagEditorModel)TagTable.this.getModel()).appendNewTag();
            int rowIdx = TagTable.this.getModel().getRowCount() - 1;
            TagTable.this.requestFocusInCell(rowIdx, 0);
        }

        protected void updateEnabledState() {
            this.setEnabled(TagTable.this.isEnabled());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends RunnableAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selection in the tag table"));
            TagTable.this.getSelectionModel().addListSelectionListener(this);
            TagTable.this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.updateEnabledState();
        }

        protected void deleteTagNames() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTagNames(rows);
        }

        protected void deleteTagValues() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTagValues(rows);
        }

        protected void deleteTags() {
            int[] rows = TagTable.this.getSelectedRows();
            TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
            model.deleteTags(rows);
        }

        public void run() {
            TagEditorModel model;
            TableCellEditor editor;
            if (!this.isEnabled()) {
                return;
            }
            switch (TagTable.this.getSelectedColumnCount()) {
                case 1: {
                    if (TagTable.this.getSelectedColumn() == 0) {
                        this.deleteTagNames();
                        break;
                    }
                    if (TagTable.this.getSelectedColumn() != 1) break;
                    this.deleteTagValues();
                    break;
                }
                case 2: {
                    this.deleteTags();
                }
            }
            if (TagTable.this.isEditing() && (editor = TagTable.this.getCellEditor()) != null) {
                editor.cancelCellEditing();
            }
            if ((model = (TagEditorModel)TagTable.this.getModel()).getRowCount() == 0) {
                model.ensureOneTag();
                TagTable.this.requestFocusInCell(0, 0);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            if (TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (!TagTable.this.isEditing() && TagTable.this.getSelectedColumnCount() == 1 && TagTable.this.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else if (TagTable.this.getSelectedColumnCount() > 1 || TagTable.this.getSelectedRowCount() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col > 0 || row > 0) {
                if (col == 1) {
                    --col;
                } else {
                    col = 1;
                    --row;
                }
            }
            TagTable.this.changeSelection(row, col, false, false);
            TagTable.this.requestFocusInCell(row, col);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagTable.this.getSelectedColumn();
            int row = TagTable.this.getSelectedRow();
            if (TagTable.this.getCellEditor() != null) {
                TagTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 0) {
                ++col;
            } else if (col == 1 && row < TagTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            } else if (col == 1 && row == TagTable.this.getRowCount() - 1) {
                TagEditorModel model = (TagEditorModel)TagTable.this.getModel();
                model.appendNewTag();
                col = 0;
                ++row;
            }
            TagTable.this.changeSelection(row, col, false, false);
            TagTable.this.requestFocusInCell(row, col);
        }
    }

    static class TagTableColumnModel
    extends DefaultTableColumnModel {
        public TagTableColumnModel(DefaultListSelectionModel selectionModel) {
            this.setSelectionModel(selectionModel);
            TableColumn col = null;
            TagCellRenderer renderer = new TagCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Key"));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Value"));
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.addColumn(col);
        }
    }
}

