/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import java.awt.color.CMMException;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.awt.color.ProfileDataException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.java2d.cmm.CMSManager;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.ProfileActivator;
import sun.java2d.cmm.ProfileDeferralInfo;
import sun.java2d.cmm.ProfileDeferralMgr;
import sun.misc.BootClassLoaderHook;

public class ICC_Profile
implements Serializable {
    private static final long serialVersionUID = -3938515861990936766L;
    transient long ID;
    private transient ProfileDeferralInfo deferralInfo;
    private transient ProfileActivator profileActivator;
    private static ICC_Profile sRGBprofile;
    private static ICC_Profile XYZprofile;
    private static ICC_Profile PYCCprofile;
    private static ICC_Profile GRAYprofile;
    private static ICC_Profile LINEAR_RGBprofile;
    public static final int CLASS_INPUT = 0;
    public static final int CLASS_DISPLAY = 1;
    public static final int CLASS_OUTPUT = 2;
    public static final int CLASS_DEVICELINK = 3;
    public static final int CLASS_COLORSPACECONVERSION = 4;
    public static final int CLASS_ABSTRACT = 5;
    public static final int CLASS_NAMEDCOLOR = 6;
    public static final int icSigXYZData = 1482250784;
    public static final int icSigLabData = 1281450528;
    public static final int icSigLuvData = 1282766368;
    public static final int icSigYCbCrData = 1497588338;
    public static final int icSigYxyData = 1501067552;
    public static final int icSigRgbData = 1380401696;
    public static final int icSigGrayData = 1196573017;
    public static final int icSigHsvData = 1213421088;
    public static final int icSigHlsData = 1212961568;
    public static final int icSigCmykData = 1129142603;
    public static final int icSigCmyData = 1129142560;
    public static final int icSigSpace2CLR = 843271250;
    public static final int icSigSpace3CLR = 860048466;
    public static final int icSigSpace4CLR = 876825682;
    public static final int icSigSpace5CLR = 893602898;
    public static final int icSigSpace6CLR = 910380114;
    public static final int icSigSpace7CLR = 927157330;
    public static final int icSigSpace8CLR = 943934546;
    public static final int icSigSpace9CLR = 960711762;
    public static final int icSigSpaceACLR = 1094929490;
    public static final int icSigSpaceBCLR = 1111706706;
    public static final int icSigSpaceCCLR = 1128483922;
    public static final int icSigSpaceDCLR = 1145261138;
    public static final int icSigSpaceECLR = 1162038354;
    public static final int icSigSpaceFCLR = 1178815570;
    public static final int icSigInputClass = 1935896178;
    public static final int icSigDisplayClass = 1835955314;
    public static final int icSigOutputClass = 1886549106;
    public static final int icSigLinkClass = 1818848875;
    public static final int icSigAbstractClass = 1633842036;
    public static final int icSigColorSpaceClass = 1936744803;
    public static final int icSigNamedColorClass = 1852662636;
    public static final int icPerceptual = 0;
    public static final int icRelativeColorimetric = 1;
    public static final int icMediaRelativeColorimetric = 1;
    public static final int icSaturation = 2;
    public static final int icAbsoluteColorimetric = 3;
    public static final int icICCAbsoluteColorimetric = 3;
    public static final int icSigHead = 1751474532;
    public static final int icSigAToB0Tag = 1093812784;
    public static final int icSigAToB1Tag = 1093812785;
    public static final int icSigAToB2Tag = 1093812786;
    public static final int icSigBlueColorantTag = 1649957210;
    public static final int icSigBlueMatrixColumnTag = 1649957210;
    public static final int icSigBlueTRCTag = 1649693251;
    public static final int icSigBToA0Tag = 1110589744;
    public static final int icSigBToA1Tag = 1110589745;
    public static final int icSigBToA2Tag = 1110589746;
    public static final int icSigCalibrationDateTimeTag = 1667329140;
    public static final int icSigCharTargetTag = 1952543335;
    public static final int icSigCopyrightTag = 1668313716;
    public static final int icSigCrdInfoTag = 1668441193;
    public static final int icSigDeviceMfgDescTag = 1684893284;
    public static final int icSigDeviceModelDescTag = 0x646D6464;
    public static final int icSigDeviceSettingsTag = 1684371059;
    public static final int icSigGamutTag = 1734438260;
    public static final int icSigGrayTRCTag = 1800688195;
    public static final int icSigGreenColorantTag = 1733843290;
    public static final int icSigGreenMatrixColumnTag = 1733843290;
    public static final int icSigGreenTRCTag = 1733579331;
    public static final int icSigLuminanceTag = 1819635049;
    public static final int icSigMeasurementTag = 1835360627;
    public static final int icSigMediaBlackPointTag = 1651208308;
    public static final int icSigMediaWhitePointTag = 0x77747074;
    public static final int icSigNamedColor2Tag = 1852009522;
    public static final int icSigOutputResponseTag = 1919251312;
    public static final int icSigPreview0Tag = 1886545200;
    public static final int icSigPreview1Tag = 1886545201;
    public static final int icSigPreview2Tag = 1886545202;
    public static final int icSigProfileDescriptionTag = 1684370275;
    public static final int icSigProfileSequenceDescTag = 1886610801;
    public static final int icSigPs2CRD0Tag = 1886610480;
    public static final int icSigPs2CRD1Tag = 1886610481;
    public static final int icSigPs2CRD2Tag = 1886610482;
    public static final int icSigPs2CRD3Tag = 1886610483;
    public static final int icSigPs2CSATag = 1886597747;
    public static final int icSigPs2RenderingIntentTag = 1886597737;
    public static final int icSigRedColorantTag = 1918392666;
    public static final int icSigRedMatrixColumnTag = 1918392666;
    public static final int icSigRedTRCTag = 1918128707;
    public static final int icSigScreeningDescTag = 1935897188;
    public static final int icSigScreeningTag = 1935897198;
    public static final int icSigTechnologyTag = 1952801640;
    public static final int icSigUcrBgTag = 1650877472;
    public static final int icSigViewingCondDescTag = 1987405156;
    public static final int icSigViewingConditionsTag = 1986618743;
    public static final int icSigChromaticityTag = 1667789421;
    public static final int icSigChromaticAdaptationTag = 1667785060;
    public static final int icSigColorantOrderTag = 1668051567;
    public static final int icSigColorantTableTag = 1668051572;
    public static final int icHdrSize = 0;
    public static final int icHdrCmmId = 4;
    public static final int icHdrVersion = 8;
    public static final int icHdrDeviceClass = 12;
    public static final int icHdrColorSpace = 16;
    public static final int icHdrPcs = 20;
    public static final int icHdrDate = 24;
    public static final int icHdrMagic = 36;
    public static final int icHdrPlatform = 40;
    public static final int icHdrFlags = 44;
    public static final int icHdrManufacturer = 48;
    public static final int icHdrModel = 52;
    public static final int icHdrAttributes = 56;
    public static final int icHdrRenderingIntent = 64;
    public static final int icHdrIlluminant = 68;
    public static final int icHdrCreator = 80;
    public static final int icHdrProfileID = 84;
    public static final int icTagType = 0;
    public static final int icTagReserved = 4;
    public static final int icCurveCount = 8;
    public static final int icCurveData = 12;
    public static final int icXYZNumberX = 8;
    private int iccProfileSerializedDataVersion = 1;
    private transient ICC_Profile resolvedDeserializedProfile;

    ICC_Profile(long l) {
        this.ID = l;
    }

    ICC_Profile(ProfileDeferralInfo profileDeferralInfo) {
        this.deferralInfo = profileDeferralInfo;
        this.profileActivator = new ProfileActivator(){

            @Override
            public void activate() throws ProfileDataException {
                ICC_Profile.this.activateDeferredProfile();
            }
        };
        ProfileDeferralMgr.registerDeferral(this.profileActivator);
    }

    protected void finalize() {
        if (this.ID != 0L) {
            CMSManager.getModule().freeProfile(this.ID);
        } else if (this.profileActivator != null) {
            ProfileDeferralMgr.unregisterDeferral(this.profileActivator);
        }
    }

    public static ICC_Profile getInstance(byte[] byArray) {
        ICC_Profile iCC_Profile;
        long l;
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        try {
            l = CMSManager.getModule().loadProfile(byArray);
        }
        catch (CMMException cMMException) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        try {
            iCC_Profile = ICC_Profile.getColorSpaceType(l) == 6 && ICC_Profile.getData(l, 0x77747074) != null && ICC_Profile.getData(l, 1800688195) != null ? new ICC_ProfileGray(l) : (ICC_Profile.getColorSpaceType(l) == 5 && ICC_Profile.getData(l, 0x77747074) != null && ICC_Profile.getData(l, 1918392666) != null && ICC_Profile.getData(l, 1733843290) != null && ICC_Profile.getData(l, 1649957210) != null && ICC_Profile.getData(l, 1918128707) != null && ICC_Profile.getData(l, 1733579331) != null && ICC_Profile.getData(l, 1649693251) != null ? new ICC_ProfileRGB(l) : new ICC_Profile(l));
        }
        catch (CMMException cMMException) {
            iCC_Profile = new ICC_Profile(l);
        }
        return iCC_Profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICC_Profile getInstance(int n) {
        ICC_Profile iCC_Profile = null;
        switch (n) {
            case 1000: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (sRGBprofile != null) return sRGBprofile;
                    ProfileDeferralInfo profileDeferralInfo = new ProfileDeferralInfo("sRGB.pf", 5, 3, 1);
                    sRGBprofile = ICC_Profile.getDeferredInstance(profileDeferralInfo);
                    return sRGBprofile;
                }
            }
            case 1001: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (XYZprofile != null) return XYZprofile;
                    ProfileDeferralInfo profileDeferralInfo = new ProfileDeferralInfo("CIEXYZ.pf", 0, 3, 1);
                    XYZprofile = ICC_Profile.getDeferredInstance(profileDeferralInfo);
                    return XYZprofile;
                }
            }
            case 1002: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (PYCCprofile != null) return PYCCprofile;
                    if (BootClassLoaderHook.getHook() == null) {
                        if (!ICC_Profile.standardProfileExists("PYCC.pf")) throw new IllegalArgumentException("Can't load standard profile: PYCC.pf");
                    }
                    ProfileDeferralInfo profileDeferralInfo = new ProfileDeferralInfo("PYCC.pf", 13, 3, 1);
                    PYCCprofile = ICC_Profile.getDeferredInstance(profileDeferralInfo);
                    return PYCCprofile;
                }
            }
            case 1003: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (GRAYprofile != null) return GRAYprofile;
                    ProfileDeferralInfo profileDeferralInfo = new ProfileDeferralInfo("GRAY.pf", 6, 1, 1);
                    GRAYprofile = ICC_Profile.getDeferredInstance(profileDeferralInfo);
                    return GRAYprofile;
                }
            }
            case 1004: {
                Class<ICC_Profile> clazz = ICC_Profile.class;
                synchronized (ICC_Profile.class) {
                    if (LINEAR_RGBprofile != null) return LINEAR_RGBprofile;
                    ProfileDeferralInfo profileDeferralInfo = new ProfileDeferralInfo("LINEAR_RGB.pf", 5, 3, 1);
                    LINEAR_RGBprofile = ICC_Profile.getDeferredInstance(profileDeferralInfo);
                    return LINEAR_RGBprofile;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
    }

    private static ICC_Profile getStandardProfile(final String string) {
        return (ICC_Profile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ICC_Profile iCC_Profile = null;
                try {
                    iCC_Profile = ICC_Profile.getInstance(string);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Can't load standard profile: " + string);
                }
                return iCC_Profile;
            }
        });
    }

    public static ICC_Profile getInstance(String string) throws IOException {
        FileInputStream fileInputStream = null;
        File file = ICC_Profile.getProfileFile(string);
        if (file != null) {
            fileInputStream = new FileInputStream(file);
        }
        if (fileInputStream == null) {
            throw new IOException("Cannot open file " + string);
        }
        ICC_Profile iCC_Profile = ICC_Profile.getInstance(fileInputStream);
        fileInputStream.close();
        return iCC_Profile;
    }

    public static ICC_Profile getInstance(InputStream inputStream) throws IOException {
        if (inputStream instanceof ProfileDeferralInfo) {
            return ICC_Profile.getDeferredInstance((ProfileDeferralInfo)inputStream);
        }
        byte[] byArray = ICC_Profile.getProfileDataFromStream(inputStream);
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        return ICC_Profile.getInstance(byArray);
    }

    static byte[] getProfileDataFromStream(InputStream inputStream) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[128];
        int n3 = 0;
        for (n = 128; n != 0; n -= n2) {
            n2 = inputStream.read(byArray, n3, n);
            if (n2 < 0) {
                return null;
            }
            n3 += n2;
        }
        if (byArray[36] != 97 || byArray[37] != 99 || byArray[38] != 115 || byArray[39] != 112) {
            return null;
        }
        int n4 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, 128);
        n3 = 128;
        for (n = n4 - 128; n != 0; n -= n2) {
            n2 = inputStream.read(byArray2, n3, n);
            if (n2 < 0) {
                return null;
            }
            n3 += n2;
        }
        return byArray2;
    }

    static ICC_Profile getDeferredInstance(ProfileDeferralInfo profileDeferralInfo) {
        if (!ProfileDeferralMgr.deferring) {
            return ICC_Profile.getStandardProfile(profileDeferralInfo.filename);
        }
        if (profileDeferralInfo.colorSpaceType == 5) {
            return new ICC_ProfileRGB(profileDeferralInfo);
        }
        if (profileDeferralInfo.colorSpaceType == 6) {
            return new ICC_ProfileGray(profileDeferralInfo);
        }
        return new ICC_Profile(profileDeferralInfo);
    }

    void activateDeferredProfile() throws ProfileDataException {
        byte[] byArray;
        final String string = this.deferralInfo.filename;
        this.profileActivator = null;
        this.deferralInfo = null;
        PrivilegedAction<FileInputStream> privilegedAction = new PrivilegedAction<FileInputStream>(){

            @Override
            public FileInputStream run() {
                File file = ICC_Profile.getStandardProfileFile(string);
                if (file != null) {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        FileInputStream fileInputStream = AccessController.doPrivileged(privilegedAction);
        if (fileInputStream == null) {
            throw new ProfileDataException("Cannot open file " + string);
        }
        try {
            byArray = ICC_Profile.getProfileDataFromStream(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ProfileDataException profileDataException = new ProfileDataException("Invalid ICC Profile Data" + string);
            profileDataException.initCause(iOException);
            throw profileDataException;
        }
        if (byArray == null) {
            throw new ProfileDataException("Invalid ICC Profile Data" + string);
        }
        try {
            this.ID = CMSManager.getModule().loadProfile(byArray);
        }
        catch (CMMException cMMException) {
            ProfileDataException profileDataException = new ProfileDataException("Invalid ICC Profile Data" + string);
            profileDataException.initCause(cMMException);
            throw profileDataException;
        }
    }

    public int getMajorVersion() {
        byte[] byArray = this.getData(1751474532);
        return byArray[8];
    }

    public int getMinorVersion() {
        byte[] byArray = this.getData(1751474532);
        return byArray[9];
    }

    public int getProfileClass() {
        int n;
        if (this.deferralInfo != null) {
            return this.deferralInfo.profileClass;
        }
        byte[] byArray = this.getData(1751474532);
        int n2 = ICC_Profile.intFromBigEndian(byArray, 12);
        switch (n2) {
            case 1935896178: {
                n = 0;
                break;
            }
            case 1835955314: {
                n = 1;
                break;
            }
            case 1886549106: {
                n = 2;
                break;
            }
            case 1818848875: {
                n = 3;
                break;
            }
            case 1936744803: {
                n = 4;
                break;
            }
            case 1633842036: {
                n = 5;
                break;
            }
            case 1852662636: {
                n = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown profile class");
            }
        }
        return n;
    }

    public int getColorSpaceType() {
        if (this.deferralInfo != null) {
            return this.deferralInfo.colorSpaceType;
        }
        return ICC_Profile.getColorSpaceType(this.ID);
    }

    static int getColorSpaceType(long l) {
        byte[] byArray = ICC_Profile.getData(l, 1751474532);
        int n = ICC_Profile.intFromBigEndian(byArray, 16);
        int n2 = ICC_Profile.iccCStoJCS(n);
        return n2;
    }

    public int getPCSType() {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        return ICC_Profile.getPCSType(this.ID);
    }

    static int getPCSType(long l) {
        byte[] byArray = ICC_Profile.getData(l, 1751474532);
        int n = ICC_Profile.intFromBigEndian(byArray, 20);
        int n2 = ICC_Profile.iccCStoJCS(n);
        return n2;
    }

    public void write(String string) throws IOException {
        byte[] byArray = this.getData();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getData();
        outputStream.write(byArray);
    }

    public byte[] getData() {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        PCMM pCMM = CMSManager.getModule();
        int n = pCMM.getProfileSize(this.ID);
        byte[] byArray = new byte[n];
        pCMM.getProfileData(this.ID, byArray);
        return byArray;
    }

    public byte[] getData(int n) {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        return ICC_Profile.getData(this.ID, n);
    }

    static byte[] getData(long l, int n) {
        byte[] byArray;
        try {
            PCMM pCMM = CMSManager.getModule();
            int n2 = pCMM.getTagSize(l, n);
            byArray = new byte[n2];
            pCMM.getTagData(l, n, byArray);
        }
        catch (CMMException cMMException) {
            byArray = null;
        }
        return byArray;
    }

    public void setData(int n, byte[] byArray) {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
        CMSManager.getModule().setTagData(this.ID, n, byArray);
    }

    void setRenderingIntent(int n) {
        byte[] byArray = this.getData(1751474532);
        ICC_Profile.intToBigEndian(n, byArray, 64);
        this.setData(1751474532, byArray);
    }

    int getRenderingIntent() {
        byte[] byArray = this.getData(1751474532);
        int n = ICC_Profile.intFromBigEndian(byArray, 64);
        return n;
    }

    public int getNumComponents() {
        int n;
        if (this.deferralInfo != null) {
            return this.deferralInfo.numComponents;
        }
        byte[] byArray = this.getData(1751474532);
        int n2 = ICC_Profile.intFromBigEndian(byArray, 16);
        switch (n2) {
            case 1196573017: {
                n = 1;
                break;
            }
            case 843271250: {
                n = 2;
                break;
            }
            case 860048466: 
            case 1129142560: 
            case 1212961568: 
            case 1213421088: 
            case 1281450528: 
            case 1282766368: 
            case 1380401696: 
            case 1482250784: 
            case 1497588338: 
            case 1501067552: {
                n = 3;
                break;
            }
            case 876825682: 
            case 1129142603: {
                n = 4;
                break;
            }
            case 893602898: {
                n = 5;
                break;
            }
            case 910380114: {
                n = 6;
                break;
            }
            case 927157330: {
                n = 7;
                break;
            }
            case 943934546: {
                n = 8;
                break;
            }
            case 960711762: {
                n = 9;
                break;
            }
            case 1094929490: {
                n = 10;
                break;
            }
            case 1111706706: {
                n = 11;
                break;
            }
            case 1128483922: {
                n = 12;
                break;
            }
            case 1145261138: {
                n = 13;
                break;
            }
            case 1162038354: {
                n = 14;
                break;
            }
            case 1178815570: {
                n = 15;
                break;
            }
            default: {
                throw new ProfileDataException("invalid ICC color space");
            }
        }
        return n;
    }

    float[] getMediaWhitePoint() {
        return this.getXYZTag(0x77747074);
    }

    float[] getXYZTag(int n) {
        byte[] byArray = this.getData(n);
        float[] fArray = new float[3];
        int n2 = 0;
        int n3 = 8;
        while (n2 < 3) {
            int n4 = ICC_Profile.intFromBigEndian(byArray, n3);
            fArray[n2] = (float)n4 / 65536.0f;
            ++n2;
            n3 += 4;
        }
        return fArray;
    }

    float getGamma(int n) {
        byte[] byArray = this.getData(n);
        if (ICC_Profile.intFromBigEndian(byArray, 8) != 1) {
            throw new ProfileDataException("TRC is not a gamma");
        }
        int n2 = ICC_Profile.shortFromBigEndian(byArray, 12) & 0xFFFF;
        float f = (float)n2 / 256.0f;
        return f;
    }

    short[] getTRC(int n) {
        byte[] byArray = this.getData(n);
        int n2 = ICC_Profile.intFromBigEndian(byArray, 8);
        if (n2 == 1) {
            throw new ProfileDataException("TRC is not a table");
        }
        short[] sArray = new short[n2];
        int n3 = 0;
        int n4 = 12;
        while (n3 < n2) {
            sArray[n3] = ICC_Profile.shortFromBigEndian(byArray, n4);
            ++n3;
            n4 += 2;
        }
        return sArray;
    }

    static int iccCStoJCS(int n) {
        int n2;
        switch (n) {
            case 1482250784: {
                n2 = 0;
                break;
            }
            case 1281450528: {
                n2 = 1;
                break;
            }
            case 1282766368: {
                n2 = 2;
                break;
            }
            case 1497588338: {
                n2 = 3;
                break;
            }
            case 1501067552: {
                n2 = 4;
                break;
            }
            case 1380401696: {
                n2 = 5;
                break;
            }
            case 1196573017: {
                n2 = 6;
                break;
            }
            case 1213421088: {
                n2 = 7;
                break;
            }
            case 1212961568: {
                n2 = 8;
                break;
            }
            case 1129142603: {
                n2 = 9;
                break;
            }
            case 1129142560: {
                n2 = 11;
                break;
            }
            case 843271250: {
                n2 = 12;
                break;
            }
            case 860048466: {
                n2 = 13;
                break;
            }
            case 876825682: {
                n2 = 14;
                break;
            }
            case 893602898: {
                n2 = 15;
                break;
            }
            case 910380114: {
                n2 = 16;
                break;
            }
            case 927157330: {
                n2 = 17;
                break;
            }
            case 943934546: {
                n2 = 18;
                break;
            }
            case 960711762: {
                n2 = 19;
                break;
            }
            case 1094929490: {
                n2 = 20;
                break;
            }
            case 1111706706: {
                n2 = 21;
                break;
            }
            case 1128483922: {
                n2 = 22;
                break;
            }
            case 1145261138: {
                n2 = 23;
                break;
            }
            case 1162038354: {
                n2 = 24;
                break;
            }
            case 1178815570: {
                n2 = 25;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown color space");
            }
        }
        return n2;
    }

    static int intFromBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static void intToBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    static short shortFromBigEndian(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    static void shortToBigEndian(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    private static File getProfileFile(String string) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer;
        String string4;
        File file = new File(string);
        if (file.isAbsolute()) {
            return file.isFile() ? file : null;
        }
        if (!file.isFile() && (string4 = System.getProperty("java.iccprofile.path")) != null) {
            stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && (file == null || !file.isFile())) {
                string3 = stringTokenizer.nextToken();
                string2 = string3 + File.separatorChar + string;
                file = new File(string2);
                if (ICC_Profile.isChildOf(file, string3)) continue;
                file = null;
            }
        }
        if (!(file != null && file.isFile() || (string4 = System.getProperty("java.class.path")) == null)) {
            stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && (file == null || !file.isFile())) {
                string3 = stringTokenizer.nextToken();
                string2 = string3 + File.separatorChar + string;
                file = new File(string2);
            }
        }
        if (file == null || !file.isFile()) {
            file = ICC_Profile.getStandardProfileFile(string);
        }
        if (file != null && file.isFile()) {
            return file;
        }
        return null;
    }

    private static File getStandardProfileFile(String string) {
        BootClassLoaderHook bootClassLoaderHook;
        String string2 = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "cmm";
        String string3 = string2 + File.separatorChar + string;
        File file = new File(string3);
        if (!file.isFile() && (bootClassLoaderHook = BootClassLoaderHook.getHook()) != null) {
            bootClassLoaderHook.prefetchFile("lib/cmm/" + string);
        }
        return file.isFile() && ICC_Profile.isChildOf(file, string2) ? file : null;
    }

    private static boolean isChildOf(File file, String string) {
        try {
            File file2 = new File(string);
            String string2 = file2.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            String string3 = file.getCanonicalPath();
            return string3.startsWith(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean standardProfileExists(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ICC_Profile.getStandardProfileFile(string) != null;
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        String string = null;
        if (this == sRGBprofile) {
            string = "CS_sRGB";
        } else if (this == XYZprofile) {
            string = "CS_CIEXYZ";
        } else if (this == PYCCprofile) {
            string = "CS_PYCC";
        } else if (this == GRAYprofile) {
            string = "CS_GRAY";
        } else if (this == LINEAR_RGBprofile) {
            string = "CS_LINEAR_RGB";
        }
        byte[] byArray = null;
        if (string == null) {
            byArray = this.getData();
        }
        objectOutputStream.writeObject(string);
        objectOutputStream.writeObject(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        int n = 0;
        boolean bl = false;
        if (string != null) {
            bl = true;
            if (string.equals("CS_sRGB")) {
                n = 1000;
            } else if (string.equals("CS_CIEXYZ")) {
                n = 1001;
            } else if (string.equals("CS_PYCC")) {
                n = 1002;
            } else if (string.equals("CS_GRAY")) {
                n = 1003;
            } else if (string.equals("CS_LINEAR_RGB")) {
                n = 1004;
            } else {
                bl = false;
            }
        }
        this.resolvedDeserializedProfile = bl ? ICC_Profile.getInstance(n) : ICC_Profile.getInstance(byArray);
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.resolvedDeserializedProfile;
    }
}

