/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int ushortMask = 65535;
    private static final int phaseMask = Integer.MAX_VALUE;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ = new AtomicReference();
    private final AtomicReference<QNode> oddQ = new AtomicReference();
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long stateOffset = Phaser.objectFieldOffset("state", Phaser.class);

    private static int unarrivedOf(long l) {
        return (int)(l & 0xFFFFL);
    }

    private static int partiesOf(long l) {
        return (int)l >>> 16;
    }

    private static int phaseOf(long l) {
        return (int)(l >>> 32);
    }

    private static int arrivedOf(long l) {
        return Phaser.partiesOf(l) - Phaser.unarrivedOf(l);
    }

    private static long stateFor(int n, int n2, int n3) {
        return (long)n << 32 | (long)n2 << 16 | (long)n3;
    }

    private static long trippedStateFor(int n, int n2) {
        long l = n2;
        return (long)n << 32 | l << 16 | l;
    }

    private static String badBounds(int n, int n2) {
        return "Attempt to set " + n2 + " unarrived of " + n + " parties";
    }

    private AtomicReference<QNode> queueFor(int n) {
        return (n & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private long getReconciledState() {
        return this.parent == null ? this.state : this.reconcileState();
    }

    private long reconcileState() {
        Phaser phaser = this.parent;
        long l = this.state;
        if (phaser != null) {
            while (Phaser.unarrivedOf(l) == 0 && Phaser.phaseOf(l) != Phaser.phaseOf(this.root.state)) {
                long l2;
                long l3 = phaser.getReconciledState();
                int n = Phaser.phaseOf(l3);
                l = this.state;
                int n2 = Phaser.phaseOf(l);
                if (n2 == n || !this.casState(l, l2 = Phaser.trippedStateFor(n, Phaser.partiesOf(l)))) continue;
                this.releaseWaiters(n2);
                l = l2;
            }
        }
        return l;
    }

    public Phaser() {
        this(null);
    }

    public Phaser(int n) {
        this(null, n);
    }

    public Phaser(Phaser phaser) {
        int n = 0;
        this.parent = phaser;
        if (phaser != null) {
            this.root = phaser.root;
            n = phaser.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(n, 0);
    }

    public Phaser(Phaser phaser, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int n2 = 0;
        this.parent = phaser;
        if (phaser != null) {
            this.root = phaser.root;
            n2 = phaser.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(n2, n);
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this.getPhase();
        }
        return this.doRegister(n);
    }

    private int doRegister(int n) {
        int n2;
        int n3;
        long l;
        int n4;
        do {
            l = this.getReconciledState();
            n4 = Phaser.phaseOf(l);
            n2 = Phaser.unarrivedOf(l) + n;
            n3 = Phaser.partiesOf(l) + n;
            if (n4 < 0) break;
            if (n3 <= 65535 && n2 <= 65535) continue;
            throw new IllegalStateException(Phaser.badBounds(n3, n2));
        } while (n4 != Phaser.phaseOf(this.root.state) || !this.casState(l, Phaser.stateFor(n4, n3, n2)));
        return n4;
    }

    public int arrive() {
        long l;
        int n;
        while ((n = Phaser.phaseOf(l = this.state)) >= 0) {
            int n2 = Phaser.partiesOf(l);
            int n3 = Phaser.unarrivedOf(l) - 1;
            if (n3 > 0) {
                if (!this.casState(l, l - 1L)) continue;
                break;
            }
            if (n3 == 0) {
                Phaser phaser = this.parent;
                if (phaser == null) {
                    if (!this.casState(l, Phaser.trippedStateFor(this.onAdvance(n, n2) ? -1 : n + 1 & Integer.MAX_VALUE, n2))) continue;
                    this.releaseWaiters(n);
                    break;
                }
                if (!this.casState(l, l - 1L)) continue;
                phaser.arrive();
                this.reconcileState();
                break;
            }
            if (n != Phaser.phaseOf(this.root.state)) {
                this.reconcileState();
                continue;
            }
            throw new IllegalStateException(Phaser.badBounds(n2, n3));
        }
        return n;
    }

    public int arriveAndDeregister() {
        long l;
        int n;
        Phaser phaser = this.parent;
        while ((n = Phaser.phaseOf(l = this.state)) >= 0) {
            int n2 = Phaser.partiesOf(l) - 1;
            int n3 = Phaser.unarrivedOf(l) - 1;
            if (n2 >= 0) {
                if (n3 > 0 || n3 == 0 && phaser != null) {
                    if (!this.casState(l, Phaser.stateFor(n, n2, n3))) continue;
                    if (n3 != 0) break;
                    phaser.arriveAndDeregister();
                    this.reconcileState();
                    break;
                }
                if (n3 == 0) {
                    if (!this.casState(l, Phaser.trippedStateFor(this.onAdvance(n, n2) ? -1 : n + 1 & Integer.MAX_VALUE, n2))) continue;
                    this.releaseWaiters(n);
                    break;
                }
                if (phaser != null && n != Phaser.phaseOf(this.root.state)) {
                    this.reconcileState();
                    continue;
                }
            }
            throw new IllegalStateException(Phaser.badBounds(n2, n3));
        }
        return n;
    }

    public int arriveAndAwaitAdvance() {
        return this.awaitAdvance(this.arrive());
    }

    public int awaitAdvance(int n) {
        if (n < 0) {
            return n;
        }
        long l = this.getReconciledState();
        int n2 = Phaser.phaseOf(l);
        if (n2 != n) {
            return n2;
        }
        if (Phaser.unarrivedOf(l) == 0 && this.parent != null) {
            this.parent.awaitAdvance(n);
        }
        return this.untimedWait(n);
    }

    public int awaitAdvanceInterruptibly(int n) throws InterruptedException {
        if (n < 0) {
            return n;
        }
        long l = this.getReconciledState();
        int n2 = Phaser.phaseOf(l);
        if (n2 != n) {
            return n2;
        }
        if (Phaser.unarrivedOf(l) == 0 && this.parent != null) {
            this.parent.awaitAdvanceInterruptibly(n);
        }
        return this.interruptibleWait(n);
    }

    public int awaitAdvanceInterruptibly(int n, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (n < 0) {
            return n;
        }
        long l2 = this.getReconciledState();
        int n2 = Phaser.phaseOf(l2);
        if (n2 != n) {
            return n2;
        }
        if (Phaser.unarrivedOf(l2) == 0 && this.parent != null) {
            this.parent.awaitAdvanceInterruptibly(n, l, timeUnit);
        }
        return this.timedWait(n, timeUnit.toNanos(l));
    }

    public void forceTermination() {
        int n;
        int n2;
        long l;
        int n3;
        do {
            l = this.getReconciledState();
            n3 = Phaser.phaseOf(l);
            n2 = Phaser.partiesOf(l);
            n = Phaser.unarrivedOf(l);
        } while (n3 >= 0 && !this.casState(l, Phaser.stateFor(-1, n2, n)));
        this.releaseWaiters(0);
        this.releaseWaiters(1);
        if (this.parent != null) {
            this.parent.forceTermination();
        }
    }

    public final int getPhase() {
        return Phaser.phaseOf(this.getReconciledState());
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.state);
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.state);
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.getPhase() < 0;
    }

    protected boolean onAdvance(int n, int n2) {
        return n2 <= 0;
    }

    public String toString() {
        long l = this.getReconciledState();
        return super.toString() + "[phase = " + Phaser.phaseOf(l) + " parties = " + Phaser.partiesOf(l) + " arrived = " + Phaser.arrivedOf(l) + "]";
    }

    private void releaseWaiters(int n) {
        QNode qNode;
        AtomicReference<QNode> atomicReference = this.queueFor(n);
        while ((qNode = atomicReference.get()) != null) {
            if (!atomicReference.compareAndSet(qNode, qNode.next)) continue;
            qNode.signal();
        }
    }

    private boolean tryEnqueue(QNode qNode) {
        AtomicReference<QNode> atomicReference = this.queueFor(qNode.phase);
        qNode.next = atomicReference.get();
        return atomicReference.compareAndSet(qNode.next, qNode);
    }

    private int untimedWait(int n) {
        int n2;
        QNode qNode = null;
        boolean bl = false;
        boolean bl2 = false;
        while ((n2 = this.getPhase()) == n) {
            if (Thread.interrupted()) {
                bl2 = true;
                continue;
            }
            if (qNode == null) {
                qNode = new QNode(this, n, false, false, 0L, 0L);
                continue;
            }
            if (!bl) {
                bl = this.tryEnqueue(qNode);
                continue;
            }
            bl2 = qNode.doWait();
        }
        if (qNode != null) {
            qNode.thread = null;
        }
        this.releaseWaiters(n);
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return n2;
    }

    private int interruptibleWait(int n) throws InterruptedException {
        int n2;
        QNode qNode = null;
        boolean bl = false;
        boolean bl2 = false;
        while ((n2 = this.getPhase()) == n && !bl2) {
            if (Thread.interrupted()) {
                bl2 = true;
                continue;
            }
            if (qNode == null) {
                qNode = new QNode(this, n, true, false, 0L, 0L);
                continue;
            }
            if (!bl) {
                bl = this.tryEnqueue(qNode);
                continue;
            }
            bl2 = qNode.doWait();
        }
        if (qNode != null) {
            qNode.thread = null;
        }
        if (n2 != n || (n2 = this.getPhase()) != n) {
            this.releaseWaiters(n);
        }
        if (bl2) {
            throw new InterruptedException();
        }
        return n2;
    }

    private int timedWait(int n, long l) throws InterruptedException, TimeoutException {
        int n2;
        long l2 = System.nanoTime();
        QNode qNode = null;
        boolean bl = false;
        boolean bl2 = false;
        while ((n2 = this.getPhase()) == n && !bl2) {
            if (Thread.interrupted()) {
                bl2 = true;
                continue;
            }
            if (l - (System.nanoTime() - l2) <= 0L) break;
            if (qNode == null) {
                qNode = new QNode(this, n, true, true, l2, l);
                continue;
            }
            if (!bl) {
                bl = this.tryEnqueue(qNode);
                continue;
            }
            bl2 = qNode.doWait();
        }
        if (qNode != null) {
            qNode.thread = null;
        }
        if (n2 != n || (n2 = this.getPhase()) != n) {
            this.releaseWaiters(n);
        }
        if (bl2) {
            throw new InterruptedException();
        }
        if (n2 == n) {
            throw new TimeoutException();
        }
        return n2;
    }

    private final boolean casState(long l, long l2) {
        return UNSAFE.compareAndSwapLong(this, stateOffset, l, l2);
    }

    private static long objectFieldOffset(String string, Class<?> clazz) {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    static final class QNode
    implements ForkJoinPool.ManagedBlocker {
        final Phaser phaser;
        final int phase;
        final long startTime;
        final long nanos;
        final boolean timed;
        final boolean interruptible;
        volatile boolean wasInterrupted = false;
        volatile Thread thread;
        QNode next;

        QNode(Phaser phaser, int n, boolean bl, boolean bl2, long l, long l2) {
            this.phaser = phaser;
            this.phase = n;
            this.timed = bl2;
            this.interruptible = bl;
            this.startTime = l;
            this.nanos = l2;
            this.thread = Thread.currentThread();
        }

        @Override
        public boolean isReleasable() {
            return this.thread == null || this.phaser.getPhase() != this.phase || this.interruptible && this.wasInterrupted || this.timed && this.nanos - (System.nanoTime() - this.startTime) <= 0L;
        }

        @Override
        public boolean block() {
            if (Thread.interrupted()) {
                this.wasInterrupted = true;
                if (this.interruptible) {
                    return true;
                }
            }
            if (!this.timed) {
                LockSupport.park(this);
            } else {
                long l = this.nanos - (System.nanoTime() - this.startTime);
                if (l <= 0L) {
                    return true;
                }
                LockSupport.parkNanos(this, l);
            }
            return this.isReleasable();
        }

        void signal() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }

        boolean doWait() {
            if (this.thread != null) {
                try {
                    ForkJoinPool.managedBlock(this);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.wasInterrupted;
        }
    }
}

