/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.jcp.xml.dsig.internal.dom.DOMCryptoBinary;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyValue
extends DOMStructure
implements KeyValue {
    private KeyFactory rsakf;
    private KeyFactory dsakf;
    private PublicKey publicKey;
    private javax.xml.crypto.dom.DOMStructure externalPublicKey;
    private DOMCryptoBinary p;
    private DOMCryptoBinary q;
    private DOMCryptoBinary g;
    private DOMCryptoBinary y;
    private DOMCryptoBinary j;
    private DOMCryptoBinary seed;
    private DOMCryptoBinary pgen;
    private DOMCryptoBinary modulus;
    private DOMCryptoBinary exponent;

    public DOMKeyValue(PublicKey publicKey) throws KeyException {
        if (publicKey == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.publicKey = publicKey;
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            this.p = new DOMCryptoBinary(dSAParams.getP());
            this.q = new DOMCryptoBinary(dSAParams.getQ());
            this.g = new DOMCryptoBinary(dSAParams.getG());
            this.y = new DOMCryptoBinary(dSAPublicKey.getY());
        } else if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            this.exponent = new DOMCryptoBinary(rSAPublicKey.getPublicExponent());
            this.modulus = new DOMCryptoBinary(rSAPublicKey.getModulus());
        } else {
            throw new KeyException("unsupported key algorithm: " + publicKey.getAlgorithm());
        }
    }

    public DOMKeyValue(Element element) throws MarshalException {
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2.getLocalName().equals("DSAKeyValue")) {
            this.publicKey = this.unmarshalDSAKeyValue(element2);
        } else if (element2.getLocalName().equals("RSAKeyValue")) {
            this.publicKey = this.unmarshalRSAKeyValue(element2);
        } else {
            this.publicKey = null;
            this.externalPublicKey = new javax.xml.crypto.dom.DOMStructure(element2);
        }
    }

    @Override
    public PublicKey getPublicKey() throws KeyException {
        if (this.publicKey == null) {
            throw new KeyException("can't convert KeyValue to PublicKey");
        }
        return this.publicKey;
    }

    @Override
    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "KeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
        this.marshalPublicKey(element, document, string, dOMCryptoContext);
        node.appendChild(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (this.publicKey != null) {
            if (this.publicKey instanceof DSAPublicKey) {
                this.marshalDSAPublicKey(node, document, string, dOMCryptoContext);
                return;
            } else {
                if (!(this.publicKey instanceof RSAPublicKey)) throw new MarshalException(this.publicKey.getAlgorithm() + " public key algorithm not supported");
                this.marshalRSAPublicKey(node, document, string, dOMCryptoContext);
            }
            return;
        } else {
            node.appendChild(this.externalPublicKey.getNode());
        }
    }

    private void marshalDSAPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element = DOMUtils.createElement(document, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element2 = DOMUtils.createElement(document, "P", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element3 = DOMUtils.createElement(document, "Q", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element4 = DOMUtils.createElement(document, "G", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element5 = DOMUtils.createElement(document, "Y", "http://www.w3.org/2000/09/xmldsig#", string);
        this.p.marshal(element2, string, dOMCryptoContext);
        this.q.marshal(element3, string, dOMCryptoContext);
        this.g.marshal(element4, string, dOMCryptoContext);
        this.y.marshal(element5, string, dOMCryptoContext);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        node.appendChild(element);
    }

    private void marshalRSAPublicKey(Node node, Document document, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Element element = DOMUtils.createElement(document, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element2 = DOMUtils.createElement(document, "Modulus", "http://www.w3.org/2000/09/xmldsig#", string);
        Element element3 = DOMUtils.createElement(document, "Exponent", "http://www.w3.org/2000/09/xmldsig#", string);
        this.modulus.marshal(element2, string, dOMCryptoContext);
        this.exponent.marshal(element3, string, dOMCryptoContext);
        element.appendChild(element2);
        element.appendChild(element3);
        node.appendChild(element);
    }

    private DSAPublicKey unmarshalDSAKeyValue(Element element) throws MarshalException {
        Element element2;
        if (this.dsakf == null) {
            try {
                this.dsakf = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("unable to create DSA KeyFactory: " + noSuchAlgorithmException.getMessage());
            }
        }
        if ((element2 = DOMUtils.getFirstChildElement(element)).getLocalName().equals("P")) {
            this.p = new DOMCryptoBinary(element2.getFirstChild());
            element2 = DOMUtils.getNextSiblingElement(element2);
            this.q = new DOMCryptoBinary(element2.getFirstChild());
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (element2.getLocalName().equals("G")) {
            this.g = new DOMCryptoBinary(element2.getFirstChild());
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.y = new DOMCryptoBinary(element2.getFirstChild());
        if ((element2 = DOMUtils.getNextSiblingElement(element2)) != null && element2.getLocalName().equals("J")) {
            this.j = new DOMCryptoBinary(element2.getFirstChild());
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (element2 != null) {
            this.seed = new DOMCryptoBinary(element2.getFirstChild());
            element2 = DOMUtils.getNextSiblingElement(element2);
            this.pgen = new DOMCryptoBinary(element2.getFirstChild());
        }
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.y.getBigNum(), this.p.getBigNum(), this.q.getBigNum(), this.g.getBigNum());
        return (DSAPublicKey)this.generatePublicKey(this.dsakf, dSAPublicKeySpec);
    }

    private RSAPublicKey unmarshalRSAKeyValue(Element element) throws MarshalException {
        if (this.rsakf == null) {
            try {
                this.rsakf = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("unable to create RSA KeyFactory: " + noSuchAlgorithmException.getMessage());
            }
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        this.modulus = new DOMCryptoBinary(element2.getFirstChild());
        Element element3 = DOMUtils.getNextSiblingElement(element2);
        this.exponent = new DOMCryptoBinary(element3.getFirstChild());
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.modulus.getBigNum(), this.exponent.getBigNum());
        return (RSAPublicKey)this.generatePublicKey(this.rsakf, rSAPublicKeySpec);
    }

    private PublicKey generatePublicKey(KeyFactory keyFactory, KeySpec keySpec) {
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue keyValue = (KeyValue)object;
            if (this.publicKey == null ? keyValue.getPublicKey() != null : !this.publicKey.equals(keyValue.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException keyException) {
            return false;
        }
        return true;
    }
}

