/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.AttributeMap;
import sun.font.AttributeValues;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontRunIterator;
import sun.font.FontStrikeDesc;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.ScriptRun;
import sun.font.StandardGlyphVector;
import sun.font.SunLayoutEngine;
import sun.font.TextRecord;

public final class GlyphLayout {
    private GVData _gvdata = new GVData();
    private static volatile GlyphLayout cache;
    private LayoutEngineFactory _lef;
    private TextRecord _textRecord = new TextRecord();
    private ScriptRun _scriptRuns = new ScriptRun();
    private FontRunIterator _fontRuns = new FontRunIterator();
    private int _ercount;
    private ArrayList _erecords = new ArrayList(10);
    private Point2D.Float _pt = new Point2D.Float();
    private FontStrikeDesc _sd = new FontStrikeDesc();
    private float[] _mat = new float[4];
    private int _typo_flags;
    private int _offset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphLayout get(LayoutEngineFactory layoutEngineFactory) {
        if (layoutEngineFactory == null) {
            layoutEngineFactory = SunLayoutEngine.instance();
        }
        GlyphLayout glyphLayout = null;
        Class<GlyphLayout> clazz = GlyphLayout.class;
        synchronized (GlyphLayout.class) {
            if (cache != null) {
                glyphLayout = cache;
                cache = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (glyphLayout == null) {
                glyphLayout = new GlyphLayout();
            }
            glyphLayout._lef = layoutEngineFactory;
            return glyphLayout;
        }
    }

    public static void done(GlyphLayout glyphLayout) {
        glyphLayout._lef = null;
        cache = glyphLayout;
    }

    public StandardGlyphVector layout(Font font, FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3, StandardGlyphVector standardGlyphVector) {
        int n4;
        int n5;
        Object object;
        if (cArray == null || n < 0 || n2 < 0 || n2 > cArray.length - n) {
            throw new IllegalArgumentException();
        }
        this.init(n2);
        if (font.hasLayoutAttributes()) {
            object = ((AttributeMap)font.getAttributes()).getValues();
            if (((AttributeValues)object).getKerning() != 0) {
                this._typo_flags |= 1;
            }
            if (((AttributeValues)object).getLigatures() != 0) {
                this._typo_flags |= 2;
            }
        }
        this._offset = n;
        object = SDCache.get(font, fontRenderContext);
        this._mat[0] = (float)((SDCache)object).gtx.getScaleX();
        this._mat[1] = (float)((SDCache)object).gtx.getShearY();
        this._mat[2] = (float)((SDCache)object).gtx.getShearX();
        this._mat[3] = (float)((SDCache)object).gtx.getScaleY();
        this._pt.setLocation(((SDCache)object).delta);
        int n6 = n + n2;
        int n7 = 0;
        int n8 = cArray.length;
        if (n3 != 0) {
            if ((n3 & 1) != 0) {
                this._typo_flags |= Integer.MIN_VALUE;
            }
            if ((n3 & 2) != 0) {
                n7 = n;
            }
            if ((n3 & 4) != 0) {
                n8 = n6;
            }
        }
        int n9 = -1;
        Font2D font2D = FontUtilities.getFont2D(font);
        this._textRecord.init(cArray, n, n6, n7, n8);
        int n10 = n;
        if (font2D instanceof CompositeFont) {
            this._scriptRuns.init(cArray, n, n2);
            this._fontRuns.init((CompositeFont)font2D, cArray, n, n6);
            while (this._scriptRuns.next()) {
                n5 = this._scriptRuns.getScriptLimit();
                n4 = this._scriptRuns.getScriptCode();
                while (this._fontRuns.next(n4, n5)) {
                    PhysicalFont physicalFont = this._fontRuns.getFont();
                    if (physicalFont instanceof NativeFont) {
                        physicalFont = ((NativeFont)physicalFont).getDelegateFont();
                    }
                    int n11 = this._fontRuns.getGlyphMask();
                    int n12 = this._fontRuns.getPos();
                    this.nextEngineRecord(n10, n12, n4, n9, physicalFont, n11);
                    n10 = n12;
                }
            }
        } else {
            this._scriptRuns.init(cArray, n, n2);
            while (this._scriptRuns.next()) {
                n5 = this._scriptRuns.getScriptLimit();
                n4 = this._scriptRuns.getScriptCode();
                this.nextEngineRecord(n10, n5, n4, n9, font2D, 0);
                n10 = n5;
            }
        }
        n5 = 0;
        n4 = this._ercount;
        int n13 = 1;
        if (this._typo_flags < 0) {
            n5 = n4 - 1;
            n4 = -1;
            n13 = -1;
        }
        this._sd = ((SDCache)object).sd;
        while (n5 != n4) {
            EngineRecord engineRecord = (EngineRecord)this._erecords.get(n5);
            while (true) {
                try {
                    engineRecord.layout();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this._gvdata.grow();
                    continue;
                }
                break;
            }
            n5 += n13;
        }
        StandardGlyphVector standardGlyphVector2 = this._gvdata.createGlyphVector(font, fontRenderContext, standardGlyphVector);
        return standardGlyphVector2;
    }

    private GlyphLayout() {
    }

    private void init(int n) {
        this._typo_flags = 0;
        this._ercount = 0;
        this._gvdata.init(n);
    }

    private void nextEngineRecord(int n, int n2, int n3, int n4, Font2D font2D, int n5) {
        EngineRecord engineRecord = null;
        if (this._ercount == this._erecords.size()) {
            engineRecord = new EngineRecord();
            this._erecords.add(engineRecord);
        } else {
            engineRecord = (EngineRecord)this._erecords.get(this._ercount);
        }
        engineRecord.init(n, n2, font2D, n3, n4, n5);
        ++this._ercount;
    }

    private final class EngineRecord {
        private int start;
        private int limit;
        private int gmask;
        private int eflags;
        private LayoutEngineKey key = new LayoutEngineKey();
        private LayoutEngine engine;

        EngineRecord() {
        }

        void init(int n, int n2, Font2D font2D, int n3, int n4, int n5) {
            this.start = n;
            this.limit = n2;
            this.gmask = n5;
            this.key.init(font2D, n3, n4);
            this.eflags = 0;
            for (int i = n; i < n2; ++i) {
                int n6;
                int n7 = ((GlyphLayout)GlyphLayout.this)._textRecord.text[i];
                if (Character.isHighSurrogate((char)n7) && i < n2 - 1 && Character.isLowSurrogate(((GlyphLayout)GlyphLayout.this)._textRecord.text[i + 1])) {
                    n7 = Character.toCodePoint((char)n7, ((GlyphLayout)GlyphLayout.this)._textRecord.text[++i]);
                }
                if ((n6 = Character.getType(n7)) != 6 && n6 != 7 && n6 != 8) continue;
                this.eflags = 4;
                break;
            }
            this.engine = GlyphLayout.this._lef.getEngine(this.key);
        }

        void layout() {
            ((GlyphLayout)GlyphLayout.this)._textRecord.start = this.start;
            ((GlyphLayout)GlyphLayout.this)._textRecord.limit = this.limit;
            this.engine.layout(GlyphLayout.this._sd, GlyphLayout.this._mat, this.gmask, this.start - GlyphLayout.this._offset, GlyphLayout.this._textRecord, GlyphLayout.this._typo_flags | this.eflags, GlyphLayout.this._pt, GlyphLayout.this._gvdata);
        }
    }

    public static final class GVData {
        public int _count;
        public int _flags;
        public int[] _glyphs;
        public float[] _positions;
        public int[] _indices;
        private static final int UNINITIALIZED_FLAGS = -1;

        public void init(int n) {
            this._count = 0;
            this._flags = -1;
            if (this._glyphs == null || this._glyphs.length < n) {
                if (n < 20) {
                    n = 20;
                }
                this._glyphs = new int[n];
                this._positions = new float[n * 2 + 2];
                this._indices = new int[n];
            }
        }

        public void grow() {
            this.grow(this._glyphs.length / 4);
        }

        public void grow(int n) {
            int n2 = this._glyphs.length + n;
            int[] nArray = new int[n2];
            System.arraycopy(this._glyphs, 0, nArray, 0, this._count);
            this._glyphs = nArray;
            float[] fArray = new float[n2 * 2 + 2];
            System.arraycopy(this._positions, 0, fArray, 0, this._count * 2 + 2);
            this._positions = fArray;
            int[] nArray2 = new int[n2];
            System.arraycopy(this._indices, 0, nArray2, 0, this._count);
            this._indices = nArray2;
        }

        public void adjustPositions(AffineTransform affineTransform) {
            affineTransform.transform(this._positions, 0, this._positions, 0, this._count);
        }

        public StandardGlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, StandardGlyphVector standardGlyphVector) {
            if (this._flags == -1) {
                this._flags = 0;
                if (this._count > 1) {
                    boolean bl = true;
                    boolean bl2 = true;
                    int n = this._count;
                    for (int i = 0; i < this._count && (bl || bl2); ++i) {
                        int n2 = this._indices[i];
                        bl = bl && n2 == i;
                        bl2 = bl2 && n2 == --n;
                    }
                    if (bl2) {
                        this._flags |= 4;
                    }
                    if (!bl2 && !bl) {
                        this._flags |= 8;
                    }
                }
                this._flags |= 2;
            }
            int[] nArray = new int[this._count];
            System.arraycopy(this._glyphs, 0, nArray, 0, this._count);
            float[] fArray = null;
            if ((this._flags & 2) != 0) {
                fArray = new float[this._count * 2 + 2];
                System.arraycopy(this._positions, 0, fArray, 0, fArray.length);
            }
            int[] nArray2 = null;
            if ((this._flags & 8) != 0) {
                nArray2 = new int[this._count];
                System.arraycopy(this._indices, 0, nArray2, 0, this._count);
            }
            if (standardGlyphVector == null) {
                standardGlyphVector = new StandardGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, this._flags);
            } else {
                standardGlyphVector.initGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, this._flags);
            }
            return standardGlyphVector;
        }
    }

    private static final class SDCache {
        public Font key_font;
        public FontRenderContext key_frc;
        public AffineTransform dtx;
        public AffineTransform invdtx;
        public AffineTransform gtx;
        public Point2D.Float delta;
        public FontStrikeDesc sd;
        private static final Point2D.Float ZERO_DELTA = new Point2D.Float();
        private static SoftReference<ConcurrentHashMap<SDKey, SDCache>> cacheRef;

        private SDCache(Font font, FontRenderContext fontRenderContext) {
            this.key_font = font;
            this.key_frc = fontRenderContext;
            this.dtx = fontRenderContext.getTransform();
            this.dtx.setTransform(this.dtx.getScaleX(), this.dtx.getShearY(), this.dtx.getShearX(), this.dtx.getScaleY(), 0.0, 0.0);
            if (!this.dtx.isIdentity()) {
                try {
                    this.invdtx = this.dtx.createInverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw new InternalError();
                }
            }
            float f = font.getSize2D();
            if (font.isTransformed()) {
                this.gtx = font.getTransform();
                this.gtx.scale(f, f);
                this.delta = new Point2D.Float((float)this.gtx.getTranslateX(), (float)this.gtx.getTranslateY());
                this.gtx.setTransform(this.gtx.getScaleX(), this.gtx.getShearY(), this.gtx.getShearX(), this.gtx.getScaleY(), 0.0, 0.0);
                this.gtx.preConcatenate(this.dtx);
            } else {
                this.delta = ZERO_DELTA;
                this.gtx = new AffineTransform(this.dtx);
                this.gtx.scale(f, f);
            }
            int n = FontStrikeDesc.getAAHintIntVal(fontRenderContext.getAntiAliasingHint(), FontUtilities.getFont2D(font), (int)Math.abs(f));
            int n2 = FontStrikeDesc.getFMHintIntVal(fontRenderContext.getFractionalMetricsHint());
            this.sd = new FontStrikeDesc(this.dtx, this.gtx, font.getStyle(), n, n2);
        }

        public static SDCache get(Font font, FontRenderContext fontRenderContext) {
            Object object;
            if (fontRenderContext.isTransformed() && (((AffineTransform)(object = fontRenderContext.getTransform())).getTranslateX() != 0.0 || ((AffineTransform)object).getTranslateY() != 0.0)) {
                object = new AffineTransform(((AffineTransform)object).getScaleX(), ((AffineTransform)object).getShearY(), ((AffineTransform)object).getShearX(), ((AffineTransform)object).getScaleY(), 0.0, 0.0);
                fontRenderContext = new FontRenderContext((AffineTransform)object, fontRenderContext.getAntiAliasingHint(), fontRenderContext.getFractionalMetricsHint());
            }
            object = new SDKey(font, fontRenderContext);
            ConcurrentHashMap<SDKey, SDCache> concurrentHashMap = null;
            SDCache sDCache = null;
            if (cacheRef != null && (concurrentHashMap = cacheRef.get()) != null) {
                sDCache = concurrentHashMap.get(object);
            }
            if (sDCache == null) {
                sDCache = new SDCache(font, fontRenderContext);
                if (concurrentHashMap == null) {
                    concurrentHashMap = new ConcurrentHashMap(10);
                    cacheRef = new SoftReference<ConcurrentHashMap<SDKey, SDCache>>(concurrentHashMap);
                } else if (concurrentHashMap.size() >= 512) {
                    concurrentHashMap.clear();
                }
                concurrentHashMap.put((SDKey)object, sDCache);
            }
            return sDCache;
        }

        private static final class SDKey {
            private final Font font;
            private final FontRenderContext frc;
            private final int hash;

            SDKey(Font font, FontRenderContext fontRenderContext) {
                this.font = font;
                this.frc = fontRenderContext;
                this.hash = font.hashCode() ^ fontRenderContext.hashCode();
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object object) {
                try {
                    SDKey sDKey = (SDKey)object;
                    return this.hash == sDKey.hash && this.font.equals(sDKey.font) && this.frc.equals(sDKey.frc);
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
        }
    }

    public static interface LayoutEngine {
        public void layout(FontStrikeDesc var1, float[] var2, int var3, int var4, TextRecord var5, int var6, Point2D.Float var7, GVData var8);
    }

    public static interface LayoutEngineFactory {
        public LayoutEngine getEngine(Font2D var1, int var2, int var3);

        public LayoutEngine getEngine(LayoutEngineKey var1);
    }

    public static final class LayoutEngineKey {
        private Font2D font;
        private int script;
        private int lang;

        LayoutEngineKey() {
        }

        LayoutEngineKey(Font2D font2D, int n, int n2) {
            this.init(font2D, n, n2);
        }

        void init(Font2D font2D, int n, int n2) {
            this.font = font2D;
            this.script = n;
            this.lang = n2;
        }

        LayoutEngineKey copy() {
            return new LayoutEngineKey(this.font, this.script, this.lang);
        }

        Font2D font() {
            return this.font;
        }

        int script() {
            return this.script;
        }

        int lang() {
            return this.lang;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            try {
                LayoutEngineKey layoutEngineKey = (LayoutEngineKey)object;
                return this.script == layoutEngineKey.script && this.lang == layoutEngineKey.lang && this.font.equals(layoutEngineKey.font);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.script ^ this.lang ^ this.font.hashCode();
        }
    }
}

