/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pisces.Dasher;
import sun.java2d.pisces.PiscesTileGenerator;
import sun.java2d.pisces.Renderer;
import sun.java2d.pisces.Stroker;
import sun.java2d.pisces.TransformingPathConsumer2D;

public class PiscesRenderingEngine
extends RenderingEngine {
    @Override
    public Shape createStrokedShape(Shape shape, float f, int n, int n2, float f2, float[] fArray, float f3) {
        final Path2D.Float float_ = new Path2D.Float();
        this.strokeTo(shape, null, f, NormMode.OFF, n, n2, f2, fArray, f3, new PathConsumer2D(){

            @Override
            public void moveTo(float f, float f2) {
                float_.moveTo(f, f2);
            }

            @Override
            public void lineTo(float f, float f2) {
                float_.lineTo(f, f2);
            }

            @Override
            public void closePath() {
                float_.closePath();
            }

            @Override
            public void pathDone() {
            }

            @Override
            public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
                float_.curveTo(f, f2, f3, f4, f5, f6);
            }

            @Override
            public void quadTo(float f, float f2, float f3, float f4) {
                float_.quadTo(f, f2, f3, f4);
            }

            @Override
            public long getNativeConsumer() {
                throw new InternalError("Not using a native peer");
            }
        });
        return float_;
    }

    @Override
    public void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, boolean bl3, PathConsumer2D pathConsumer2D) {
        NormMode normMode = bl2 ? (bl3 ? NormMode.ON_WITH_AA : NormMode.ON_NO_AA) : NormMode.OFF;
        this.strokeTo(shape, affineTransform, basicStroke, bl, normMode, bl3, pathConsumer2D);
    }

    void strokeTo(Shape shape, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, NormMode normMode, boolean bl2, PathConsumer2D pathConsumer2D) {
        float f = bl ? (bl2 ? this.userSpaceLineWidth(affineTransform, 0.5f) : this.userSpaceLineWidth(affineTransform, 1.0f)) : basicStroke.getLineWidth();
        this.strokeTo(shape, affineTransform, f, normMode, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase(), pathConsumer2D);
    }

    private float userSpaceLineWidth(AffineTransform affineTransform, float f) {
        double d;
        if ((affineTransform.getType() & 0x24) != 0) {
            d = Math.sqrt(affineTransform.getDeterminant());
        } else {
            double d2 = affineTransform.getScaleX();
            double d3 = affineTransform.getShearX();
            double d4 = affineTransform.getShearY();
            double d5 = affineTransform.getScaleY();
            double d6 = d2 * d2 + d4 * d4;
            double d7 = 2.0 * (d2 * d3 + d4 * d5);
            double d8 = d3 * d3 + d5 * d5;
            double d9 = Math.sqrt(d7 * d7 + (d6 - d8) * (d6 - d8));
            double d10 = (d6 + d8 + d9) / 2.0;
            d = Math.sqrt(d10);
        }
        return (float)((double)f / d);
    }

    void strokeTo(Shape shape, AffineTransform affineTransform, float f, NormMode normMode, int n, int n2, float f2, float[] fArray, float f3, PathConsumer2D pathConsumer2D) {
        AffineTransform affineTransform2 = null;
        AffineTransform affineTransform3 = null;
        PathIterator pathIterator = null;
        if (affineTransform != null && !affineTransform.isIdentity()) {
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getShearX();
            double d3 = affineTransform.getShearY();
            double d4 = affineTransform.getScaleY();
            double d5 = d * d4 - d3 * d2;
            if (Math.abs(d5) <= (double)2.8E-45f) {
                pathConsumer2D.moveTo(0.0f, 0.0f);
                pathConsumer2D.pathDone();
                return;
            }
            if (PiscesRenderingEngine.nearZero(d * d2 + d3 * d4, 2) && PiscesRenderingEngine.nearZero(d * d + d3 * d3 - (d2 * d2 + d4 * d4), 2)) {
                double d6 = Math.sqrt(d * d + d3 * d3);
                if (fArray != null) {
                    fArray = Arrays.copyOf(fArray, fArray.length);
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = (float)(d6 * (double)fArray[i]);
                    }
                    f3 = (float)(d6 * (double)f3);
                }
                f = (float)(d6 * (double)f);
                pathIterator = shape.getPathIterator(affineTransform);
                if (normMode != NormMode.OFF) {
                    pathIterator = new NormalizingPathIterator(pathIterator, normMode);
                }
            } else {
                affineTransform3 = affineTransform;
                if (normMode != NormMode.OFF) {
                    try {
                        affineTransform2 = affineTransform3.createInverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        noninvertibleTransformException.printStackTrace();
                    }
                    pathIterator = shape.getPathIterator(affineTransform);
                    pathIterator = new NormalizingPathIterator(pathIterator, normMode);
                } else {
                    pathIterator = shape.getPathIterator(null);
                }
            }
        } else {
            pathIterator = shape.getPathIterator(null);
            if (normMode != NormMode.OFF) {
                pathIterator = new NormalizingPathIterator(pathIterator, normMode);
            }
        }
        pathConsumer2D = TransformingPathConsumer2D.transformConsumer(pathConsumer2D, affineTransform3);
        pathConsumer2D = new Stroker(pathConsumer2D, f, n, n2, f2);
        if (fArray != null) {
            pathConsumer2D = new Dasher(pathConsumer2D, fArray, f3);
        }
        pathConsumer2D = TransformingPathConsumer2D.transformConsumer(pathConsumer2D, affineTransform2);
        PiscesRenderingEngine.pathTo(pathIterator, pathConsumer2D);
    }

    private static boolean nearZero(double d, int n) {
        return Math.abs(d) < (double)n * Math.ulp(d);
    }

    static void pathTo(PathIterator pathIterator, PathConsumer2D pathConsumer2D) {
        RenderingEngine.feedConsumer(pathIterator, pathConsumer2D);
        pathConsumer2D.pathDone();
    }

    @Override
    public AATileGenerator getAATileGenerator(Shape shape, AffineTransform affineTransform, Region region, BasicStroke basicStroke, boolean bl, boolean bl2, int[] nArray) {
        Renderer renderer;
        Object object;
        NormMode normMode;
        NormMode normMode2 = normMode = bl2 ? NormMode.ON_WITH_AA : NormMode.OFF;
        if (basicStroke == null) {
            object = bl2 ? new NormalizingPathIterator(shape.getPathIterator(affineTransform), normMode) : shape.getPathIterator(affineTransform);
            renderer = new Renderer(3, 3, region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), object.getWindingRule());
            PiscesRenderingEngine.pathTo((PathIterator)object, renderer);
        } else {
            renderer = new Renderer(3, 3, region.getLoX(), region.getLoY(), region.getWidth(), region.getHeight(), 1);
            this.strokeTo(shape, affineTransform, basicStroke, bl, normMode, true, (PathConsumer2D)renderer);
        }
        renderer.endRendering();
        object = new PiscesTileGenerator(renderer, renderer.MAX_AA_ALPHA);
        ((PiscesTileGenerator)object).getBbox(nArray);
        return object;
    }

    @Override
    public float getMinimumAAPenSize() {
        return 0.5f;
    }

    private static class NormalizingPathIterator
    implements PathIterator {
        private final PathIterator src;
        private float curx_adjust;
        private float cury_adjust;
        private float movx_adjust;
        private float movy_adjust;
        private final float lval;
        private final float rval;

        NormalizingPathIterator(PathIterator pathIterator, NormMode normMode) {
            this.src = pathIterator;
            switch (normMode) {
                case ON_NO_AA: {
                    this.rval = 0.25f;
                    this.lval = 0.25f;
                    break;
                }
                case ON_WITH_AA: {
                    this.lval = 0.0f;
                    this.rval = 0.5f;
                    break;
                }
                case OFF: {
                    throw new InternalError("A NormalizingPathIterator should not be created if no normalization is being done");
                }
                default: {
                    throw new InternalError("Unrecognized normalization mode");
                }
            }
        }

        @Override
        public int currentSegment(float[] fArray) {
            int n;
            int n2 = this.src.currentSegment(fArray);
            switch (n2) {
                case 3: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 0: 
                case 1: {
                    n = 0;
                    break;
                }
                case 4: {
                    this.curx_adjust = this.movx_adjust;
                    this.cury_adjust = this.movy_adjust;
                    return n2;
                }
                default: {
                    throw new InternalError("Unrecognized curve type");
                }
            }
            float f = (float)Math.floor(fArray[n] + this.lval) + this.rval - fArray[n];
            float f2 = (float)Math.floor(fArray[n + 1] + this.lval) + this.rval - fArray[n + 1];
            int n3 = n;
            fArray[n3] = fArray[n3] + f;
            int n4 = n + 1;
            fArray[n4] = fArray[n4] + f2;
            switch (n2) {
                case 3: {
                    fArray[0] = fArray[0] + this.curx_adjust;
                    fArray[1] = fArray[1] + this.cury_adjust;
                    fArray[2] = fArray[2] + f;
                    fArray[3] = fArray[3] + f2;
                    break;
                }
                case 2: {
                    fArray[0] = fArray[0] + (this.curx_adjust + f) / 2.0f;
                    fArray[1] = fArray[1] + (this.cury_adjust + f2) / 2.0f;
                    break;
                }
                case 1: {
                    break;
                }
                case 0: {
                    this.movx_adjust = f;
                    this.movy_adjust = f2;
                    break;
                }
                case 4: {
                    throw new InternalError("This should be handled earlier.");
                }
            }
            this.curx_adjust = f;
            this.cury_adjust = f2;
            return n2;
        }

        @Override
        public int currentSegment(double[] dArray) {
            float[] fArray = new float[6];
            int n = this.currentSegment(fArray);
            for (int i = 0; i < 6; ++i) {
                dArray[i] = fArray[i];
            }
            return n;
        }

        @Override
        public int getWindingRule() {
            return this.src.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.src.isDone();
        }

        @Override
        public void next() {
            this.src.next();
        }
    }

    private static enum NormMode {
        OFF,
        ON_NO_AA,
        ON_WITH_AA;

    }
}

