/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jruby.Ruby;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2MethodNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TypedArgumentNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.IR_Loop;
import org.jruby.compiler.ir.IR_MetaClass;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.IR_Script;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.compiler_pass.AddFrameInstructions;
import org.jruby.compiler.ir.compiler_pass.CFG_Builder;
import org.jruby.compiler.ir.compiler_pass.DominatorTreeBuilder;
import org.jruby.compiler.ir.compiler_pass.IR_Printer;
import org.jruby.compiler.ir.compiler_pass.LiveVariableAnalysis;
import org.jruby.compiler.ir.compiler_pass.opts.DeadCodeElimination;
import org.jruby.compiler.ir.compiler_pass.opts.LocalOptimizationPass;
import org.jruby.compiler.ir.instructions.ALU_Instr;
import org.jruby.compiler.ir.instructions.ATTR_ASSIGN_Instr;
import org.jruby.compiler.ir.instructions.BEQ_Instr;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.BUILD_CLOSURE_Instr;
import org.jruby.compiler.ir.instructions.CASE_Instr;
import org.jruby.compiler.ir.instructions.CLOSURE_RETURN_Instr;
import org.jruby.compiler.ir.instructions.COPY_Instr;
import org.jruby.compiler.ir.instructions.CallInstruction;
import org.jruby.compiler.ir.instructions.DECLARE_LOCAL_TYPE_Instr;
import org.jruby.compiler.ir.instructions.EQQ_Instr;
import org.jruby.compiler.ir.instructions.FilenameInstruction;
import org.jruby.compiler.ir.instructions.GET_ARRAY_Instr;
import org.jruby.compiler.ir.instructions.GET_CONST_Instr;
import org.jruby.compiler.ir.instructions.GET_CVAR_Instr;
import org.jruby.compiler.ir.instructions.GET_FIELD_Instr;
import org.jruby.compiler.ir.instructions.GET_GLOBAL_VAR_Instr;
import org.jruby.compiler.ir.instructions.IS_TRUE_Instr;
import org.jruby.compiler.ir.instructions.JRUBY_IMPL_CALL_Instr;
import org.jruby.compiler.ir.instructions.JUMP_INDIRECT_Instr;
import org.jruby.compiler.ir.instructions.JUMP_Instr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.instructions.LINE_NUM_Instr;
import org.jruby.compiler.ir.instructions.PUT_CONST_Instr;
import org.jruby.compiler.ir.instructions.PUT_CVAR_Instr;
import org.jruby.compiler.ir.instructions.PUT_FIELD_Instr;
import org.jruby.compiler.ir.instructions.PUT_GLOBAL_VAR_Instr;
import org.jruby.compiler.ir.instructions.RECV_CLOSURE_ARG_Instr;
import org.jruby.compiler.ir.instructions.RECV_CLOSURE_Instr;
import org.jruby.compiler.ir.instructions.RECV_EXCEPTION_Instr;
import org.jruby.compiler.ir.instructions.RECV_OPT_ARG_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_END_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_START_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RETURN_Instr;
import org.jruby.compiler.ir.instructions.RUBY_INTERNALS_CALL_Instr;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.instructions.SET_RETADDR_Instr;
import org.jruby.compiler.ir.instructions.THREAD_POLL_Instr;
import org.jruby.compiler.ir.instructions.THROW_EXCEPTION_Instr;
import org.jruby.compiler.ir.instructions.YIELD_Instr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Backref;
import org.jruby.compiler.ir.operands.BacktickString;
import org.jruby.compiler.ir.operands.BooleanLiteral;
import org.jruby.compiler.ir.operands.BreakResult;
import org.jruby.compiler.ir.operands.CompoundArray;
import org.jruby.compiler.ir.operands.CompoundString;
import org.jruby.compiler.ir.operands.DynamicSymbol;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Hash;
import org.jruby.compiler.ir.operands.KeyValuePair;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.NthRef;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Range;
import org.jruby.compiler.ir.operands.Regexp;
import org.jruby.compiler.ir.operands.SValue;
import org.jruby.compiler.ir.operands.Splat;
import org.jruby.compiler.ir.operands.StringLiteral;
import org.jruby.compiler.ir.operands.Symbol;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.runtime.BlockBody;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IR_Builder {
    private Stack<EnsureBlockInfo> _ensureBlockStack = new Stack();

    public static void main(String[] args2) {
        boolean isDebug = args2.length > 0 && args2[0].equals("-debug");
        int i = isDebug ? 1 : 0;
        boolean isCommandLineScript = args2.length > i && args2[i].equals("-e");
        i += isCommandLineScript ? 1 : 0;
        while (i < args2.length) {
            long t1 = new Date().getTime();
            Node ast = IR_Builder.buildAST(isCommandLineScript, args2[i]);
            long t2 = new Date().getTime();
            IR_Scope scope = new IR_Builder().buildRoot(ast);
            long t3 = new Date().getTime();
            if (isDebug) {
                System.out.println("################## Before local optimization pass ##################");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new LocalOptimizationPass());
            long t4 = new Date().getTime();
            if (isDebug) {
                System.out.println("################## After local optimization pass ##################");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new CFG_Builder());
            long t5 = new Date().getTime();
            scope.runCompilerPass(new DominatorTreeBuilder());
            long t6 = new Date().getTime();
            if (isDebug) {
                System.out.println("################## After dead code elimination pass ##################");
            }
            scope.runCompilerPass(new LiveVariableAnalysis());
            long t7 = new Date().getTime();
            scope.runCompilerPass(new DeadCodeElimination());
            long t8 = new Date().getTime();
            scope.runCompilerPass(new AddFrameInstructions());
            long t9 = new Date().getTime();
            if (isDebug) {
                scope.runCompilerPass(new IR_Printer());
            }
            System.out.println("Time to build AST         : " + (t2 - t1));
            System.out.println("Time to build IR          : " + (t3 - t2));
            System.out.println("Time to run local opts    : " + (t4 - t3));
            System.out.println("Time to run build cfg     : " + (t5 - t4));
            System.out.println("Time to run build domtree : " + (t6 - t5));
            System.out.println("Time to run lva           : " + (t7 - t6));
            System.out.println("Time to run dead code elim: " + (t8 - t7));
            System.out.println("Time to add frame instrs  : " + (t9 - t8));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Node node;
        Ruby ruby2 = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby2.parse(ByteList.create(arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            try {
                File file2 = new File(arg2);
                fis = new FileInputStream(file2);
                long size2 = file2.length();
                byte[] bytes2 = new byte[(int)size2];
                fis.read(bytes2);
                System.out.println("-- processing " + arg2 + " --");
                node = ruby2.parse(new ByteList(bytes2), arg2, null, 0, false);
                Object var10_9 = null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return node;
        }
        if (fis == null) return node;
        fis.close();
        return node;
    }

    public static Node skipOverNewlines(IR_Scope s, Node n) {
        if (n.getNodeType() == NodeType.NEWLINENODE) {
            s.addInstr(new LINE_NUM_Instr(n.getPosition().getStartLine()));
        }
        while (n.getNodeType() == NodeType.NEWLINENODE) {
            n = ((NewlineNode)n).getNextNode();
        }
        return n;
    }

    public Operand build(Node node, IR_Scope m) {
        if (node == null) {
            return null;
        }
        if (m == null) {
            System.out.println("Got a null scope!");
            throw new NotCompilableException("Unknown node encountered in builder: " + node);
        }
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node, m);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node, m);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node, m);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node, m);
            }
            case ARRAYNODE: {
                return this.buildArray(node, m);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign((AttrAssignNode)node, m);
            }
            case BACKREFNODE: {
                return this.buildBackref((BackRefNode)node, m);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node, m);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node, m);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node, m);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node, (IR_ExecutionScope)m);
            }
            case CALLNODE: {
                return this.buildCall((CallNode)node, m);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node, m);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node, m);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node, m);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node, m);
            }
            case CLASSVARDECLNODE: {
                return this.buildClassVarDecl((ClassVarDeclNode)node, m);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node, m);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node, m);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node, m);
            }
            case CONSTNODE: {
                return this.buildConst((ConstNode)node, m);
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node, m);
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node, m);
            }
            case DEFSNODE: {
                return this.buildDefs((MethodDefNode)node, m);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node, m);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp((DRegexpNode)node, m);
            }
            case DSTRNODE: {
                return this.buildDStr((DStrNode)node, m);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol(node, m);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node, m);
            }
            case DXSTRNODE: {
                return this.buildDXStr((DXStrNode)node, m);
            }
            case ENSURENODE: {
                return this.buildEnsureNode(node, m);
            }
            case EVSTRNODE: {
                return this.buildEvStr((EvStrNode)node, m);
            }
            case FALSENODE: {
                return this.buildFalse(node, m);
            }
            case FCALLNODE: {
                return this.buildFCall((FCallNode)node, m);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node, m);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node, m);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node, (IR_ExecutionScope)m);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node, m);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar((GlobalVarNode)node, m);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node, m);
            }
            case IFNODE: {
                return this.buildIf((IfNode)node, m);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node, m);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node, m);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node, (IR_ExecutionScope)m);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node, m);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node, m);
            }
            case MATCH2NODE: {
                return this.buildMatch2((Match2Node)node, m);
            }
            case MATCH3NODE: {
                return this.buildMatch3((Match3Node)node, m);
            }
            case MATCHNODE: {
                return this.buildMatch((MatchNode)node, m);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node, m);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn((MultipleAsgnNode)node, m);
            }
            case NEWLINENODE: {
                return this.buildNewline((NewlineNode)node, m);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node, (IR_ExecutionScope)m);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node, m);
            }
            case NILNODE: {
                return this.buildNil(node, m);
            }
            case NOTNODE: {
                return this.buildNot((NotNode)node, m);
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node, m);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node, m);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node, m);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn(node, m);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node, m);
            }
            case REDONODE: {
                return this.buildRedo(node, (IR_ExecutionScope)m);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node, m);
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                return this.buildRescue(node, m);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node, m);
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use buildRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                return this.buildSClass(node, m);
            }
            case SELFNODE: {
                return this.buildSelf((SelfNode)node, m);
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node, m);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node, m);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node, m);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node, m);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node, m);
            }
            case TOARYNODE: {
                return this.buildToAry((ToAryNode)node, m);
            }
            case TRUENODE: {
                return this.buildTrue(node, m);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node, (IR_ExecutionScope)m);
            }
            case VCALLNODE: {
                return this.buildVCall((VCallNode)node, m);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node, (IR_ExecutionScope)m);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node, m);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node, m);
            }
            case ZARRAYNODE: {
                return this.buildZArray(node, m);
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node, m);
            }
        }
        throw new NotCompilableException("Unknown node encountered in builder: " + node);
    }

    public void buildArguments(List<Operand> args2, Node node, IR_Scope s) {
        switch (node.getNodeType()) {
            case ARGSCATNODE: {
                this.buildArgsCatArguments(args2, (ArgsCatNode)node, s);
                break;
            }
            case ARGSPUSHNODE: {
                this.buildArgsPushArguments(args2, (ArgsPushNode)node, s);
                break;
            }
            case ARRAYNODE: {
                this.buildArrayArguments(args2, node, s);
                break;
            }
            case SPLATNODE: {
                this.buildSplatArguments(args2, (SplatNode)node, s);
                break;
            }
            default: {
                Operand retVal = this.build(node, s);
                if (retVal == null) break;
                args2.add(retVal);
            }
        }
    }

    public void buildVariableArityArguments(List<Operand> args2, Node node, IR_Scope s) {
        this.buildArguments(args2, node, s);
    }

    public void buildSpecificArityArguments(List<Operand> args2, Node node, IR_Scope s) {
        if (node.getNodeType() == NodeType.ARRAYNODE) {
            ArrayNode arrayNode = (ArrayNode)node;
            if (arrayNode.isLightweight()) {
                for (Node n : arrayNode.childNodes()) {
                    args2.add(this.build(n, s));
                }
            } else {
                args2.add(this.build(arrayNode, s));
            }
        } else {
            args2.add(this.build(node, s));
        }
    }

    public List<Operand> setupCallArgs(Node receiver2, Node args2, IR_Scope s) {
        ArrayList<Operand> argsList = new ArrayList<Operand>();
        argsList.add(this.build(receiver2, s));
        if (args2 != null) {
            args2 = IR_Builder.skipOverNewlines(s, args2);
            this.buildArgs(argsList, args2, s);
        }
        return argsList;
    }

    public List<Operand> setupCallArgs(Node args2, IR_Scope s) {
        ArrayList<Operand> argsList = new ArrayList<Operand>();
        argsList.add(s.getSelf());
        if (args2 != null) {
            args2 = IR_Builder.skipOverNewlines(s, args2);
            this.buildArgs(argsList, args2, s);
        }
        return argsList;
    }

    public void buildArgs(List<Operand> argsList, Node args2, IR_Scope s) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: 
            case SPLATNODE: {
                this.buildVariableArityArguments(argsList, args2, s);
                break;
            }
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)args2;
                if (arrayNode.size() > 3) {
                    this.buildVariableArityArguments(argsList, arrayNode, s);
                    break;
                }
                if (arrayNode.size() <= 0) break;
                this.buildSpecificArityArguments(argsList, arrayNode, s);
                break;
            }
            default: {
                this.buildSpecificArityArguments(argsList, args2, s);
            }
        }
    }

    public void buildAssignment(Node node, IR_Scope s, Operand values, int argIndex, boolean isSplat) {
        Variable v = s.getNewTemporaryVariable();
        s.addInstr(new GET_ARRAY_Instr(v, values, argIndex, isSplat));
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, s, v);
                break;
            }
            case CLASSVARASGNNODE: {
                s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, s, v);
                break;
            }
            case GLOBALASGNNODE: {
                s.addInstr(new PUT_GLOBAL_VAR_Instr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                s.addInstr(new PUT_FIELD_Instr(s.getSelf(), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                s.addInstr(new COPY_Instr(new LocalVariable(((LocalAsgnNode)node).getName()), (Operand)v));
                break;
            }
            case MULTIPLEASGNNODE: {
                this.buildMultipleAsgnAssignment((MultipleAsgnNode)node, s, v);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, IR_Scope s, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                this.buildAttrAssignAssignment(node, s, v);
                break;
            }
            case DASGNNODE: {
                LocalVariable v = new LocalVariable(((DAsgnNode)node).getName());
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                break;
            }
            case CLASSVARASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                this.buildConstDeclAssignment((ConstDeclNode)node, s, v);
                break;
            }
            case GLOBALASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                s.addInstr(new PUT_GLOBAL_VAR_Instr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                s.addInstr(new PUT_FIELD_Instr(s.getSelf(), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                LocalVariable v = new LocalVariable(((LocalAsgnNode)node).getName());
                s.addInstr(new RECV_CLOSURE_ARG_Instr(v, argIndex, isSplat));
                break;
            }
            case MULTIPLEASGNNODE: {
                this.buildMultipleAsgnAssignment((MultipleAsgnNode)node, s, null);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public Operand buildAlias(AliasNode alias, IR_Scope s) {
        String newName = "";
        String oldName = "";
        Operand[] args2 = new Operand[]{new MetaObject(s), new MethAddr(newName), new MethAddr(oldName)};
        s.recordMethodAlias(newName, oldName);
        s.addInstr(new RUBY_INTERNALS_CALL_Instr(null, MethAddr.DEFINE_ALIAS, args2));
        return Nil.NIL;
    }

    public Operand buildAnd(AndNode andNode, IR_Scope m) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode(), m);
            return this.build(andNode.getSecondNode(), m);
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(andNode.getFirstNode(), m);
            return BooleanLiteral.FALSE;
        }
        Variable ret = m.getNewTemporaryVariable();
        Label l = m.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), m);
        m.addInstr(new COPY_Instr(ret, BooleanLiteral.FALSE));
        m.addInstr(new BEQ_Instr(v1, BooleanLiteral.FALSE, l));
        Operand v2 = this.build(andNode.getSecondNode(), m);
        m.addInstr(new COPY_Instr(ret, v2));
        m.addInstr(new LABEL_Instr(l));
        return ret;
    }

    public Operand buildArray(Node node, IR_Scope m) {
        ArrayList<Operand> elts = new ArrayList<Operand>();
        for (Node e : node.childNodes()) {
            elts.add(this.build(e, m));
        }
        return new Array(elts);
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode, IR_Scope s) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s);
        return new CompoundArray(v1, v2);
    }

    public Operand buildArgsPush(ArgsPushNode node, IR_Scope m) {
        throw new NotCompilableException("ArgsPush should never be encountered bare in 1.8");
    }

    private Operand buildAttrAssign(AttrAssignNode attrAssignNode, IR_Scope s) {
        List<Operand> args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s);
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s);
        s.addInstr(new ATTR_ASSIGN_Instr(obj, new StringLiteral(attrAssignNode.getName()), args2.get(1)));
        return args2.get(0);
    }

    public Operand buildAttrAssignAssignment(Node node, IR_Scope s, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        List<Operand> args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s);
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s);
        s.addInstr(new ATTR_ASSIGN_Instr(obj, new StringLiteral(attrAssignNode.getName()), value2));
        return value2;
    }

    public Operand buildBackref(BackRefNode node, IR_Scope m) {
        return new Backref(node.getType());
    }

    public Operand buildBegin(BeginNode beginNode, IR_Scope s) {
        return this.build(beginNode.getBodyNode(), s);
    }

    public Operand buildBignum(BignumNode node, IR_Scope s) {
        return new Fixnum(node.getValue());
    }

    public Operand buildBlock(BlockNode node, IR_Scope s) {
        Operand retVal = null;
        for (Node child : node.childNodes()) {
            retVal = this.build(child, s);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode, IR_ExecutionScope s) {
        Operand rv = this.build(breakNode.getValueNode(), s);
        if (s instanceof IR_Closure) {
            s.addInstr(new BREAK_Instr(rv));
            return rv;
        }
        return new BreakResult(rv, s.getCurrentLoop()._loopEndLabel);
    }

    public Operand buildCall(CallNode callNode, IR_Scope s) {
        Node callArgsNode = callNode.getArgsNode();
        Node receiverNode = callNode.getReceiverNode();
        List<Operand> args2 = this.setupCallArgs(receiverNode, callArgsNode, s);
        Operand block = this.setupCallClosure(callNode.getIterNode(), s);
        Variable callResult = s.getNewTemporaryVariable();
        CallInstruction callInstr = new CallInstruction(callResult, new MethAddr(callNode.getName()), args2.toArray(new Operand[args2.size()]), block);
        s.addInstr(callInstr);
        return callResult;
    }

    public Operand buildCase(CaseNode caseNode, IR_Scope m) {
        Operand value2 = this.build(caseNode.getCaseNode(), m);
        Label endLabel = m.getNewLabel();
        Variable result = m.getNewTemporaryVariable();
        CASE_Instr caseInstr = new CASE_Instr(result, value2, endLabel);
        m.addInstr(caseInstr);
        ArrayList<Operand> variables = new ArrayList<Operand>();
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node node : caseNode.getCases().childNodes()) {
            WhenNode whenNode = (WhenNode)node;
            Label bodyLabel = m.getNewLabel();
            if (whenNode.getExpressionNodes() instanceof ListNode) {
                for (Node expression : ((ListNode)whenNode.getExpressionNodes()).childNodes()) {
                    Variable eqqResult = m.getNewTemporaryVariable();
                    variables.add(eqqResult);
                    labels.add(bodyLabel);
                    m.addInstr(new EQQ_Instr(eqqResult, this.build(expression, m), value2));
                    m.addInstr(new BEQ_Instr(eqqResult, BooleanLiteral.TRUE, bodyLabel));
                }
            } else {
                Variable eqqResult = m.getNewTemporaryVariable();
                variables.add(eqqResult);
                labels.add(bodyLabel);
                m.addInstr(new EQQ_Instr(eqqResult, this.build(whenNode.getExpressionNodes(), m), value2));
                m.addInstr(new BEQ_Instr(eqqResult, BooleanLiteral.TRUE, bodyLabel));
            }
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        if (caseNode.getElseNode() != null) {
            Label elseLbl = m.getNewLabel();
            caseInstr.setElse(elseLbl);
            bodies.put(elseLbl, caseNode.getElseNode());
        }
        for (Map.Entry entry : bodies.entrySet()) {
            m.addInstr(new LABEL_Instr((Label)entry.getKey()));
            Operand bodyValue = this.build((Node)entry.getValue(), m);
            Label tgt = endLabel;
            if (bodyValue instanceof BreakResult) {
                BreakResult br = (BreakResult)bodyValue;
                bodyValue = br._result;
                tgt = br._jumpTarget;
            }
            m.addInstr(new COPY_Instr(result, bodyValue));
            m.addInstr(new JUMP_Instr(tgt));
        }
        m.addInstr(new LABEL_Instr(endLabel));
        caseInstr.setLabels(labels);
        caseInstr.setVariables(variables);
        return result;
    }

    public Operand buildClass(ClassNode classNode, IR_Scope s) {
        Node superNode = classNode.getSuperNode();
        Colon3Node cpathNode = classNode.getCPath();
        Operand superClass = null;
        if (superNode != null) {
            superClass = this.build(superNode, s);
        }
        Operand container = null;
        if (cpathNode instanceof Colon2Node) {
            Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
            if (leftNode != null) {
                container = this.build(leftNode, s);
            }
        } else if (cpathNode instanceof Colon3Node) {
            container = new MetaObject(IR_Class.getCoreClass("Object"));
        }
        String className = cpathNode.getName();
        IR_Class c = new IR_Class(s, container, superClass, className);
        s.addClass(c);
        if (container != null) {
            s.addInstr(new PUT_CONST_Instr(container, className, (Operand)new MetaObject(c)));
        }
        if (classNode.getBodyNode() != null) {
            this.build(classNode.getBodyNode(), c.getRootMethod());
        }
        return null;
    }

    public Operand buildSClass(Node node, IR_Scope s) {
        SClassNode sclassNode = (SClassNode)node;
        Operand receiver2 = this.build(sclassNode.getReceiverNode(), s);
        IR_MetaClass mc = new IR_MetaClass(s, receiver2);
        s.addClass(mc);
        if (sclassNode.getBodyNode() != null) {
            this.build(sclassNode.getBodyNode(), mc.getRootMethod());
        }
        return null;
    }

    public Operand buildClassVar(ClassVarNode node, IR_Scope s) {
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new GET_CVAR_Instr(ret, new MetaObject(s), node.getName()));
        return ret;
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode, IR_Scope s) {
        Operand val = this.build(classVarAsgnNode.getValueNode(), s);
        s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), classVarAsgnNode.getName(), val));
        return val;
    }

    public Operand buildClassVarDecl(ClassVarDeclNode classVarDeclNode, IR_Scope s) {
        Operand val = this.build(classVarDeclNode.getValueNode(), s);
        s.addInstr(new PUT_CVAR_Instr(new MetaObject(s), classVarDeclNode.getName(), val));
        return val;
    }

    public Operand buildConstDecl(ConstDeclNode node, IR_Scope s) {
        Operand val = this.build(node.getValueNode(), s);
        return this.buildConstDeclAssignment(node, s, val);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, IR_Scope s, Operand val) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            s.setConstantValue(constDeclNode.getName(), val);
        } else if (constNode.getNodeType() == NodeType.COLON2NODE) {
            Operand module = this.build(((Colon2Node)constNode).getLeftNode(), s);
            s.addInstr(new PUT_CONST_Instr(module, constDeclNode.getName(), val));
        } else {
            s.addInstr(new PUT_CONST_Instr(s.getSelf(), constDeclNode.getName(), val));
        }
        return val;
    }

    private Operand loadConst(IR_Scope s, IR_Scope currScope, String name2) {
        Operand cv = s.getConstantValue(name2);
        if (cv == null) {
            Variable v = currScope.getNewTemporaryVariable();
            currScope.addInstr(new GET_CONST_Instr(v, s, name2));
            cv = v;
        }
        return cv;
    }

    public Operand buildConst(ConstNode node, IR_Scope s) {
        return this.loadConst(s, s, node.getName());
    }

    public Operand buildColon2(Colon2Node iVisited, IR_Scope s) {
        Node leftNode = iVisited.getLeftNode();
        String name2 = iVisited.getName();
        if (leftNode == null) {
            return this.loadConst(s, s, name2);
        }
        if (iVisited instanceof Colon2ConstNode) {
            Operand module = this.build(iVisited.getLeftNode(), s);
            if (module instanceof MetaObject) {
                return this.loadConst(((MetaObject)module)._scope, s, name2);
            }
            Variable constVal = s.getNewTemporaryVariable();
            s.addInstr(new GET_CONST_Instr(constVal, module, name2));
            return constVal;
        }
        if (iVisited instanceof Colon2MethodNode) {
            Colon2MethodNode c2mNode = (Colon2MethodNode)iVisited;
            List<Operand> args2 = this.setupCallArgs(null, s);
            Operand block = this.setupCallClosure(null, s);
            Variable callResult = s.getNewTemporaryVariable();
            CallInstruction callInstr = new CallInstruction(callResult, new MethAddr(c2mNode.getName()), args2.toArray(new Operand[args2.size()]), block);
            s.addInstr(callInstr);
            return callResult;
        }
        throw new NotCompilableException("Not compilable: " + iVisited);
    }

    public Operand buildColon3(Colon3Node node, IR_Scope s) {
        Variable cv = s.getNewTemporaryVariable();
        s.addInstr(new GET_CONST_Instr(cv, s.getSelf(), node.getName()));
        return cv;
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode, IR_Scope s) {
        LocalVariable arg2 = new LocalVariable(dasgnNode.getName());
        s.addInstr(new COPY_Instr(arg2, this.build(dasgnNode.getValueNode(), s)));
        return arg2;
    }

    private void defineNewMethod(MethodDefNode defnNode, IR_Scope s, Operand receiver2, boolean isInstanceMethod) {
        IRMethod m = isInstanceMethod ? new IRMethod(s, new MetaObject(s), defnNode.getName(), isInstanceMethod) : new IRMethod(s, receiver2, defnNode.getName(), isInstanceMethod);
        this.receiveArgs(defnNode.getArgsNode(), m);
        if (defnNode.getBodyNode() != null) {
            Operand rv;
            Node bodyNode = defnNode.getBodyNode();
            Operand operand = rv = bodyNode instanceof RescueNode ? this.buildRescueInternal(bodyNode, m) : this.build(bodyNode, m);
            if (rv != null) {
                m.addInstr(new RETURN_Instr(rv));
            }
        } else {
            m.addInstr(new RETURN_Instr(Nil.NIL));
        }
        if (isInstanceMethod) {
            s.addMethod(m);
        } else {
            IR_MetaClass mc = new IR_MetaClass(m.getLexicalParent(), receiver2);
            mc.addMethod(m);
        }
    }

    public Operand buildDefn(MethodDefNode node, IR_Scope s) {
        this.defineNewMethod(node, s, null, true);
        return null;
    }

    public Operand buildDefs(MethodDefNode node, IR_Scope s) {
        Operand receiver2 = this.build(node.getNameNode(), s);
        this.defineNewMethod(node, s, receiver2, false);
        return null;
    }

    public Operand receiveArgs(ArgsNode argsNode, IR_Scope s) {
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        s.addInstr(new ReceiveArgumentInstruction(s.getSelf(), 0));
        int argIndex = 1;
        ListNode preArgs = argsNode.getPre();
        int i = 0;
        while (i < required) {
            ArgumentNode a = (ArgumentNode)preArgs.get(i);
            if (a instanceof TypedArgumentNode) {
                TypedArgumentNode t = (TypedArgumentNode)a;
                s.addInstr(new DECLARE_LOCAL_TYPE_Instr(argIndex, this.buildType(t.getTypeNode())));
            }
            s.addInstr(new ReceiveArgumentInstruction(new LocalVariable(a.getName()), argIndex));
            ++i;
            ++argIndex;
        }
        if (argsNode.getBlock() != null) {
            s.addInstr(new RECV_CLOSURE_Instr(new LocalVariable(argsNode.getBlock().getName())));
        }
        if (opt > 0 || rest2 > -1) {
            ListNode optArgs = argsNode.getOptArgs();
            int j = 0;
            while (j < opt) {
                Label l = s.getNewLabel();
                LocalAsgnNode n = (LocalAsgnNode)optArgs.get(j);
                s.addInstr(new RECV_OPT_ARG_Instr(new LocalVariable(n.getName()), argIndex, l));
                this.build(n, s);
                s.addInstr(new LABEL_Instr(l));
                ++j;
                ++argIndex;
            }
            if (rest2 > -1) {
                s.addInstr(new ReceiveArgumentInstruction(new LocalVariable(argsNode.getRestArgNode().getName()), argIndex, true));
                ++argIndex;
            }
        }
        return null;
    }

    public String buildType(Node typeNode) {
        switch (typeNode.getNodeType()) {
            case CONSTNODE: {
                return ((ConstNode)typeNode).getName();
            }
            case SYMBOLNODE: {
                return ((SymbolNode)typeNode).getName();
            }
        }
        return "unknown_type";
    }

    public Operand buildDot(DotNode dotNode, IR_Scope s) {
        return new Range(this.build(dotNode.getBeginNode(), s), this.build(dotNode.getEndNode(), s));
    }

    public Operand buildDRegexp(DRegexpNode dregexpNode, IR_Scope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dregexpNode.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new Regexp(new CompoundString(strPieces), dregexpNode.getOptions());
    }

    public Operand buildDStr(DStrNode dstrNode, IR_Scope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dstrNode.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new CompoundString(strPieces);
    }

    public Operand buildDSymbol(Node node, IR_Scope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : node.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new DynamicSymbol(new CompoundString(strPieces));
    }

    public Operand buildDVar(DVarNode node, IR_Scope m) {
        return new LocalVariable(node.getName());
    }

    public Operand buildDXStr(DXStrNode dstrNode, IR_Scope m) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node nextNode : dstrNode.childNodes()) {
            strPieces.add(this.build(nextNode, m));
        }
        return new BacktickString(strPieces);
    }

    public Operand buildEnsureNode(Node node, IR_Scope m) {
        Nil ensureRetVal;
        Operand rv;
        EnsureBlockInfo ebi = new EnsureBlockInfo(m);
        this._ensureBlockStack.push(ebi);
        EnsureNode ensureNode = (EnsureNode)node;
        Node bodyNode = ensureNode.getBodyNode();
        Operand operand = rv = bodyNode instanceof RescueNode ? this.buildRescueInternal(bodyNode, m) : this.build(bodyNode, m);
        if (ebi.noFallThru) {
            m.addInstr(new LABEL_Instr(ebi.start));
        }
        Operand operand2 = ensureRetVal = ensureNode.getEnsureNode() == null ? Nil.NIL : this.build(ensureNode.getEnsureNode(), m);
        if (ensureRetVal == null) {
            rv = null;
        }
        if (ebi.noFallThru) {
            m.addInstr(new JUMP_INDIRECT_Instr(ebi.returnAddr));
            if (ebi.endLabelNeeded) {
                m.addInstr(new LABEL_Instr(ebi.end));
            }
        }
        this._ensureBlockStack.pop();
        return rv;
    }

    public Operand buildEvStr(EvStrNode node, IR_Scope s) {
        return this.build(node.getBody(), s);
    }

    public Operand buildFalse(Node node, IR_Scope s) {
        s.addInstr(new THREAD_POLL_Instr());
        return BooleanLiteral.FALSE;
    }

    public Operand buildFCall(FCallNode fcallNode, IR_Scope s) {
        Node callArgsNode = fcallNode.getArgsNode();
        List<Operand> args2 = this.setupCallArgs(callArgsNode, s);
        Operand block = this.setupCallClosure(fcallNode.getIterNode(), s);
        Variable callResult = s.getNewTemporaryVariable();
        CallInstruction callInstr = new CallInstruction(callResult, new MethAddr(fcallNode.getName()), args2.toArray(new Operand[args2.size()]), block);
        s.addInstr(callInstr);
        return callResult;
    }

    private Operand setupCallClosure(Node node, IR_Scope s) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build((IterNode)node, s);
            }
            case BLOCKPASSNODE: {
                return this.build(((BlockPassNode)node).getBodyNode(), s);
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public Operand buildFixnum(FixnumNode node, IR_Scope m) {
        return new Fixnum(node.getValue());
    }

    public Operand buildFloat(FloatNode node, IR_Scope m) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode, IR_ExecutionScope m) {
        Variable ret = m.getNewTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode(), m);
        Operand forBlock = this.buildForIter(forNode, m);
        m.addInstr(new RUBY_INTERNALS_CALL_Instr(ret, MethAddr.FOR_EACH, new Operand[]{receiver2}, forBlock));
        return ret;
    }

    public Operand buildForIter(ForNode forNode, IR_ExecutionScope s) {
        Nil closureRetVal;
        IR_Closure closure = new IR_Closure(s);
        s.addClosure(closure);
        NodeType argsNodeId = null;
        if (forNode.getVarNode() != null && (argsNodeId = forNode.getVarNode().getNodeType()) != null) {
            this.buildBlockArgsAssignment(forNode.getVarNode(), closure, 0, false);
        }
        Operand operand = closureRetVal = forNode.getBodyNode() == null ? Nil.NIL : this.build(forNode.getBodyNode(), closure);
        if (closureRetVal != null) {
            closure.addInstr(new CLOSURE_RETURN_Instr(closureRetVal));
        }
        Variable blockVar = s.getNewTemporaryVariable();
        s.addInstr(new BUILD_CLOSURE_Instr(blockVar, closure));
        return blockVar;
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode, IR_Scope m) {
        Operand value2 = this.build(globalAsgnNode.getValueNode(), m);
        m.addInstr(new PUT_GLOBAL_VAR_Instr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(GlobalVarNode node, IR_Scope m) {
        Variable rv = m.getNewTemporaryVariable();
        m.addInstr(new GET_GLOBAL_VAR_Instr(rv, node.getName()));
        return rv;
    }

    public Operand buildHash(HashNode hashNode, IR_Scope m) {
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            return new Hash(new ArrayList<KeyValuePair>());
        }
        boolean i = false;
        Operand key2 = null;
        Object value2 = null;
        ArrayList<KeyValuePair> args2 = new ArrayList<KeyValuePair>();
        for (Node nextNode : hashNode.getListNode().childNodes()) {
            Operand v = this.build(nextNode, m);
            if (key2 == null) {
                key2 = v;
                continue;
            }
            args2.add(new KeyValuePair(key2, v));
            key2 = null;
        }
        return new Hash(args2);
    }

    public Operand buildIf(IfNode ifNode, IR_Scope s) {
        Node actualCondition = IR_Builder.skipOverNewlines(s, ifNode.getCondition());
        Variable result = s.getNewTemporaryVariable();
        Label falseLabel = s.getNewLabel();
        Label doneLabel = s.getNewLabel();
        Operand thenResult = null;
        s.addInstr(new BEQ_Instr(this.build(actualCondition, s), BooleanLiteral.FALSE, falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        if (ifNode.getThenBody() != null) {
            thenResult = this.build(ifNode.getThenBody(), s);
            if (thenResult != null) {
                Label tgt = doneLabel;
                if (thenResult instanceof BreakResult) {
                    BreakResult br = (BreakResult)thenResult;
                    thenResult = br._result;
                    tgt = br._jumpTarget;
                }
                s.addInstr(new COPY_Instr(result, thenResult));
                s.addInstr(new JUMP_Instr(tgt));
            } else {
                thenNull = true;
            }
        } else {
            s.addInstr(new COPY_Instr(result, Nil.NIL));
            s.addInstr(new JUMP_Instr(doneLabel));
        }
        s.addInstr(new LABEL_Instr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody(), s);
            if (elseResult != null) {
                s.addInstr(new COPY_Instr(result, elseResult));
            } else {
                elseNull = true;
            }
        } else {
            s.addInstr(new COPY_Instr(result, Nil.NIL));
        }
        if (thenNull && elseNull) {
            return null;
        }
        s.addInstr(new LABEL_Instr(doneLabel));
        return result;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode, IR_Scope s) {
        Operand val = this.build(instAsgnNode.getValueNode(), s);
        s.addInstr(new PUT_FIELD_Instr(s.getSelf(), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node, IR_Scope m) {
        Variable ret = m.getNewTemporaryVariable();
        m.addInstr(new GET_FIELD_Instr(ret, m.getSelf(), node.getName()));
        return ret;
    }

    public Operand buildIter(IterNode iterNode, IR_ExecutionScope s) {
        Nil closureRetVal;
        IR_Closure closure = new IR_Closure(s);
        s.addClosure(closure);
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        if (iterNode.getVarNode() != null && argsNodeId != null) {
            this.buildBlockArgsAssignment(iterNode.getVarNode(), closure, 0, false);
        }
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? Nil.NIL : this.build(iterNode.getBodyNode(), closure);
        if (closureRetVal != null) {
            closure.addInstr(new CLOSURE_RETURN_Instr(closureRetVal));
        }
        Variable blockVar = s.getNewTemporaryVariable();
        s.addInstr(new BUILD_CLOSURE_Instr(blockVar, closure));
        return blockVar;
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode, IR_Scope s) {
        Operand value2 = this.build(localAsgnNode.getValueNode(), s);
        s.addInstr(new COPY_Instr(new LocalVariable(localAsgnNode.getName()), value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node, IR_Scope s) {
        return new LocalVariable(node.getName());
    }

    public Operand buildMatch(MatchNode matchNode, IR_Scope m) {
        Variable ret = m.getNewTemporaryVariable();
        Operand regexp2 = this.build(matchNode.getRegexpNode(), m);
        m.addInstr(new JRUBY_IMPL_CALL_Instr(ret, MethAddr.MATCH, new Operand[]{regexp2}));
        return ret;
    }

    public Operand buildMatch2(Match2Node matchNode, IR_Scope m) {
        Variable ret = m.getNewTemporaryVariable();
        Operand receiver2 = this.build(matchNode.getReceiverNode(), m);
        Operand value2 = this.build(matchNode.getValueNode(), m);
        m.addInstr(new JRUBY_IMPL_CALL_Instr(ret, MethAddr.MATCH2, new Operand[]{receiver2, value2}));
        return ret;
    }

    public Operand buildMatch3(Match3Node matchNode, IR_Scope m) {
        Variable ret = m.getNewTemporaryVariable();
        Operand receiver2 = this.build(matchNode.getReceiverNode(), m);
        Operand value2 = this.build(matchNode.getValueNode(), m);
        m.addInstr(new JRUBY_IMPL_CALL_Instr(ret, MethAddr.MATCH3, new Operand[]{receiver2, value2}));
        return ret;
    }

    public Operand buildModule(ModuleNode moduleNode, IR_Scope s) {
        Colon3Node cpathNode = moduleNode.getCPath();
        Operand container = null;
        if (cpathNode instanceof Colon2Node) {
            Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
            if (leftNode != null) {
                container = this.build(leftNode, s);
            }
        } else if (cpathNode instanceof Colon3Node) {
            container = new MetaObject(IR_Class.getCoreClass("Object"));
        }
        String moduleName = moduleNode.getCPath().getName();
        IR_Module m = new IR_Module(s, container, moduleName);
        s.addModule(m);
        if (container != null) {
            s.addInstr(new PUT_CONST_Instr(container, moduleName, (Operand)new MetaObject(m)));
        }
        if (moduleNode.getBodyNode() != null) {
            this.build(moduleNode.getBodyNode(), m.getRootMethod());
        }
        return null;
    }

    public Operand buildMultipleAsgn(MultipleAsgnNode multipleAsgnNode, IR_Scope s) {
        Operand values = this.build(multipleAsgnNode.getValueNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new COPY_Instr(ret, values));
        this.buildMultipleAsgnAssignment(multipleAsgnNode, s, ret);
        return ret;
    }

    public void buildMultipleAsgnAssignment(MultipleAsgnNode multipleAsgnNode, IR_Scope s, Operand values) {
        Node an;
        ListNode sourceArray = multipleAsgnNode.getHeadNode();
        int i = 0;
        if (sourceArray != null) {
            ListNode headNode = sourceArray;
            for (Node an2 : headNode.childNodes()) {
                if (values == null) {
                    this.buildBlockArgsAssignment(an2, s, i, false);
                } else {
                    this.buildAssignment(an2, s, values, i, false);
                }
                ++i;
            }
        }
        if ((an = multipleAsgnNode.getArgsNode()) == null) {
            if (sourceArray == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
        } else if (!(an instanceof StarNode)) {
            if (values != null) {
                this.buildAssignment(an, s, values, i, true);
            } else {
                this.buildBlockArgsAssignment(an, s, i, true);
            }
        }
    }

    public Operand buildNewline(NewlineNode node, IR_Scope s) {
        return this.build(IR_Builder.skipOverNewlines(s, node), s);
    }

    public Operand buildNext(NextNode nextNode, IR_ExecutionScope s) {
        Nil rv = nextNode.getValueNode() == null ? Nil.NIL : this.build(nextNode.getValueNode(), s);
        s.addInstr(new THREAD_POLL_Instr());
        s.addInstr(s instanceof IR_Closure ? new CLOSURE_RETURN_Instr(rv) : new JUMP_Instr(s.getCurrentLoop()._iterEndLabel));
        return rv;
    }

    public Operand buildNthRef(NthRefNode nthRefNode, IR_Scope m) {
        return new NthRef(nthRefNode.getMatchNumber());
    }

    public Operand buildNil(Node node, IR_Scope m) {
        m.addInstr(new THREAD_POLL_Instr());
        return Nil.NIL;
    }

    public Operand buildNot(NotNode node, IR_Scope m) {
        Variable ret = m.getNewTemporaryVariable();
        m.addInstr(new ALU_Instr(Operation.NOT, ret, this.build(node.getConditionNode(), m)));
        return ret;
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode, IR_Scope s) {
        if (opAsgnNode.getOperatorName().equals("||") || opAsgnNode.getOperatorName().equals("&&")) {
            throw new NotCompilableException("Unknown node encountered in builder: " + opAsgnNode);
        }
        Operand v1 = this.build(opAsgnNode.getReceiverNode(), s);
        Variable getResult = s.getNewTemporaryVariable();
        CallInstruction callInstr = new CallInstruction(getResult, new MethAddr(opAsgnNode.getVariableName()), new Operand[]{v1}, null);
        s.addInstr(callInstr);
        Operand v2 = this.build(opAsgnNode.getValueNode(), s);
        Variable setValue2 = s.getNewTemporaryVariable();
        callInstr = new CallInstruction(setValue2, new MethAddr(opAsgnNode.getOperatorName()), new Operand[]{getResult, v2}, null);
        s.addInstr(callInstr);
        Variable setResult = s.getNewTemporaryVariable();
        callInstr = new CallInstruction(setResult, new MethAddr(opAsgnNode.getVariableNameAsgn()), new Operand[]{v1, setValue2}, null);
        s.addInstr(callInstr);
        return setResult;
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode, IR_Scope s) {
        Label l = s.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s);
        Variable f = s.getNewTemporaryVariable();
        s.addInstr(new IS_TRUE_Instr(f, v1));
        s.addInstr(new BEQ_Instr(f, BooleanLiteral.FALSE, l));
        this.build(andNode.getSecondNode(), s);
        s.addInstr(new LABEL_Instr(l));
        s.addInstr(new THREAD_POLL_Instr());
        return v1;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode, IR_Scope s) {
        Label l1 = s.getNewLabel();
        Variable f = s.getNewTemporaryVariable();
        if (this.needsDefinitionCheck(orNode.getFirstNode())) {
            throw new NotCompilableException(orNode + "is not yet compilable since the first node of the OR requires 'defined?' to be implemented");
        }
        Operand v1 = this.build(orNode.getFirstNode(), s);
        s.addInstr(new IS_TRUE_Instr(f, v1));
        s.addInstr(new BEQ_Instr(f, BooleanLiteral.TRUE, l1));
        this.build(orNode.getSecondNode(), s);
        s.addInstr(new LABEL_Instr(l1));
        s.addInstr(new THREAD_POLL_Instr());
        return v1;
    }

    private boolean needsDefinitionCheck(Node node) {
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case DVARNODE: 
            case FALSENODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case LOCALVARNODE: 
            case MATCH2NODE: 
            case MATCH3NODE: 
            case MULTIPLEASGNNODE: 
            case NILNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: 
            case SELFNODE: 
            case TRUENODE: {
                return false;
            }
        }
        return true;
    }

    public Operand buildOpElementAsgn(Node node, IR_Scope m) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        if (opElementAsgnNode.getOperatorName() == "||") {
            return this.buildOpElementAsgnWithOr(node, m);
        }
        if (opElementAsgnNode.getOperatorName() == "&&") {
            return this.buildOpElementAsgnWithAnd(node, m);
        }
        return this.buildOpElementAsgnWithMethod(node, m);
    }

    public Operand buildOpElementAsgnWithOr(Node node, IR_Scope s) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s);
        List<Operand> args2 = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s);
        Label l = s.getNewLabel();
        Variable elt = s.getNewTemporaryVariable();
        Variable f = s.getNewTemporaryVariable();
        Operand[] allArgs = new Operand[args2.size() + 1];
        int i = 1;
        allArgs[0] = array;
        Iterator<Operand> i$ = args2.iterator();
        while (i$.hasNext()) {
            Operand x;
            allArgs[i] = x = i$.next();
            ++i;
        }
        s.addInstr(new CallInstruction(elt, new MethAddr("[]"), allArgs, null));
        s.addInstr(new IS_TRUE_Instr(f, (Operand)elt));
        s.addInstr(new BEQ_Instr(f, BooleanLiteral.TRUE, l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s);
        allArgs = new Operand[args2.size() + 2];
        i = 1;
        allArgs[0] = array;
        Iterator<Operand> i$2 = args2.iterator();
        while (i$2.hasNext()) {
            Operand x;
            allArgs[i] = x = i$2.next();
            ++i;
        }
        allArgs[i] = value2;
        s.addInstr(new CallInstruction(elt, new MethAddr("[]="), allArgs, null));
        s.addInstr(new COPY_Instr(elt, value2));
        s.addInstr(new LABEL_Instr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithAnd(Node node, IR_Scope s) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s);
        List<Operand> args2 = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s);
        Label l = s.getNewLabel();
        Variable elt = s.getNewTemporaryVariable();
        Variable f = s.getNewTemporaryVariable();
        Operand[] allArgs = new Operand[args2.size() + 1];
        int i = 1;
        allArgs[0] = array;
        Iterator<Operand> i$ = args2.iterator();
        while (i$.hasNext()) {
            Operand x;
            allArgs[i] = x = i$.next();
            ++i;
        }
        s.addInstr(new CallInstruction(elt, new MethAddr("[]"), allArgs, null));
        s.addInstr(new IS_TRUE_Instr(f, (Operand)elt));
        s.addInstr(new BEQ_Instr(f, BooleanLiteral.FALSE, l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s);
        allArgs = new Operand[args2.size() + 2];
        i = 1;
        allArgs[0] = array;
        Iterator<Operand> i$2 = args2.iterator();
        while (i$2.hasNext()) {
            Operand x;
            allArgs[i] = x = i$2.next();
            ++i;
        }
        allArgs[i] = value2;
        s.addInstr(new CallInstruction(elt, new MethAddr("[]="), allArgs, null));
        s.addInstr(new COPY_Instr(elt, value2));
        s.addInstr(new LABEL_Instr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(Node node, IR_Scope s) {
        return this.buildOpElementAsgnWithOr(node, s);
    }

    public Operand buildOr(OrNode orNode, IR_Scope m) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(orNode.getFirstNode(), m);
            return BooleanLiteral.TRUE;
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode(), m);
            return this.build(orNode.getSecondNode(), m);
        }
        Variable ret = m.getNewTemporaryVariable();
        Label l = m.getNewLabel();
        Operand v1 = this.build(orNode.getFirstNode(), m);
        m.addInstr(new COPY_Instr(ret, BooleanLiteral.TRUE));
        m.addInstr(new BEQ_Instr(v1, BooleanLiteral.TRUE, l));
        Operand v2 = this.build(orNode.getSecondNode(), m);
        m.addInstr(new COPY_Instr(ret, v2));
        m.addInstr(new LABEL_Instr(l));
        return ret;
    }

    public Operand buildRedo(Node node, IR_ExecutionScope s) {
        s.addInstr(new JUMP_Instr(s instanceof IR_Closure ? ((IR_Closure)s)._startLabel : s.getCurrentLoop()._iterStartLabel));
        return Nil.NIL;
    }

    public Operand buildRegexp(RegexpNode reNode, IR_Scope m) {
        return new Regexp(new StringLiteral(reNode.getValue()), reNode.getOptions());
    }

    public Operand buildRescue(Node node, IR_Scope m) {
        return this.buildRescueInternal(node, m);
    }

    private Operand buildRescueInternal(Node node, IR_Scope m) {
        RescueNode rescueNode = (RescueNode)node;
        boolean noEnsure = this._ensureBlockStack.empty();
        Label rBeginLabel = m.getNewLabel();
        Label rEndLabel = noEnsure ? m.getNewLabel() : this._ensureBlockStack.peek().end;
        Label elseLabel = rescueNode.getElseNode() == null ? null : m.getNewLabel();
        ArrayList<Label> rescueBlockLabels = new ArrayList<Label>();
        m.addInstr(new LABEL_Instr(rBeginLabel));
        RESCUED_BODY_START_MARKER_Instr rbStartInstr = new RESCUED_BODY_START_MARKER_Instr(rBeginLabel, elseLabel, rEndLabel, rescueBlockLabels);
        m.addInstr(rbStartInstr);
        Operand tmp = Nil.NIL;
        Variable rv = m.getNewTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode(), m);
        }
        if (elseLabel != null) {
            m.addInstr(new LABEL_Instr(elseLabel));
            tmp = this.build(rescueNode.getElseNode(), m);
        }
        if (tmp != null) {
            m.addInstr(new COPY_Instr(rv, tmp));
            if (noEnsure) {
                m.addInstr(new JUMP_Instr(rEndLabel));
            } else {
                EnsureBlockInfo ebi = this._ensureBlockStack.peek();
                ebi.endLabelNeeded = true;
                ebi.noFallThru = true;
                m.addInstr(new SET_RETADDR_Instr(ebi.returnAddr, ebi.end));
                m.addInstr(new JUMP_Instr(ebi.start));
            }
        } else {
            rv = null;
        }
        RESCUED_BODY_END_MARKER_Instr rbEndInstr = new RESCUED_BODY_END_MARKER_Instr(rbStartInstr);
        m.addInstr(rbEndInstr);
        Label rbLabel = m.getNewLabel();
        rescueBlockLabels.add(rbLabel);
        m.addInstr(new LABEL_Instr(rbLabel));
        this.buildRescueBodyInternal(m, rescueNode.getRescueNode(), rv, rEndLabel, rescueBlockLabels);
        if (noEnsure) {
            m.addInstr(new LABEL_Instr(rEndLabel));
        }
        return rv;
    }

    private void buildRescueBodyInternal(IR_Scope m, Node node, Variable rv, Label endLabel, List<Label> rescueBlockLabels) {
        Node realBody;
        Operand x;
        RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        boolean haveEnsureBlocks = !this._ensureBlockStack.empty();
        Variable exc = m.getNewTemporaryVariable();
        m.addInstr(new RECV_EXCEPTION_Instr(exc));
        Operand excType = exceptionList == null ? null : this.build(exceptionList, m);
        Label uncaughtLabel = null;
        if (excType != null) {
            uncaughtLabel = m.getNewLabel();
            Variable eqqResult = m.getNewTemporaryVariable();
            m.addInstr(new EQQ_Instr(eqqResult, exc, excType));
            m.addInstr(new BEQ_Instr(eqqResult, BooleanLiteral.FALSE, uncaughtLabel));
        }
        if ((x = this.build(realBody = IR_Builder.skipOverNewlines(m, rescueBodyNode.getBodyNode()), m)) != null) {
            m.addInstr(new COPY_Instr(rv, x));
            if (haveEnsureBlocks) {
                EnsureBlockInfo ebi = this._ensureBlockStack.peek();
                ebi.endLabelNeeded = true;
                ebi.noFallThru = true;
                m.addInstr(new SET_RETADDR_Instr(ebi.returnAddr, ebi.end));
                m.addInstr(new JUMP_Instr(ebi.start));
            } else {
                m.addInstr(new JUMP_Instr(endLabel));
            }
        }
        if (uncaughtLabel != null) {
            rescueBlockLabels.add(uncaughtLabel);
            m.addInstr(new LABEL_Instr(uncaughtLabel));
            if (rescueBodyNode.getOptRescueNode() != null) {
                this.buildRescueBodyInternal(m, rescueBodyNode.getOptRescueNode(), rv, endLabel, rescueBlockLabels);
            } else {
                if (haveEnsureBlocks) {
                    EnsureBlockInfo.emitJumpChain(m, this._ensureBlockStack);
                }
                m.addInstr(new THROW_EXCEPTION_Instr(exc));
            }
        }
    }

    public Operand buildReturn(ReturnNode returnNode, IR_Scope m) {
        Nil retVal;
        Operand operand = retVal = returnNode.getValueNode() == null ? Nil.NIL : this.build(returnNode.getValueNode(), m);
        if (!this._ensureBlockStack.empty()) {
            EnsureBlockInfo.emitJumpChain(m, this._ensureBlockStack);
        }
        m.addInstr(new RETURN_Instr(retVal));
        return null;
    }

    public IR_Scope buildRoot(Node node) {
        IR_Script script = new IR_Script("__file__", node.getPosition().getFile());
        IR_Class rootClass = script._dummyClass;
        IRMethod rootMethod = rootClass.getRootMethod();
        rootMethod.addInstr(new FilenameInstruction(node.getPosition().getFile()));
        rootMethod.addInstr(new ReceiveArgumentInstruction(rootClass.getSelf(), 0));
        RootNode rootNode = (RootNode)node;
        this.build(rootNode.getBodyNode(), rootMethod);
        return script;
    }

    public Operand buildSelf(Node node, IR_Scope s) {
        return s.getSelf();
    }

    public Operand buildSplat(SplatNode splatNode, IR_Scope s) {
        return new Splat(this.build(splatNode.getValue(), s));
    }

    public Operand buildStr(StrNode strNode, IR_Scope s) {
        return new StringLiteral(strNode.getValue());
    }

    public Operand buildSuper(SuperNode superNode, IR_Scope s) {
        List<Operand> args2 = this.setupCallArgs(superNode.getArgsNode(), s);
        Operand block = this.setupCallClosure(superNode.getIterNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new RUBY_INTERNALS_CALL_Instr(ret, MethAddr.SUPER, args2.toArray(new Operand[args2.size()]), block));
        return ret;
    }

    public Operand buildSValue(SValueNode node, IR_Scope s) {
        return new SValue(this.build(node.getValue(), s));
    }

    public Operand buildSymbol(SymbolNode node, IR_Scope s) {
        return new Symbol(node.getName());
    }

    public Operand buildToAry(ToAryNode node, IR_Scope s) {
        Operand array = this.build(node.getValue(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new JRUBY_IMPL_CALL_Instr(ret, MethAddr.TO_ARY, new Operand[]{array}));
        return ret;
    }

    public Operand buildTrue(Node node, IR_Scope m) {
        m.addInstr(new THREAD_POLL_Instr());
        return BooleanLiteral.TRUE;
    }

    private Operand buildConditionalLoop(IR_ExecutionScope s, Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand v;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode, s);
            return Nil.NIL;
        }
        IR_Loop loop = new IR_Loop(s);
        s.startLoop(loop);
        s.addInstr(new LABEL_Instr(loop._loopStartLabel));
        if (isLoopHeadCondition) {
            Operand cv = this.build(conditionNode, s);
            s.addInstr(new BEQ_Instr(cv, isWhile ? BooleanLiteral.FALSE : BooleanLiteral.TRUE, loop._loopEndLabel));
        }
        s.addInstr(new LABEL_Instr(loop._iterStartLabel));
        Variable whileResult = null;
        if (bodyNode != null && (v = this.build(bodyNode, s)) != null) {
            whileResult = s.getNewTemporaryVariable();
            s.addInstr(new COPY_Instr(whileResult, v));
        }
        s.addInstr(new THREAD_POLL_Instr());
        s.addInstr(new LABEL_Instr(loop._iterEndLabel));
        if (!isLoopHeadCondition) {
            Operand cv = this.build(conditionNode, s);
            s.addInstr(new BEQ_Instr(cv, isWhile ? BooleanLiteral.TRUE : BooleanLiteral.FALSE, loop._iterStartLabel));
        }
        s.addInstr(new LABEL_Instr(loop._loopEndLabel));
        s.endLoop(loop);
        return whileResult;
    }

    public Operand buildUntil(UntilNode untilNode, IR_ExecutionScope s) {
        return this.buildConditionalLoop(s, untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVCall(VCallNode node, IR_Scope s) {
        ArrayList<Variable> args2 = new ArrayList<Variable>();
        args2.add(s.getSelf());
        Variable callResult = s.getNewTemporaryVariable();
        CallInstruction callInstr = new CallInstruction(callResult, new MethAddr(node.getName()), args2.toArray(new Operand[args2.size()]), null);
        s.addInstr(callInstr);
        return callResult;
    }

    public Operand buildWhile(WhileNode whileNode, IR_ExecutionScope s) {
        return this.buildConditionalLoop(s, whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node, IR_Scope m) {
        return new BacktickString(new StringLiteral(node.getValue()));
    }

    public Operand buildYield(YieldNode node, IR_Scope s) {
        List<Operand> args2 = this.setupCallArgs(node.getArgsNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new YIELD_Instr(ret, args2.toArray(new Operand[args2.size()])));
        return ret;
    }

    public Operand buildZArray(Node node, IR_Scope m) {
        return new Array();
    }

    public Operand buildZSuper(ZSuperNode zsuperNode, IR_Scope s) {
        Operand block = this.setupCallClosure(zsuperNode.getIterNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new RUBY_INTERNALS_CALL_Instr(ret, MethAddr.ZSUPER, ((IRMethod)s).getCallArgs(), block));
        return ret;
    }

    public void buildArgsCatArguments(List<Operand> args2, ArgsCatNode argsCatNode, IR_Scope s) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s);
        args2.add(new CompoundArray(v1, v2));
    }

    public void buildArgsPushArguments(List<Operand> args2, ArgsPushNode argsPushNode, IR_Scope m) {
        Array a = new Array(new Operand[]{this.build(argsPushNode.getFirstNode(), m), this.build(argsPushNode.getSecondNode(), m)});
        args2.add(a);
    }

    public void buildArrayArguments(List<Operand> args2, Node node, IR_Scope s) {
        args2.add(this.buildArray(node, s));
    }

    public void buildSplatArguments(List<Operand> args2, SplatNode node, IR_Scope s) {
        args2.add(this.buildSplat(node, s));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnsureBlockInfo {
        Label start;
        Label end;
        Variable returnAddr;
        boolean noFallThru;
        boolean endLabelNeeded;

        public EnsureBlockInfo(IR_Scope m) {
            this.returnAddr = m.getNewTemporaryVariable();
            this.start = m.getNewLabel();
            this.end = m.getNewLabel();
            this.noFallThru = false;
            this.endLabelNeeded = false;
        }

        public static void emitJumpChain(IR_Scope m, Stack<EnsureBlockInfo> ebStack) {
            int n = ebStack.size();
            EnsureBlockInfo[] ebArray = ebStack.toArray(new EnsureBlockInfo[n]);
            for (int i = n - 1; i >= 0; --i) {
                Label retLabel = m.getNewLabel();
                m.addInstr(new SET_RETADDR_Instr(ebArray[i].returnAddr, retLabel));
                m.addInstr(new JUMP_Instr(ebArray[i].start));
                m.addInstr(new LABEL_Instr(retLabel));
                ebArray[i].noFallThru = true;
            }
        }
    }
}

