/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.SessionEJBWizardPanel;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SessionEJBWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private SessionEJBWizardPanel wizardPanel;
    private final EJBNameOptions ejbNames;
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private WizardDescriptor wizardDescriptor;

    public SessionEJBWizardDescriptor(Project project) {
        this.ejbNames = new EJBNameOptions();
        this.project = project;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public Component getComponent() {
        if (this.wizardPanel == null) {
            this.wizardPanel = new SessionEJBWizardPanel(this.project, this);
        }
        return this.wizardPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SessionEJBWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        boolean bl = this.wizardPanel.isLocal();
        boolean bl2 = this.wizardPanel.isRemote();
        if (!(bl || bl2 || J2eeProjectCapabilities.forProject((Project)this.project).isEjb31LiteSupported())) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_RemoteOrLocal_MustBeSelected"));
            return false;
        }
        FileObject fileObject = (FileObject)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_FOLDER");
        if (fileObject != null) {
            String string = (String)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_NAME");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.ejbNames.getSessionEjbClassPrefix() + string + this.ejbNames.getSessionEjbClassSuffix());
            if (bl) {
                arrayList.add(this.ejbNames.getSessionLocalPrefix() + string + this.ejbNames.getSessionLocalSuffix());
                arrayList.add(this.ejbNames.getSessionLocalHomePrefix() + string + this.ejbNames.getSessionLocalHomeSuffix());
            }
            if (bl2) {
                arrayList.add(this.ejbNames.getSessionRemotePrefix() + string + this.ejbNames.getSessionRemoteSuffix());
                arrayList.add(this.ejbNames.getSessionRemoteHomePrefix() + string + this.ejbNames.getSessionRemoteHomeSuffix());
            }
            for (String string2 : arrayList) {
                if (fileObject.getFileObject(string2 + ".java") == null) continue;
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_FileAlreadyExists", (Object)(string2 + ".java")));
                return false;
            }
        }
        if (bl2 && this.hasCyclicDependency(this.wizardPanel.getRemoteInterfaceProject())) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SessionEJBWizardDescriptor.class, (String)"ERR_CyclicDependency"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void storeSettings(Object object) {
    }

    public boolean hasRemote() {
        return this.wizardPanel.isRemote();
    }

    public boolean hasLocal() {
        return this.wizardPanel.isLocal();
    }

    public Project getRemoteInterfaceProject() {
        if (this.hasRemote() && !this.wizardPanel.getRemoteInterfaceProject().equals(this.project)) {
            return this.wizardPanel.getRemoteInterfaceProject();
        }
        return null;
    }

    public String getSessionType() {
        return this.wizardPanel.getSessionType();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    private boolean hasCyclicDependency(Project project) {
        if (project == null) {
            return false;
        }
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            Set set = subprojectProvider.getSubprojects();
            if (set.contains(this.project)) {
                return true;
            }
            for (Project project2 : set) {
                if (!this.hasCyclicDependency(project2)) continue;
                return true;
            }
        }
        return false;
    }
}

