/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public final class JavaBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final char[] PAIRS = new char[]{'(', ')', '[', ']', '{', '}'};
    private static final JavaTokenId[] PAIR_TOKEN_IDS = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN, JavaTokenId.LBRACKET, JavaTokenId.RBRACKET, JavaTokenId.LBRACE, JavaTokenId.RBRACE};
    private final MatcherContext context;
    private int originOffset;
    private char originChar;
    private char matchingChar;
    private boolean backward;
    private List<TokenSequence<?>> sequences;

    public JavaBracesMatcher() {
        this(null);
    }

    private JavaBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int[] origin = BracesMatcherSupport.findChar((Document)this.context.getDocument(), (int)this.context.getSearchOffset(), (int)this.context.getLimitOffset(), (char[])PAIRS);
            if (origin != null) {
                this.originOffset = origin[0];
                this.originChar = PAIRS[origin[1]];
                this.matchingChar = PAIRS[origin[1] + origin[2]];
                this.backward = origin[2] < 0;
                TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
                this.sequences = JavaBracesMatcher.getEmbeddedTokenSequences(th, this.originOffset, this.backward, JavaTokenId.language());
                if (!this.sequences.isEmpty()) {
                    TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                    seq.move(this.originOffset);
                    if (seq.moveNext() && (seq.token().id() == JavaTokenId.BLOCK_COMMENT || seq.token().id() == JavaTokenId.LINE_COMMENT)) {
                        int[] nArray = null;
                        return nArray;
                    }
                }
                int[] nArray = new int[]{this.originOffset, this.originOffset + 1};
                return nArray;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (!this.sequences.isEmpty()) {
                TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
                seq.move(this.originOffset);
                if (seq.moveNext() && seq.token().id() == JavaTokenId.STRING_LITERAL) {
                    int offset = BracesMatcherSupport.matchChar((Document)this.context.getDocument(), (int)(this.backward ? this.originOffset : this.originOffset + 1), (int)(this.backward ? seq.offset() : seq.offset() + seq.token().length()), (char)this.originChar, (char)this.matchingChar);
                    if (offset != -1) {
                        int[] nArray = new int[]{offset, offset + 1};
                        return nArray;
                    }
                    int[] nArray = null;
                    return nArray;
                }
                TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
                List list = this.backward ? th.tokenSequenceList(seq.languagePath(), 0, this.originOffset) : th.tokenSequenceList(seq.languagePath(), this.originOffset + 1, this.context.getDocument().getLength());
                JavaTokenId originId = this.getTokenId(this.originChar);
                JavaTokenId lookingForId = this.getTokenId(this.matchingChar);
                int counter = 0;
                TokenSequenceIterator tsi = new TokenSequenceIterator(list, this.backward);
                while (tsi.hasMore()) {
                    TokenSequence<?> sq = tsi.getSequence();
                    if (originId == sq.token().id()) {
                        ++counter;
                        continue;
                    }
                    if (lookingForId != sq.token().id()) continue;
                    if (counter == 0) {
                        int[] nArray = new int[]{sq.offset(), sq.offset() + sq.token().length()};
                        return nArray;
                    }
                    --counter;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private JavaTokenId getTokenId(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            if (PAIRS[i] != ch) continue;
            return PAIR_TOKEN_IDS[i];
        }
        return null;
    }

    public static List<TokenSequence<?>> getEmbeddedTokenSequences(TokenHierarchy<?> th, int offset, boolean backwardBias, Language<?> language) {
        TokenSequence seq;
        List sequences = th.embeddedTokenSequences(offset, backwardBias);
        for (int i = sequences.size() - 1; i >= 0 && (seq = (TokenSequence)sequences.get(i)).language() != language; --i) {
            sequences.remove(i);
        }
        return sequences;
    }

    public BracesMatcher createMatcher(MatcherContext context) {
        return new JavaBracesMatcher(context);
    }

    private static final class TokenSequenceIterator {
        private final List<TokenSequence<?>> list;
        private final boolean backward;
        private int index;

        public TokenSequenceIterator(List<TokenSequence<?>> list, boolean backward) {
            this.list = list;
            this.backward = backward;
            this.index = -1;
        }

        public boolean hasMore() {
            return this.backward ? this.hasPrevious() : this.hasNext();
        }

        public TokenSequence<?> getSequence() {
            assert (this.index >= 0 && this.index < this.list.size()) : "No sequence available, call hasMore() first.";
            return this.list.get(this.index);
        }

        private boolean hasPrevious() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = this.list.size() - 1;
                anotherSeq = true;
            }
            while (this.index >= 0) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveEnd();
                }
                if (seq.movePrevious()) {
                    return true;
                }
                anotherSeq = true;
                --this.index;
            }
            return false;
        }

        private boolean hasNext() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = 0;
                anotherSeq = true;
            }
            while (this.index < this.list.size()) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveStart();
                }
                if (seq.moveNext()) {
                    return true;
                }
                anotherSeq = true;
                ++this.index;
            }
            return false;
        }
    }
}

