/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class SupportedAnnotationTypesCompletion
implements Processor {
    private static final Set<String> supportedAnnotationTypes = new HashSet<String>(Arrays.asList(SupportedAnnotationTypes.class.getName()));
    private Reference<ProcessingEnvironment> processingEnv;

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        FileObject fileObject;
        ProcessingEnvironment processingEnvironment = this.processingEnv.get();
        if (processingEnvironment == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement("java.lang.annotation.Annotation");
        if (typeElement == null) {
            return Collections.emptyList();
        }
        Trees trees = Trees.instance(processingEnvironment);
        TreePath treePath = trees.getPath(element);
        if (treePath == null) {
            return Collections.emptyList();
        }
        try {
            fileObject = URLMapper.findFileObject((URL)treePath.getCompilationUnit().getSourceFile().toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return Collections.emptyList();
        }
        ClassIndex classIndex = ClasspathInfo.create((FileObject)fileObject).getClassIndex();
        if (classIndex == null) {
            return Collections.emptyList();
        }
        LinkedList<CompletionImpl> linkedList = new LinkedList<CompletionImpl>();
        for (ElementHandle elementHandle : classIndex.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE))) {
            if (elementHandle.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            linkedList.add(new CompletionImpl(elementHandle.getQualifiedName()));
        }
        return linkedList;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = new WeakReference<ProcessingEnvironment>(processingEnvironment);
    }

    private final class CompletionImpl
    implements Completion {
        private final String value;
        private final String message;

        public CompletionImpl(String string) {
            this(string, null);
        }

        public CompletionImpl(String string, String string2) {
            this.value = string;
            this.message = string2;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

