/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class RunFocusedTest
extends BaseAction {
    public RunFocusedTest() {
        super("run-focused-spec", 0);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        RunFocusedTest.runTest(target, false);
    }

    public Class getShortDescriptionBundleClass() {
        return RunFocusedTest.class;
    }

    public boolean isEnabled() {
        return true;
    }

    static void runTest(JTextComponent target, boolean debug) {
        Project project;
        if (target.getCaret() == null) {
            return;
        }
        FileObject file = GsfUtilities.findFileObject((JTextComponent)target);
        if (file != null && (project = FileOwnerQuery.getOwner((FileObject)file)) != null) {
            int offset = target.getCaret().getDot();
            BaseDocument doc = (BaseDocument)target.getDocument();
            LineConvertors.FileLocator locator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
            try {
                RSpecSupport rspec = new RSpecSupport(project);
                if (rspec.isRSpecInstalled() && RSpecSupport.isSpecFile(file)) {
                    int line = Utilities.getLineOffset((BaseDocument)doc, (int)offset);
                    if (line >= 0) {
                        LifecycleManager.getDefault().saveAll();
                        TestRunner runner = RunFocusedTest.getTestRunner(TestRunner.TestType.RSPEC);
                        if (runner != null) {
                            runner.runSingleTest(file, String.valueOf(line + 1), debug);
                        } else {
                            rspec.runRSpec(null, file, line + 1, file.getName(), locator, true, debug, new String[0]);
                        }
                        return;
                    }
                } else {
                    String testName = AstUtilities.getTestName((FileObject)file, (int)offset);
                    if (testName != null) {
                        LifecycleManager.getDefault().saveAll();
                        TestRunner runner = RunFocusedTest.getTestRunner(TestRunner.TestType.TEST_UNIT);
                        if (runner != null) {
                            runner.runSingleTest(file, testName, debug);
                        } else {
                            RunFocusedTest.runTest(project, null, file, testName, file.getName(), locator, true, debug, new String[0]);
                        }
                        return;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }

    private static void runTest(Project project, File pwd, FileObject target, String testName, String displayName, LineConvertors.FileLocator fileLocator, boolean warn, boolean debug, String ... parameters) {
        RubyPlatform platform;
        FileObject projectDir = null;
        if (project != null) {
            projectDir = project.getProjectDirectory();
        }
        if (pwd == null) {
            FileObject pfo = projectDir != null ? projectDir : target.getParent();
            pwd = FileUtil.toFile((FileObject)pfo);
        }
        if (!(platform = RubyPlatform.platformFor((Project)project)).isValid(warn)) {
            return;
        }
        ArrayList<String> additionalArgs = new ArrayList<String>();
        additionalArgs.add("-n");
        additionalArgs.add(testName);
        if (parameters != null && parameters.length > 0) {
            for (String parameter : parameters) {
                additionalArgs.add(parameter);
            }
        }
        String targetPath = FileUtil.toFile((FileObject)target).getAbsolutePath();
        RubyExecutionDescriptor desc = null;
        String charsetName = null;
        if (project != null) {
            ActionProvider provider;
            PropertyEvaluator evaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
            if (evaluator != null) {
                charsetName = evaluator.getProperty("source.encoding");
            }
            if ((provider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) instanceof ScriptDescProvider) {
                ScriptDescProvider descProvider = (ScriptDescProvider)provider;
                desc = descProvider.getScriptDescriptor(pwd, target, targetPath, displayName, project.getLookup(), debug, new TestNotifierLineConvertor(true, true));
                desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
            }
        } else {
            desc = new RubyExecutionDescriptor(platform, displayName, pwd, targetPath);
            desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
            desc.debug(debug);
            desc.allowInput();
            desc.fileLocator(fileLocator);
            desc.addStandardRecognizers();
            TestNotifierLineConvertor testConvertor = new TestNotifierLineConvertor(true, true);
            desc.addOutConvertor((LineConvertor)testConvertor);
            desc.addErrConvertor((LineConvertor)testConvertor);
        }
        RubyProcessCreator rpc = new RubyProcessCreator(desc, charsetName);
        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
    }

    private static TestRunner getTestRunner(TestRunner.TestType testType) {
        Collection testRunners = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner each : testRunners) {
            if (!each.supports(testType)) continue;
            return each;
        }
        return null;
    }
}

