/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

public class PropertyEditorColorChooser
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String ERROR_WARNING = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"MSG_ILLEGAL_FORMATING");
    private static final String BUTTON_NAME = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"LBL_BUTTON_NAME");
    private static final String ACSN_BUTTON = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSN_COLOR_BUTTON");
    private static final String ACSD_BUTTON = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSD_COLOR_BUTTON");
    private static final String ACSN_COLOR_CHOOSER = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSN_COLOR_CHOOSER");
    private static final String ACSD_COLOR_CHOOSER = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSD_COLOR_CHOOSER");
    private JColorChooser customEditorElement;
    private JRadioButton radioButton;
    private InplaceEditor inplaceEditor;
    private boolean supportsCustomEditor;

    public PropertyEditorColorChooser(boolean supportsCustomEditor) {
        super(NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"LBL_COLOR_CHOOSER_UCLABEL"));
        this.supportsCustomEditor = supportsCustomEditor;
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        this.customEditorElement = null;
        this.radioButton = null;
        this.inplaceEditor = null;
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new PickColorInplaceEditor();
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics g, Rectangle box) {
        PropertyValue value = (PropertyValue)super.getValue();
        Integer rgb = null;
        if (!(value.getPrimitiveValue() instanceof Integer)) {
            return;
        }
        rgb = (Integer)value.getPrimitiveValue();
        g.drawRect(box.x + 1, box.y + 2, 11, 11);
        Color color = new Color(rgb);
        StringBuffer str = new StringBuffer();
        str.append('[');
        str.append(color.getRed());
        str.append(',');
        str.append(color.getGreen());
        str.append(',');
        str.append(color.getBlue());
        str.append(']');
        g.drawString(str.toString(), box.x + 18, box.y + 11);
        g.setColor(color);
        g.fillRect(box.x + 2, box.y + 3, 10, 10);
        g.dispose();
    }

    public boolean supportsCustomEditor() {
        if (!this.supportsCustomEditor) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        if (this.customEditorElement == null) {
            this.customEditorElement = new JColorChooser();
            this.customEditorElement.getAccessibleContext().setAccessibleName(ACSN_COLOR_CHOOSER);
            this.customEditorElement.getAccessibleContext().setAccessibleDescription(ACSD_COLOR_CHOOSER);
        }
        return this.customEditorElement;
    }

    @Override
    public JRadioButton getRadioButton() {
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton(BUTTON_NAME);
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)BUTTON_NAME);
            this.radioButton.getAccessibleContext().setAccessibleName(ACSN_BUTTON);
            this.radioButton.getAccessibleContext().setAccessibleDescription(ACSD_BUTTON);
        }
        return this.radioButton;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() == PropertyValue.Kind.VALUE;
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public boolean isInitiallySelected() {
        return false;
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NULL_TEXT;
        }
        PropertyValue value = (PropertyValue)this.getValue();
        if (value.getKind() == PropertyValue.Kind.VALUE && value.getPrimitiveValue() instanceof Integer) {
            return this.getFormatedRGB((Integer)value.getPrimitiveValue());
        }
        throw new IllegalStateException();
    }

    private String getFormatedRGB(Integer rgb) {
        Color color = new Color(rgb);
        StringBuffer stringRGB = new StringBuffer();
        stringRGB.append('[');
        stringRGB.append(color.getRed());
        stringRGB.append(',');
        stringRGB.append(color.getGreen());
        stringRGB.append(',');
        stringRGB.append(color.getBlue());
        stringRGB.append(']');
        return stringRGB.toString();
    }

    @Override
    public void setTextForPropertyValue(String text) {
    }

    @Override
    public String getTextForPropertyValue() {
        return "";
    }

    @Override
    public void updateState(PropertyValue value) {
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
        if (value == null || value.getKind() != PropertyValue.Kind.VALUE || value.getKind() == PropertyValue.Kind.NULL) {
            return;
        }
        if (!(value.getPrimitiveValue() instanceof Integer)) {
            throw new IllegalStateException();
        }
        this.customEditorElement.setColor(new Color((Integer)value.getPrimitiveValue()));
    }

    private void saveValue(Integer rgb) {
        PropertyValue rgbValue = MidpTypes.createIntegerValue(rgb);
        this.setValue(rgbValue);
        JTextField tf = (JTextField)this.inplaceEditor.getComponent();
        tf.setText(this.getFormatedRGB(rgb));
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditorElement.getColor().getRGB());
        }
    }

    @Override
    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditorElement == null) {
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class ColorPropertyModel
    implements PropertyModel {
        private JTextField component;

        ColorPropertyModel(JTextField component) {
            this.component = component;
        }

        public Object getValue() throws InvocationTargetException {
            return this.component.getText();
        }

        public void setValue(Object o) throws InvocationTargetException {
            String text = this.component.getText();
            text = text.trim().replaceAll(Pattern.compile("[\\[$\\]]").pattern(), "");
            if (Pattern.compile("[^0123456789,]").matcher(text).find() || text.split(",").length != 3) {
                PropertyValue value = (PropertyValue)o;
                this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)value.getPrimitiveValue()));
                this.wrongValueWarning((PropertyValue)o, text);
                return;
            }
            int[] colors = new int[3];
            int i = 0;
            for (String number : text.split(",")) {
                try {
                    colors[i++] = Integer.valueOf(number);
                }
                catch (NumberFormatException ex) {
                    this.wrongValueWarning((PropertyValue)o, text);
                    return;
                }
                if (Integer.valueOf(number) >= 0 && Integer.valueOf(number) <= 255) continue;
                this.wrongValueWarning((PropertyValue)o, text);
                return;
            }
            int rgb = new Color(colors[0], colors[1], colors[2]).getRGB();
            PropertyEditorColorChooser.this.saveValue(rgb);
            PropertyEditorColorChooser.this.invokeSaveToModel();
        }

        public Class getPropertyType() {
            return PropertyEditorColorChooser.class;
        }

        public Class getPropertyEditorClass() {
            return PropertyEditorColorChooser.class;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        private void wrongValueWarning(PropertyValue value, String text) {
            this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)value.getPrimitiveValue()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ERROR_WARNING + ' ' + text)));
        }
    }

    private class PickColorInplaceEditor
    implements InplaceEditor {
        private PropertyModel model;
        private JTextField component;

        private PickColorInplaceEditor() {
        }

        public void connect(PropertyEditor pe, PropertyEnv env) {
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = new JTextField();
                PropertyValue value = (PropertyValue)this.getValue();
                if (value.getKind() == PropertyValue.Kind.VALUE && value.getPrimitiveValue() instanceof Integer) {
                    this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)value.getPrimitiveValue()));
                }
            }
            this.component.selectAll();
            return this.component;
        }

        public void clear() {
        }

        public Object getValue() {
            return PropertyEditorColorChooser.this.getValue();
        }

        public void setValue(Object o) {
        }

        public boolean supportsTextEntry() {
            return true;
        }

        public void reset() {
        }

        public void addActionListener(ActionListener al) {
        }

        public void removeActionListener(ActionListener al) {
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return PropertyEditorColorChooser.this;
        }

        public PropertyModel getPropertyModel() {
            if (this.model == null) {
                this.model = new ColorPropertyModel(this.component);
            }
            return this.model;
        }

        public void setPropertyModel(PropertyModel pm) {
        }

        public boolean isKnownComponent(Component c) {
            return true;
        }
    }
}

