/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.spi.ConfigurationResourceProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletTaglibraryConfigProvider;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.WebFaceletTaglibResourceProvider;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.ConfigManager;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.FaceletsTaglibConfigProcessor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FaceletsLibrarySupport
implements PropertyChangeListener {
    private JsfSupport jsfSupport;
    private Map<String, FaceletsLibrary> faceletsLibraries;
    private static final Logger LOGGER = Logger.getLogger(FaceletsLibrarySupport.class.getSimpleName());
    private FileChangeListener DDLISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            FaceletsLibrarySupport.this.ddChanged();
        }
    };
    private static final String DD_FILE_NAME = "web.xml";

    public FaceletsLibrarySupport(JsfSupport jsfSupport) {
        FileObject fileObject;
        this.jsfSupport = jsfSupport;
        jsfSupport.getClassPath().addPropertyChangeListener((PropertyChangeListener)this);
        FileObject fileObject2 = this.jsfSupport.getWebModule().getDeploymentDescriptor();
        if (fileObject2 != null) {
            fileObject2.addFileChangeListener(this.DDLISTENER);
        }
        if ((fileObject = this.jsfSupport.getWebModule().getWebInf()) != null) {
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    if (fileObject.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                        fileObject.addFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                    }
                }

                public void fileDeleted(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    if (fileObject.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                        fileObject.removeFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                    }
                }
            });
        }
    }

    private synchronized void ddChanged() {
        this.faceletsLibraries = null;
    }

    public JsfSupport getJsfSupport() {
        return this.jsfSupport;
    }

    public synchronized void libraryChanged(FaceletsLibrary faceletsLibrary) {
        this.faceletsLibraries = null;
    }

    public synchronized void librariesChanged(Collection<String> collection) {
        if (this.faceletsLibraries != null && !this.getLibraries().keySet().containsAll(collection)) {
            this.faceletsLibraries = null;
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.faceletsLibraries = null;
    }

    public synchronized Map<String, FaceletsLibrary> getLibraries() {
        if (this.faceletsLibraries == null) {
            this.faceletsLibraries = this.findLibraries();
            if (this.faceletsLibraries == null) {
                return Collections.emptyMap();
            }
            this.updateCompositeLibraries(this.faceletsLibraries);
        }
        return this.faceletsLibraries;
    }

    private void updateCompositeLibraries(Map<String, FaceletsLibrary> map) {
        CompositeComponentLibrary compositeComponentLibrary;
        ArrayList<String> arrayList = new ArrayList<String>(this.jsfSupport.getIndex().getAllCompositeLibraryNames());
        HashMap<String, CompositeComponentLibrary> hashMap = new HashMap<String, CompositeComponentLibrary>();
        for (FaceletsLibrary object : map.values()) {
            if (!(object instanceof CompositeComponentLibrary)) continue;
            compositeComponentLibrary = (CompositeComponentLibrary)object;
            hashMap.put(compositeComponentLibrary.getDefaultNamespace(), compositeComponentLibrary);
            String string = compositeComponentLibrary.getLibraryName();
            arrayList.remove(string);
        }
        map.putAll(hashMap);
        for (String string : arrayList) {
            compositeComponentLibrary = new CompositeComponentLibrary(this, string);
            map.put(compositeComponentLibrary.getDefaultNamespace(), compositeComponentLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FaceletsLibrary> findLibraries() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(FaceletsLibrarySupport.class, (String)"MSG_ParsingFaceletsLibraries"));
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        try {
            Map<String, FaceletsLibrary> map = this._findLibraries();
            return map;
        }
        finally {
            progressHandle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FaceletsLibrary> _findLibraries() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        LOGGER.log(Level.FINE, "Scanning facelets libraries, current classloader class=" + classLoader.getClass().getName() + ", the used URLClassLoader will also contain following roots:");
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (FileObject fileObject : this.getJsfSupport().getClassPath().getRoots()) {
            try {
                String fileStateInvalidException = fileObject.getFileSystem().getDisplayName();
                if (!fileStateInvalidException.endsWith("jsf-impl.jar") && !fileStateInvalidException.endsWith("jsf-api.jar")) {
                    arrayList.add(URLMapper.findURL((FileObject)fileObject, (int)0));
                    LOGGER.log(Level.FINE, "+++" + fileObject);
                    continue;
                }
                LOGGER.log(Level.FINE, "---" + fileObject);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[0]), classLoader){

            @Override
            public URL findResource(String string) {
                return string.startsWith("META-INF/services") ? null : super.findResource(string);
            }

            @Override
            public Enumeration<URL> findResources(String string) throws IOException {
                if (string.startsWith("META-INF/services")) {
                    return Collections.enumeration(Collections.emptyList());
                }
                return super.findResources(string);
            }
        };
        try {
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            Map<String, FaceletsLibrary> map = this.parseLibraries();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private Map<String, FaceletsLibrary> parseLibraries() {
        Object object;
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>();
        arrayList.add(new WebFaceletTaglibResourceProvider(this.getJsfSupport().getWebModule()));
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.getJsfSupport().getWebModule().getDocumentBase(), (String)"classpath/source");
        arrayList.add(new FaceletTaglibraryConfigProvider(classPath));
        final ArrayList<URL> arrayList2 = new ArrayList<URL>();
        for (FileObject object22 : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            arrayList2.add(URLMapper.findURL((FileObject)object22, (int)1));
        }
        arrayList.add(new ConfigurationResourceProvider(){

            public Collection<URL> getResources(ServletContext servletContext) {
                return arrayList2;
            }
        });
        Collection<FileObject> collection = DefaultFaceletLibraries.getInstance().getLibrariesDescriptorsFiles();
        final ArrayList<URL> arrayList3 = new ArrayList<URL>();
        DocumentInfo[] documentInfoArray = collection.iterator();
        while (documentInfoArray.hasNext()) {
            object = (FileObject)documentInfoArray.next();
            try {
                arrayList3.add(object.getURL());
            }
            catch (FileStateInvalidException hashMap) {
                LOGGER.log(Level.INFO, null, hashMap);
            }
        }
        arrayList.add(new ConfigurationResourceProvider(){

            public Collection<URL> getResources(ServletContext servletContext) {
                return arrayList3;
            }
        });
        documentInfoArray = ConfigManager.getConfigDocuments(null, arrayList, null, true);
        if (documentInfoArray == null) {
            return null;
        }
        object = new FaceletsTaglibConfigProcessor(this);
        ((FaceletsTaglibConfigProcessor)((Object)object)).process(null, documentInfoArray);
        HashMap<String, FaceletsLibrary> hashMap = new HashMap<String, FaceletsLibrary>();
        for (FaceletsLibrary faceletsLibrary : ((FaceletsTaglibConfigProcessor)((Object)object)).compiler.libraries) {
            hashMap.put(faceletsLibrary.getNamespace(), faceletsLibrary);
        }
        return hashMap;
    }

    private void debugLibraries() {
        System.out.println("Facelets Libraries:");
        System.out.println("====================");
        for (FaceletsLibrary faceletsLibrary : this.faceletsLibraries.values()) {
            System.out.println("Library: " + faceletsLibrary.getNamespace());
            System.out.println("----------------------------------------------------");
            for (FaceletsLibrary.NamedComponent namedComponent : faceletsLibrary.getComponents()) {
                System.out.println(namedComponent.getName() + "(" + namedComponent.getClass().getSimpleName() + ")");
            }
            System.out.println();
        }
    }

    public static class Compiler {
        private Collection<FaceletsLibrary> libraries = new HashSet<FaceletsLibrary>();

        public void addTagLibrary(FaceletsLibrary faceletsLibrary) {
            this.libraries.add(faceletsLibrary);
        }
    }
}

