/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class KenaiComboModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selected = this.getElementAt(0) instanceof Kenai ? this.getElementAt(0) : null;
    private List<Kenai.Status> statuses;
    private int addNew = 1;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (KenaiComboModel.this.selected == evt.getOldValue()) {
                KenaiComboModel.this.selected = Utilities.getPreferredKenai();
            }
            KenaiComboModel.this.fireContentsChanged(evt.getSource(), 0, KenaiComboModel.this.getSize());
        }
    };

    public KenaiComboModel(Kenai.Status ... statuses) {
        this(true, statuses);
    }

    public KenaiComboModel(boolean addNew, Kenai.Status ... statuses) {
        this();
        this.statuses = Arrays.asList(statuses);
        this.addNew = addNew ? 1 : 0;
    }

    public KenaiComboModel() {
        KenaiManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)KenaiManager.getDefault()));
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selected = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public Object getElementAt(int index) {
        int i = 0;
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (this.statuses == null || this.statuses.contains(k.getStatus())) {
                ++i;
            }
            if (i - 1 != index) continue;
            return k;
        }
        return NbBundle.getMessage(KenaiComboModel.class, (String)"CTL_AddNew");
    }

    @Override
    public int getSize() {
        if (this.statuses == null) {
            return KenaiManager.getDefault().getKenais().size() + this.addNew;
        }
        int i = 0;
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (!this.statuses.contains(k.getStatus())) continue;
            ++i;
        }
        return i + this.addNew;
    }
}

