/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.deployment.ricoh;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PortVerifier
extends InputVerifier {
    public static int MIN_PORT_VALUE = 0;
    public static int MAX_PORT_VALUE = 65535;

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextField) {
            JTextField field = (JTextField)input;
            try {
                if (field.getText().trim().equals("")) {
                    return true;
                }
                int result = Integer.parseInt(field.getText());
                if (result >= MIN_PORT_VALUE && result <= MAX_PORT_VALUE) {
                    return true;
                }
                throw new NumberFormatException("Outside port range");
            }
            catch (NumberFormatException nfe) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(input.getTopLevelAncestor(), "Enter a valid port number (" + MIN_PORT_VALUE + " to " + MAX_PORT_VALUE + ")", "Invalid port number", 2);
                return false;
            }
        }
        return true;
    }
}

