/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FinalizeDoesNotCallSuper {
    private static final String SUPER = "super";
    private static final String FINALIZE = "finalize";

    public static ErrorDescription hint(HintContext hintContext) {
        assert (hintContext != null);
        TreePath treePath = hintContext.getPath();
        MethodTree methodTree = (MethodTree)treePath.getLeaf();
        if (methodTree.getBody() == null) {
            return null;
        }
        if (!Util.isFinalize(methodTree)) {
            return null;
        }
        FindSuper findSuper = new FindSuper();
        findSuper.scan((Tree)methodTree, null);
        if (findSuper.found) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"TXT_FinalizeDoesNotCallSuper"), new FixImpl(TreePathHandle.create((TreePath)hintContext.getPath(), (CompilationInfo)hintContext.getInfo())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), treePath, "FinalizeDoesntCallSuperFinalize"));
    }

    static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        public FixImpl(TreePathHandle treePathHandle) {
            assert (treePathHandle != null);
            this.handle = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"FIX_FinalizeDoesNotCallSuper");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.handle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.handle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.METHOD) {
                        return;
                    }
                    BlockTree blockTree = ((MethodTree)treePath.getLeaf()).getBody();
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ArrayList<? extends StatementTree> arrayList = new ArrayList<StatementTree>(1 + blockTree.getStatements().size());
                    arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)FinalizeDoesNotCallSuper.SUPER), (CharSequence)FinalizeDoesNotCallSuper.FINALIZE), Collections.emptyList())));
                    arrayList.addAll(blockTree.getStatements());
                    workingCopy.rewrite((Tree)blockTree, (Tree)treeMaker.Block(arrayList, false));
                }
            }).commit();
            return null;
        }
    }

    static final class FindSuper
    extends TreeScanner<Void, Void> {
        boolean found;

        FindSuper() {
        }

        @Override
        public Void scan(Tree tree, Void void_) {
            return this.found ? null : (Void)super.scan(tree, void_);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
            if (!methodInvocationTree.getArguments().isEmpty()) {
                return null;
            }
            ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
            if (expressionTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                return null;
            }
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            if (!FinalizeDoesNotCallSuper.FINALIZE.contentEquals(memberSelectTree.getIdentifier())) {
                return null;
            }
            if (memberSelectTree.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (!FinalizeDoesNotCallSuper.SUPER.contentEquals(((IdentifierTree)memberSelectTree.getExpression()).getName())) {
                return null;
            }
            this.found = true;
            return null;
        }
    }
}

