/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class Utils {
    private static final String FULL_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_FullDateFormat");
    private static final String FULL_DATE_FORMAT_HIRES = NbBundle.getMessage(Utils.class, (String)"Utils_FullDateFormatHiRes");
    private static final String TODAY_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_TodayDateFormat");
    private static final String TODAY_DATE_FORMAT_HIRES = NbBundle.getMessage(Utils.class, (String)"Utils_TodayDateFormatHiRes");
    private static final String DAY_DATE_FORMAT = NbBundle.getMessage(Utils.class, (String)"Utils_DayDateFormat");
    private static final String CANNOT_OPEN_SOURCE_MSG = NbBundle.getMessage(Utils.class, (String)"Utils_CannotOpenSourceMsg");
    private static final String INVALID_PP_LOCATION_MSG = NbBundle.getMessage(Utils.class, (String)"Utils_InvalidPPLocationMsg");
    private static final String PROJECT_DIRECTORY_MARK = "{$projectDirectory}";
    public static final ImageIcon EMPTY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/empty16.gif", (boolean)false);
    private static final ProjectPresenterRenderer projectRenderer = new ProjectPresenterRenderer();
    private static final ProjectPresenterListRenderer projectListRenderer = new ProjectPresenterListRenderer();
    private static final EnhancedTableCellRenderer scopeRenderer = new ProfilingPointScopeRenderer();
    private static final ProfilingPointPresenterRenderer presenterRenderer = new ProfilingPointPresenterRenderer();
    private static final ProfilingPointPresenterListRenderer presenterListRenderer = new ProfilingPointPresenterListRenderer();
    private static final SimpleDateFormat fullDateFormat = new SimpleDateFormat(FULL_DATE_FORMAT);
    private static final SimpleDateFormat fullDateFormatHiRes = new SimpleDateFormat(FULL_DATE_FORMAT_HIRES);
    private static final SimpleDateFormat todayDateFormat = new SimpleDateFormat(TODAY_DATE_FORMAT);
    private static final SimpleDateFormat todayDateFormatHiRes = new SimpleDateFormat(TODAY_DATE_FORMAT_HIRES);
    private static final SimpleDateFormat dayDateFormat = new SimpleDateFormat(DAY_DATE_FORMAT);

    public static String getAbsolutePath(Project project, String string) {
        if (project == null) {
            File file = new File(string);
            return file.exists() ? string : null;
        }
        return new File(string.replace(PROJECT_DIRECTORY_MARK, FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath())).getAbsolutePath();
    }

    public static String getClassName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int n = Utils.getDocumentOffset(location);
        if (n == -1) {
            return null;
        }
        return SourceUtils.getEnclosingClassName((FileObject)fileObject, (int)n);
    }

    public static String getMethodName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int n = Utils.getDocumentOffset(location);
        if (n == -1) {
            return null;
        }
        return SourceUtils.getEnclosingMethodName((FileObject)fileObject, (int)n);
    }

    public static CodeProfilingPoint.Location getCurrentLocation(int n) {
        JavaEditorContext javaEditorContext = Utils.getMostActiveJavaEditorContext();
        if (javaEditorContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject fileObject = javaEditorContext.getFileObject();
        if (fileObject == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String string = file.getAbsolutePath();
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)javaEditorContext.getDocument()), (int)javaEditorContext.getTextComponent().getCaret().getDot()) + 1;
        if (n2 == -1) {
            n2 = 1;
        }
        return new CodeProfilingPoint.Location(string, n2, n);
    }

    public static Project getCurrentProject() {
        Project project = Utils.getMostActiveJavaProject();
        if (project == null) {
            project = ProjectUtilities.getMainProject();
        }
        return project;
    }

    public static CodeProfilingPoint.Location getCurrentSelectionEndLocation(int n) {
        JavaEditorContext javaEditorContext = Utils.getMostActiveJavaEditorContext();
        if (javaEditorContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject fileObject = javaEditorContext.getFileObject();
        if (fileObject == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent jTextComponent = javaEditorContext.getTextComponent();
        if (jTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)javaEditorContext.getDocument()), (int)jTextComponent.getSelectionEnd()) + 1;
        if (n2 == -1) {
            n2 = 1;
        }
        return new CodeProfilingPoint.Location(string, n2, n);
    }

    public static CodeProfilingPoint.Location[] getCurrentSelectionLocations() {
        int n;
        JavaEditorContext javaEditorContext = Utils.getMostActiveJavaEditorContext();
        if (javaEditorContext == null) {
            return new CodeProfilingPoint.Location[0];
        }
        FileObject fileObject = javaEditorContext.getFileObject();
        if (fileObject == null) {
            return new CodeProfilingPoint.Location[0];
        }
        JTextComponent jTextComponent = javaEditorContext.getTextComponent();
        if (jTextComponent.getSelectedText() == null) {
            return new CodeProfilingPoint.Location[0];
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return new CodeProfilingPoint.Location[0];
        }
        String string = file.getAbsolutePath();
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)javaEditorContext.getDocument()), (int)jTextComponent.getSelectionStart()) + 1;
        if (n2 == -1) {
            n2 = 1;
        }
        if ((n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)javaEditorContext.getDocument()), (int)jTextComponent.getSelectionEnd()) + 1) == -1) {
            n = 1;
        }
        return new CodeProfilingPoint.Location[]{new CodeProfilingPoint.Location(string, n2, Integer.MIN_VALUE), new CodeProfilingPoint.Location(string, n, Integer.MAX_VALUE)};
    }

    public static CodeProfilingPoint.Location getCurrentSelectionStartLocation(int n) {
        JavaEditorContext javaEditorContext = Utils.getMostActiveJavaEditorContext();
        if (javaEditorContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject fileObject = javaEditorContext.getFileObject();
        if (fileObject == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent jTextComponent = javaEditorContext.getTextComponent();
        if (jTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)javaEditorContext.getDocument()), (int)jTextComponent.getSelectionStart()) + 1;
        if (n2 == -1) {
            n2 = 1;
        }
        return new CodeProfilingPoint.Location(string, n2, n);
    }

    public static int getDocumentOffset(CodeProfilingPoint.Location location) {
        int n;
        int n2;
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return -1;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dataObject == null) {
            return -1;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return -1;
        }
        StyledDocument styledDocument = null;
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (styledDocument == null) {
            return -1;
        }
        try {
            n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(location.getLine() - 1));
            n = location.isLineStart() ? 0 : (location.isLineEnd() ? NbDocument.findLineOffset((StyledDocument)styledDocument, (int)location.getLine()) - n2 - 1 : location.getOffset());
        }
        catch (Exception exception) {
            return -1;
        }
        return n2 + n;
    }

    public static double getDurationInMicroSec(long l, long l2) {
        ProfilingSessionStatus profilingSessionStatus = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        double d = profilingSessionStatus.timerCountsInSecond[0] / 1000000L;
        return (double)(l2 - l) / d;
    }

    public static Line getEditorLine(CodeProfilingPoint.Location location) {
        String string = location.getFile();
        FileObject fileObject = null;
        try {
            fileObject = URLMapper.findFileObject((URL)new File(string).toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(location.getLine() - 1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValidLocation(CodeProfilingPoint.Location location) {
        Object object;
        String string = Utils.getMethodName(location);
        if (string == null) {
            return false;
        }
        if (location.isLineStart()) {
            return true;
        }
        if (location.isLineEnd() && string.equals(Utils.getMethodName((CodeProfilingPoint.Location)(object = new CodeProfilingPoint.Location(location.getFile(), location.getLine(), Integer.MIN_VALUE))))) {
            return true;
        }
        object = Utils.getEditorLine(location);
        if (object == null) {
            return false;
        }
        String string2 = object.getText().trim();
        return !string2.endsWith("{") || string2.indexOf("{") != string2.lastIndexOf("{");
    }

    public static void checkLocation(CodeProfilingPoint.Single single) {
        if (!Utils.isValidLocation(single.getLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, single.getName()));
        }
    }

    public static void checkLocation(CodeProfilingPoint.Paired paired) {
        if (!Utils.isValidLocation(paired.getStartLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, paired.getName()));
        } else if (paired.usesEndLocation() && !Utils.isValidLocation(paired.getEndLocation())) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(MessageFormat.format(INVALID_PP_LOCATION_MSG, paired.getName()));
        }
    }

    public static Project getMostActiveJavaProject() {
        JavaEditorContext javaEditorContext = Utils.getMostActiveJavaEditorContext();
        if (javaEditorContext == null) {
            return null;
        }
        FileObject fileObject = javaEditorContext.getFileObject();
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static ListCellRenderer getPresenterListRenderer() {
        return presenterListRenderer;
    }

    public static EnhancedTableCellRenderer getPresenterRenderer() {
        return presenterRenderer;
    }

    public static CodeProfilingPoint[] getProfilingPointsOnLine(CodeProfilingPoint.Location location) {
        if (location == null || location == CodeProfilingPoint.Location.EMPTY) {
            return new CodeProfilingPoint[0];
        }
        File file = new File(location.getFile());
        int n = location.getLine();
        ArrayList<CodeProfilingPoint> arrayList = new ArrayList<CodeProfilingPoint>();
        List<CodeProfilingPoint> list = ProfilingPointsManager.getDefault().getProfilingPoints(CodeProfilingPoint.class, null, false);
        block0: for (CodeProfilingPoint codeProfilingPoint : list) {
            for (CodeProfilingPoint.Annotation annotation : codeProfilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location location2 = codeProfilingPoint.getLocation(annotation);
                if (location2.getLine() != n || !new File(location2.getFile()).equals(file)) continue;
                arrayList.add(codeProfilingPoint);
                continue block0;
            }
        }
        return arrayList.toArray(new CodeProfilingPoint[arrayList.size()]);
    }

    public static ListCellRenderer getProjectListRenderer() {
        return projectListRenderer;
    }

    public static EnhancedTableCellRenderer getProjectRenderer() {
        return projectRenderer;
    }

    public static String getRelativePath(Project project, String string) {
        if (project == null) {
            return string;
        }
        String string2 = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
        if (!string.startsWith(string2)) {
            return string;
        }
        File file = FileUtil.normalizeFile((File)new File(string));
        return "{$projectDirectory}/" + FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)FileUtil.toFileObject((File)file));
    }

    public static EnhancedTableCellRenderer getScopeRenderer() {
        return scopeRenderer;
    }

    public static String getThreadClassName(int n) {
        return null;
    }

    public static String getThreadName(int n) {
        return "&lt;unknown thread, id=" + n + "&gt;";
    }

    public static long getTimeInMillis(long l) {
        ProfilingSessionStatus profilingSessionStatus = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        long l2 = profilingSessionStatus.startupTimeInCounts;
        long l3 = profilingSessionStatus.startupTimeMillis;
        long l4 = profilingSessionStatus.timerCountsInSecond[0] / 1000L;
        return l3 + (l - l2) / l4;
    }

    /*
     * WARNING - void declaration
     */
    public static String getUniqueName(String string, String string2, Project project) {
        void var6_9;
        List<ProfilingPoint> list = ProfilingPointsManager.getDefault().getProfilingPoints(project, false, true);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (ProfilingPoint object2 : list) {
            linkedList.add(object2.getName());
        }
        int n = 0;
        String string3 = "";
        while (linkedList.contains(string + (String)var6_9 + string2)) {
            String string4 = " " + Integer.toString(++n);
        }
        return string + (String)var6_9 + string2;
    }

    public static String formatLocalProfilingPointTime(long l) {
        Date date = new Date();
        Date date2 = new Date(l);
        if (dayDateFormat.format(date).equals(dayDateFormat.format(date2))) {
            return todayDateFormat.format(date2);
        }
        return fullDateFormat.format(date2);
    }

    public static String formatProfilingPointTime(long l) {
        long l2 = Utils.getTimeInMillis(l);
        Date date = new Date();
        Date date2 = new Date(l2);
        if (dayDateFormat.format(date).equals(dayDateFormat.format(date2))) {
            return todayDateFormat.format(date2);
        }
        return fullDateFormat.format(date2);
    }

    public static String formatProfilingPointTimeHiRes(long l) {
        long l2 = Utils.getTimeInMillis(l);
        Date date = new Date();
        Date date2 = new Date(l2);
        if (dayDateFormat.format(date).equals(dayDateFormat.format(date2))) {
            return todayDateFormatHiRes.format(date2);
        }
        return fullDateFormatHiRes.format(date2);
    }

    public static void openLocation(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        final FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        final int n = Utils.getDocumentOffset(location);
        if (n == -1) {
            NetBeansProfiler.getDefaultNB().displayError(CANNOT_OPEN_SOURCE_MSG);
            return;
        }
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                UiUtils.open((FileObject)fileObject, (int)n);
            }
        });
    }

    private static JavaEditorContext getMostActiveJavaEditorContext() {
        for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
            Document document = jTextComponent.getDocument();
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) continue;
            return new JavaEditorContext(jTextComponent, document, fileObject);
        }
        return null;
    }

    private static class ProjectPresenterRenderer
    extends LabelTableCellRenderer {
        private Font font;

        public ProjectPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.font = this.label.getFont();
        }

        public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new ProjectPresenterRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        protected void setValue(JTable jTable, Object object, int n, int n2) {
            if (object != null && (object instanceof Project || object instanceof ProfilingPoint)) {
                if (jTable != null) {
                    this.setFont(jTable.getFont());
                }
                if (object instanceof ProfilingPoint) {
                    this.label.setEnabled(((ProfilingPoint)object).isEnabled());
                    object = ((ProfilingPoint)object).getProject();
                } else {
                    this.label.setEnabled(true);
                }
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.label.setText(projectInformation.getDisplayName());
                this.label.setIcon(jTable.isEnabled() ? projectInformation.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)projectInformation.getIcon()).getImage())));
                this.label.setFont(ProjectUtilities.getMainProject() == object ? this.font.deriveFont(1) : this.font);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProjectPresenterListRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.renderer.setComponentOrientation(jLabel.getComponentOrientation());
            this.renderer.setFontEx(jLabel.getFont());
            this.renderer.setOpaque(jLabel.isOpaque());
            this.renderer.setForeground(jLabel.getForeground());
            this.renderer.setBackground(jLabel.getBackground());
            this.renderer.setEnabled(jLabel.isEnabled());
            this.renderer.setBorder(jLabel.getBorder());
            if (object != null && object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.renderer.setText(projectInformation.getDisplayName());
                this.renderer.setIcon(projectInformation.getIcon());
                if (ProjectUtilities.getMainProject() == object) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(jLabel.getText());
                this.renderer.setIcon(EMPTY_ICON);
            }
            return this.renderer;
        }

        private class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static class ProfilingPointScopeRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointScopeRenderer() {
            super(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        }

        public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new ProfilingPointScopeRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        protected void setValue(JTable jTable, Object object, int n, int n2) {
            this.label.setText("");
            if (object instanceof ProfilingPoint) {
                this.label.setIcon(((ProfilingPoint)object).getFactory().getScopeIcon());
                this.label.setEnabled(((ProfilingPoint)object).isEnabled());
            } else if (object instanceof ProfilingPointFactory) {
                this.label.setIcon(((ProfilingPointFactory)object).getScopeIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setIcon(EMPTY_ICON);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 5));
        }

        public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return new ProfilingPointPresenterRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        protected void setValue(JTable jTable, Object object, int n, int n2) {
            if (jTable != null) {
                this.setFont(jTable.getFont());
            }
            if (object instanceof ProfilingPoint) {
                this.label.setText(((ProfilingPoint)object).getName());
                this.label.setIcon(((ProfilingPoint)object).getFactory().getIcon());
                this.label.setEnabled(((ProfilingPoint)object).isEnabled());
            } else if (object instanceof ProfilingPointFactory) {
                this.label.setText(((ProfilingPointFactory)object).getType());
                this.label.setIcon(((ProfilingPointFactory)object).getIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterListRenderer
    extends DefaultListCellRenderer {
        private ProfilingPointPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setBorder(BorderFactory.createEmptyBorder(1, 7, 1, 5));
            if (object instanceof ProfilingPoint) {
                jLabel.setText(((ProfilingPoint)object).getName());
                jLabel.setIcon(((ProfilingPoint)object).getFactory().getIcon());
                jLabel.setEnabled(((ProfilingPoint)object).isEnabled());
            } else if (object instanceof ProfilingPointFactory) {
                jLabel.setText(((ProfilingPointFactory)object).getType());
                jLabel.setIcon(((ProfilingPointFactory)object).getIcon());
                jLabel.setEnabled(true);
            } else {
                jLabel.setIcon(null);
                jLabel.setEnabled(true);
            }
            return jLabel;
        }
    }

    private static class JavaEditorContext {
        private Document document;
        private FileObject fileObject;
        private JTextComponent textComponent;

        public JavaEditorContext(JTextComponent jTextComponent, Document document, FileObject fileObject) {
            this.textComponent = jTextComponent;
            this.document = document;
            this.fileObject = fileObject;
        }

        public Document getDocument() {
            return this.document;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public JTextComponent getTextComponent() {
            return this.textComponent;
        }
    }
}

