/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.w3c.dom.svg.SVGRect;

public class SVGRectangle {
    private float myX;
    private float myY;
    private float myWidth;
    private float myHeight;

    public SVGRectangle() {
    }

    public SVGRectangle(int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
    }

    public SVGRectangle(int x, int y, int width, int height) {
        this(width, height);
        this.myX = x;
        this.myY = y;
    }

    public SVGRectangle(SVGRect rectangle) {
        this((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public SVGRectangle(SVGRectangle rectangle) {
        this((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    SVGRectangle(float x, float y, float width, float height) {
        this.myX = x;
        this.myY = y;
        this.myWidth = width;
        this.myHeight = height;
    }

    public float getX() {
        return this.myX;
    }

    public float getY() {
        return this.myY;
    }

    public float getWidth() {
        return this.myWidth;
    }

    public float getHeight() {
        return this.myHeight;
    }

    public boolean contains(int x, int y) {
        return this.getX() <= (float)x && this.getX() + this.getWidth() >= (float)x && this.getY() <= (float)y && this.getY() + this.getHeight() >= (float)y;
    }

    public void setLocation(int x, int y) {
        this.myX = x;
        this.myY = y;
    }

    public void setSize(int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
    }

    public SVGRectangle union(SVGRectangle rectangle) {
        float x = Math.min(this.getX(), rectangle.getX());
        float y = Math.min(this.getY(), rectangle.getY());
        float width = Math.max(this.getX() + this.getWidth(), rectangle.getX() + rectangle.getWidth()) - x;
        float height = Math.max(this.getY() + this.getHeight(), rectangle.getY() + rectangle.getHeight()) - y;
        return new SVGRectangle(x, y, width, height);
    }
}

