/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;

public abstract class ProjectClassPathImplementation
implements ClassPathImplementation,
AntProjectListener,
Runnable {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final AntProjectHelper helper;
    private List<PathResourceImplementation> resources;
    private String path;

    public ProjectClassPathImplementation(AntProjectHelper helper) {
        assert (helper != null);
        this.helper = helper;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            String newPath = this.evaluatePath();
            if (this.resources == null) {
                List<PathResourceImplementation> newResources = this.createResources(newPath);
                ProjectClassPathImplementation projectClassPathImplementation = this;
                synchronized (projectClassPathImplementation) {
                    if (this.resources == null) {
                        this.path = newPath;
                        this.resources = newResources;
                    }
                }
            }
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addResource(PathResourceImplementation resource) {
        throw new UnsupportedOperationException();
    }

    public void removeResource(PathResourceImplementation resource) {
        List<PathResourceImplementation> l = this.getResources();
        if (l.contains(resource)) {
            throw new UnsupportedOperationException();
        }
    }

    public void reorder(PathResourceImplementation[] order) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public void propertiesChanged(AntProjectEvent ev) {
        ProjectManager.mutex().postWriteRequest((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String newPath = this.evaluatePath();
        boolean fire = false;
        if (this.resources == null || newPath == null || !newPath.equals(this.path)) {
            List<PathResourceImplementation> newResources = this.createResources(newPath);
            ProjectClassPathImplementation projectClassPathImplementation = this;
            synchronized (projectClassPathImplementation) {
                if (this.resources == null || newPath == null || !newPath.equals(this.path)) {
                    this.path = newPath;
                    this.resources = newResources;
                    fire = true;
                }
            }
        }
        if (fire) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List<PathResourceImplementation> createResources(String _path) {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        if (_path != null) {
            String[] pieces = PropertyUtils.tokenizePath((String)_path);
            for (int i = 0; i < pieces.length; ++i) {
                File f = FileUtil.normalizeFile((File)this.helper.resolveFile(pieces[i]));
                try {
                    URL entry = f.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)entry)) {
                        entry = FileUtil.getArchiveRoot((URL)entry);
                    } else if (!f.exists()) {
                        assert (!entry.toExternalForm().endsWith("/")) : f;
                        entry = new URL(entry.toExternalForm() + "/");
                    } else if (!entry.toExternalForm().endsWith("/")) {
                        entry = new URL(entry.toExternalForm() + "/");
                    }
                    result.add(ClassPathSupport.createResource((URL)entry));
                    continue;
                }
                catch (MalformedURLException mue) {
                    assert (false) : mue;
                    continue;
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected abstract String evaluatePath();
}

