/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GLFFilesCustomEditor
extends JPanel {
    private JButton bEdit;
    private JLabel jLabel1;
    private JList lFiles;
    private JScrollPane spFiles;

    public GLFFilesCustomEditor() {
        this.initComponents();
        List<String> mimeTypes = GLFFilesCustomEditor.getSupportedMimeTypes();
        Collections.sort(mimeTypes);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String name : mimeTypes) {
            model.addElement(name);
        }
        this.lFiles.setModel(model);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spFiles = new JScrollPane();
        this.lFiles = new JList();
        this.bEdit = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(GLFFilesCustomEditor.class, (String)"GLFFilesCustomEditor.jLabel1.text"));
        this.spFiles.setViewportView(this.lFiles);
        this.bEdit.setText(NbBundle.getMessage(GLFFilesCustomEditor.class, (String)"GLFFilesCustomEditor.bEdit.text"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GLFFilesCustomEditor.this.bEditActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.spFiles, -1, 75, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bEdit)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bEdit).addContainerGap()).add((Component)this.spFiles, -1, 139, Short.MAX_VALUE))));
    }

    private static List<String> getSupportedMimeTypes() {
        ArrayList<String> result = new ArrayList<String>();
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject root = fs.findResource("Editors");
        Enumeration e1 = root.getChildren(false);
        while (e1.hasMoreElements()) {
            FileObject f1 = (FileObject)e1.nextElement();
            if (f1.isData()) continue;
            Enumeration e2 = f1.getChildren(false);
            while (e2.hasMoreElements()) {
                FileObject fo;
                FileObject f2 = (FileObject)e2.nextElement();
                if (f2.isData() || (fo = f2.getFileObject("language.nbs")) == null) continue;
                result.add(f1.getName() + '/' + f2.getName());
            }
        }
        return result;
    }

    private void bEditActionPerformed(ActionEvent evt) {
        String mimeType = (String)this.lFiles.getSelectedValue();
        if (mimeType == null) {
            return;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + mimeType + "/language.nbs");
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
            openCookie.open();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

