/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TargetServer;
import org.netbeans.modules.j2ee.deployment.impl.projects.DeploymentTargetImpl;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public final class DeployOnSaveManager {
    private static final Logger LOGGER = Logger.getLogger(DeployOnSaveManager.class.getName());
    private static final int DELAY = 300;
    private static final int PROGRESS_DELAY = 200;
    private static DeployOnSaveManager instance;
    private final WeakHashMap<J2eeModuleProvider, CompileOnSaveListener> compileListeners = new WeakHashMap();
    private final WeakHashMap<J2eeModuleProvider, CopyOnSaveListener> copyListeners = new WeakHashMap();
    private final ExecutorService EXECUTOR = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    });
    private Map<J2eeModuleProvider, Set<ArtifactListener.Artifact>> toDeploy = new HashMap<J2eeModuleProvider, Set<ArtifactListener.Artifact>>();
    private Map<J2eeModuleProvider, DeploymentState> lastDeploymentStates = new HashMap<J2eeModuleProvider, DeploymentState>();
    private Future<?> current;

    private DeployOnSaveManager() {
    }

    public static synchronized DeployOnSaveManager getDefault() {
        if (instance == null) {
            instance = new DeployOnSaveManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (this.compileListeners.containsKey(j2eeModuleProvider)) {
                if (j2eeModuleProvider instanceof J2eeApplicationProvider) {
                    this.stopListening(j2eeModuleProvider);
                } else {
                    LOGGER.log(Level.FINE, "Already listening on {0}", j2eeModuleProvider);
                    return;
                }
            }
            ArrayList<J2eeModuleProvider> arrayList = new ArrayList<J2eeModuleProvider>(4);
            arrayList.add(j2eeModuleProvider);
            if (j2eeModuleProvider instanceof J2eeApplicationProvider) {
                Collections.addAll(arrayList, ((J2eeApplicationProvider)j2eeModuleProvider).getChildModuleProviders());
            }
            ArrayList<URL> arrayList2 = new ArrayList<URL>();
            for (J2eeModuleProvider object2 : arrayList) {
                for (FileObject fileObject : object2.getSourceFileMap().getSourceRoots()) {
                    URL uRL = URLMapper.findURL((FileObject)fileObject, (int)1);
                    if (uRL == null) continue;
                    arrayList2.add(uRL);
                }
            }
            CompileOnSaveListener compileOnSaveListener = new CompileOnSaveListener(j2eeModuleProvider, arrayList2);
            for (URL uRL : arrayList2) {
                BuildArtifactMapper.addArtifactsUpdatedListener((URL)uRL, (BuildArtifactMapper.ArtifactsUpdated)compileOnSaveListener);
            }
            this.compileListeners.put(j2eeModuleProvider, compileOnSaveListener);
            J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
            if (deployOnSaveSupport != null) {
                CopyOnSaveListener copyOnSaveListener = new CopyOnSaveListener(j2eeModuleProvider);
                deployOnSaveSupport.addArtifactListener(copyOnSaveListener);
                this.copyListeners.put(j2eeModuleProvider, copyOnSaveListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            CompileOnSaveListener compileOnSaveListener = this.compileListeners.remove(j2eeModuleProvider);
            if (compileOnSaveListener == null) {
                LOGGER.log(Level.FINE, "Not compile-listening on {0}", j2eeModuleProvider);
            } else {
                for (URL object : compileOnSaveListener.getRegistered()) {
                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)object, (BuildArtifactMapper.ArtifactsUpdated)compileOnSaveListener);
                }
            }
            CopyOnSaveListener copyOnSaveListener = this.copyListeners.remove(j2eeModuleProvider);
            if (compileOnSaveListener == null) {
                LOGGER.log(Level.FINE, "Not copy-listening on {0}", j2eeModuleProvider);
            } else {
                J2eeModuleProvider.DeployOnSaveSupport deployOnSaveSupport = j2eeModuleProvider.getDeployOnSaveSupport();
                if (deployOnSaveSupport != null) {
                    deployOnSaveSupport.removeArtifactListener(copyOnSaveListener);
                }
            }
        }
    }

    public static boolean isServerStateSupported(ServerInstance serverInstance) {
        return serverInstance.isRunning() && !serverInstance.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInitialDeployment(J2eeModuleProvider j2eeModuleProvider) {
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            if (this.compileListeners.containsKey(j2eeModuleProvider) && j2eeModuleProvider instanceof J2eeApplicationProvider) {
                this.startListening(j2eeModuleProvider);
            }
            if (!this.lastDeploymentStates.containsKey(j2eeModuleProvider)) {
                this.lastDeploymentStates.put(j2eeModuleProvider, DeploymentState.MODULE_UPDATED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitChangedArtifacts(J2eeModuleProvider j2eeModuleProvider, Iterable<ArtifactListener.Artifact> iterable) {
        assert (j2eeModuleProvider != null);
        assert (iterable != null);
        DeployOnSaveManager deployOnSaveManager = this;
        synchronized (deployOnSaveManager) {
            Set<ArtifactListener.Artifact> set = this.toDeploy.get(j2eeModuleProvider);
            if (set == null) {
                set = new HashSet<ArtifactListener.Artifact>();
                this.toDeploy.put(j2eeModuleProvider, set);
            }
            for (ArtifactListener.Artifact artifact : iterable) {
                set.add(artifact);
            }
            boolean bl = true;
            if (this.current != null && !this.current.isDone()) {
                this.current.cancel(false);
                bl = false;
            }
            this.current = this.EXECUTOR.submit(new DeployTask(bl));
        }
    }

    private class DeployTask
    implements Runnable {
        private final boolean delayed;

        public DeployTask(boolean bl) {
            this.delayed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map;
            if (this.delayed) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.INFO, null, interruptedException);
                    return;
                }
            }
            LOGGER.log(Level.FINE, "Performing pending deployments");
            DeployOnSaveManager deployOnSaveManager = DeployOnSaveManager.this;
            synchronized (deployOnSaveManager) {
                if (DeployOnSaveManager.this.toDeploy.isEmpty()) {
                    return;
                }
                map = DeployOnSaveManager.this.toDeploy;
                DeployOnSaveManager.this.toDeploy = new HashMap();
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                this.notifyServer((J2eeModuleProvider)entry.getKey(), (Iterable)entry.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyServer(J2eeModuleProvider j2eeModuleProvider, Iterable<ArtifactListener.Artifact> iterable) {
            DeploymentState deploymentState;
            Object iOException;
            Object object;
            Object object4;
            if (LOGGER.isLoggable(Level.FINEST)) {
                object4 = new StringBuilder("Artifacts updated: [");
                for (ArtifactListener.Artifact object32 : iterable) {
                    ((StringBuilder)object4).append(object32.getFile().getAbsolutePath()).append(",");
                }
                ((StringBuilder)object4).setLength(((StringBuilder)object4).length() - 1);
                ((StringBuilder)object4).append("]");
                LOGGER.log(Level.FINEST, ((StringBuilder)object4).toString());
            }
            Object object5 = this;
            synchronized (object5) {
                object4 = (DeploymentState)((Object)DeployOnSaveManager.this.lastDeploymentStates.get(j2eeModuleProvider));
                if (object4 == null) {
                    object4 = DeploymentState.MODULE_NOT_DEPLOYED;
                }
            }
            object5 = new DeploymentTargetImpl(j2eeModuleProvider, null);
            TargetServer targetServer = new TargetServer((DeploymentTarget)object5);
            if (object4 == null || object4 == DeploymentState.DEPLOYMENT_FAILED || object4 == DeploymentState.SERVER_STATE_UNSUPPORTED && DeployOnSaveManager.isServerStateSupported(((DeploymentTargetImpl)object5).getServer().getServerInstance())) {
                object = new ProgressUI(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployOnSave", (Object)j2eeModuleProvider.getDeploymentName()), false);
                ((ProgressUI)object).start(200);
                try {
                    DeploymentHelper.deployDatasources(j2eeModuleProvider);
                    DeploymentHelper.deployMessageDestinations(j2eeModuleProvider);
                    iOException = targetServer.deploy((ProgressUI)object, true);
                    if (iOException == null || ((TargetModule[])iOException).length <= 0) {
                        deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                    }
                    deploymentState = DeploymentState.MODULE_UPDATED;
                }
                catch (IOException serverException) {
                    LOGGER.log(Level.INFO, null, serverException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (ServerException configurationException) {
                    LOGGER.log(Level.INFO, null, configurationException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (ConfigurationException datasourceAlreadyExistsException) {
                    LOGGER.log(Level.INFO, null, datasourceAlreadyExistsException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                    LOGGER.log(Level.INFO, null, datasourceAlreadyExistsException);
                    deploymentState = DeploymentState.DEPLOYMENT_FAILED;
                }
                finally {
                    ((ProgressUI)object).finish();
                }
            } else {
                deploymentState = targetServer.notifyArtifactsUpdated(j2eeModuleProvider, iterable);
            }
            object = null;
            switch (deploymentState) {
                case MODULE_UPDATED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Deployed", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                case DEPLOYMENT_FAILED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Failed", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                case SERVER_STATE_UNSUPPORTED: {
                    object = NbBundle.getMessage(DeployOnSaveManager.class, (String)"MSG_DeployOnSave_Unsupported", (Object)j2eeModuleProvider.getDeploymentName());
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (object != null) {
                StatusDisplayer.getDefault().setStatusText((String)object);
            }
            LOGGER.log(Level.FINE, "Deployment state {0}", (Object)deploymentState);
            iOException = this;
            synchronized (iOException) {
                DeployOnSaveManager.this.lastDeploymentStates.put(j2eeModuleProvider, deploymentState);
            }
        }
    }

    private static final class CopyOnSaveListener
    implements ArtifactListener {
        private final J2eeModuleProvider provider;

        public CopyOnSaveListener(J2eeModuleProvider j2eeModuleProvider) {
            this.provider = j2eeModuleProvider;
        }

        @Override
        public void artifactsUpdated(Iterable<ArtifactListener.Artifact> iterable) {
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ArtifactListener.Artifact artifact : iterable) {
                    LOGGER.log(Level.FINE, "Delivered copy artifact: {0}", artifact);
                }
            }
            DeployOnSaveManager.getDefault().submitChangedArtifacts(this.provider, iterable);
        }
    }

    private static final class CompileOnSaveListener
    implements BuildArtifactMapper.ArtifactsUpdated {
        private final J2eeModuleProvider provider;
        private final List<URL> registered;

        public CompileOnSaveListener(J2eeModuleProvider j2eeModuleProvider, List<URL> list) {
            this.provider = j2eeModuleProvider;
            this.registered = list;
        }

        public List<URL> getRegistered() {
            return this.registered;
        }

        public void artifactsUpdated(Iterable<File> iterable) {
            J2eeModuleProvider.DeployOnSaveClassInterceptor deployOnSaveClassInterceptor = this.provider.getDeployOnSaveClassInterceptor();
            HashSet<ArtifactListener.Artifact> hashSet = new HashSet<ArtifactListener.Artifact>();
            for (File object : iterable) {
                if (object == null) continue;
                ArtifactListener.Artifact artifact = ArtifactListener.Artifact.forFile(object);
                if (deployOnSaveClassInterceptor != null) {
                    artifact = deployOnSaveClassInterceptor.convert(artifact);
                }
                hashSet.add(artifact);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ArtifactListener.Artifact artifact : hashSet) {
                    LOGGER.log(Level.FINE, "Delivered compile artifact: {0}", artifact);
                }
            }
            DeployOnSaveManager.getDefault().submitChangedArtifacts(this.provider, hashSet);
        }
    }

    public static enum DeploymentState {
        MODULE_NOT_DEPLOYED,
        MODULE_UPDATED,
        MODULE_HOT_SWAPPED,
        DEPLOYMENT_FAILED,
        SERVER_STATE_UNSUPPORTED;

    }
}

