/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NewFileWizard;
import org.netbeans.modules.project.ui.NoProjectNew;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class NewFile
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup {
    private static final Icon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/newFile.png", (boolean)false);
    private static final String _NAME = NbBundle.getMessage(NewFile.class, (String)"LBL_NewFileAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(NewFile.class, (String)"LBL_NewFileAction_Tooltip");
    private static final String POPUP_NAME = NbBundle.getMessage(NewFile.class, (String)"LBL_NewFileAction_PopupName");
    private static final String FILE_POPUP_NAME = NbBundle.getMessage(NewFile.class, (String)"LBL_NewFileAction_File_PopupName");
    private static final String TEMPLATE_NAME_FORMAT = NbBundle.getMessage(NewFile.class, (String)"LBL_NewFileAction_Template_PopupName");
    private JMenu subMenu;
    public static String TEMPLATE_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.Template";
    public static String IN_PROJECT_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.InProject";

    public NewFile() {
        this((Lookup)null);
    }

    public NewFile(Lookup context) {
        super((String)null, _NAME, ICON, context);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newFile.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                NewFile.this.setEnabled(OpenProjectList.getDefault().getOpenProjects().length > 0);
                NewFile.this.setDisplayName(_NAME);
            }
        });
    }

    @Override
    public JMenuItem getPopupPresenter() {
        JMenuItem menu = new JMenuItem(this);
        menu.setIcon(null);
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)((String)this.getValue("Name")));
        return menu;
    }

    @Override
    protected void actionPerformed(Lookup context) {
        this.doPerform(context, null, true);
    }

    private void doPerform(Lookup context, DataObject template, boolean inProject) {
        if (context == null) {
            context = this.getLookup();
        }
        if (!inProject) {
            NoProjectNew.showDialog(template, this.preselectedFolder(context));
            return;
        }
        if (OpenProjectList.getDefault().getOpenProjects().length == 0) {
            return;
        }
        NewFileWizard wd = new NewFileWizard(this.preselectedProject(context));
        DataFolder preselectedFolder = this.preselectedFolder(context);
        if (preselectedFolder != null) {
            wd.setTargetFolder(preselectedFolder);
        }
        try {
            Set resultSet;
            Set set = resultSet = template == null ? wd.instantiate() : wd.instantiate(template);
            if (resultSet == null || resultSet.isEmpty()) {
                return;
            }
            for (Object obj : resultSet) {
                DataObject newDO = null;
                if (obj instanceof DataObject) {
                    newDO = (DataObject)obj;
                } else if (obj instanceof FileObject) {
                    try {
                        newDO = DataObject.find((FileObject)((FileObject)obj));
                    }
                    catch (DataObjectNotFoundException x) {
                        assert (false) : obj;
                    }
                } else assert (false) : obj;
                if (newDO == null) continue;
                ProjectUtilities.openAndSelectNewObject(newDO);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        FileObject foTemplate = Templates.getTemplate((WizardDescriptor)wd);
        OpenProjectList.getDefault().updateTemplatesLRU(foTemplate);
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new NewFile(actionContext);
    }

    public JMenuItem getSubmenuPopupPresenter() {
        if (this.subMenu == null) {
            this.subMenu = new JMenu(POPUP_NAME);
        }
        return this.subMenu;
    }

    protected void fillSubMenu() {
        Project[] projects = ActionsUtil.getProjectsFromLookup(this.getLookup(), null);
        if (projects != null && projects.length > 0) {
            this.fillSubMenu(this.subMenu, projects[0]);
        } else {
            this.fillNonProjectSubMenu(this.subMenu);
        }
    }

    private Project preselectedProject(Lookup context) {
        Project preselectedProject = null;
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length > 0) {
            preselectedProject = projects[0];
        }
        if (preselectedProject == null && (preselectedProject = OpenProjectList.getDefault().getMainProject()) == null && OpenProjectList.getDefault().getOpenProjects().length > 0) {
            preselectedProject = OpenProjectList.getDefault().getOpenProjects()[0];
        }
        if (preselectedProject == null) assert (false) : "Action should be disabled";
        return preselectedProject;
    }

    private DataFolder preselectedFolder(Lookup context) {
        DataObject dobj;
        DataFolder preselectedFolder = null;
        preselectedFolder = (DataFolder)context.lookup(DataFolder.class);
        if (preselectedFolder == null && (dobj = (DataObject)context.lookup(DataObject.class)) != null) {
            preselectedFolder = dobj.getFolder();
        }
        return preselectedFolder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(Lookup.EMPTY, false);
    }

    private void fillSubMenu(JMenu menuItem, Project project) {
        menuItem.removeAll();
        PopupListener menuListener = new PopupListener();
        MessageFormat mf = new MessageFormat(TEMPLATE_NAME_FORMAT);
        boolean itemAdded = OpenProjectList.prepareTemplates(menuItem, menuListener, mf, TEMPLATE_PROPERTY, project, this.getLookup());
        if (itemAdded) {
            menuItem.add(new JPopupMenu.Separator());
        }
        JMenuItem fileItem = new JMenuItem(FILE_POPUP_NAME, (Icon)this.getValue("SmallIcon"));
        fileItem.addActionListener(menuListener);
        fileItem.putClientProperty(TEMPLATE_PROPERTY, null);
        menuItem.add(fileItem);
    }

    private void fillNonProjectSubMenu(JMenu menuItem) {
        FileObject pf;
        menuItem.removeAll();
        PopupListener menuListener = new PopupListener();
        DataFolder preselectedFolder = this.preselectedFolder(this.getLookup());
        boolean canWrite = preselectedFolder == null ? false : (pf = preselectedFolder.getPrimaryFile()) != null && pf.canWrite();
        DataObject[] templates = NoProjectNew.getTemplates();
        for (int i = 0; i < templates.length; ++i) {
            Node n = templates[i].getNodeDelegate();
            JMenuItem item = new JMenuItem(MessageFormat.format(TEMPLATE_NAME_FORMAT, n.getDisplayName()), new ImageIcon(n.getIcon(1)));
            item.addActionListener(menuListener);
            item.putClientProperty(TEMPLATE_PROPERTY, templates[i]);
            item.putClientProperty(IN_PROJECT_PROPERTY, Boolean.FALSE);
            item.setEnabled(canWrite);
            menuItem.add(item);
        }
    }

    public static final class WithSubMenu
    extends NewFile {
        public WithSubMenu() {
        }

        private WithSubMenu(Lookup actionContext) {
            super(actionContext);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            return new DynaMenu(POPUP_NAME);
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            return new WithSubMenu(actionContext);
        }

        private final class DynaMenu
        extends JMenu
        implements DynamicMenuContent {
            public DynaMenu(String a) {
                super(a);
            }

            public JComponent[] getMenuPresenters() {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            Boolean inProject = (Boolean)source.getClientProperty(IN_PROJECT_PROPERTY);
            DataObject template = (DataObject)source.getClientProperty(TEMPLATE_PROPERTY);
            if (inProject != null && inProject == Boolean.FALSE) {
                NewFile.this.doPerform(null, template, false);
            } else {
                NewFile.this.doPerform(null, template, true);
            }
        }
    }
}

