/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.ExternalProcessSupport;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.optional.WLServerProgress;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class WLStartServer
extends StartServer {
    private static final String SUN = "Sun";
    private static final int SERVER_CHECK_TIMEOUT = 10000;
    private static final Logger LOGGER = Logger.getLogger(WLStartServer.class.getName());
    private static Set<String> SERVERS_IN_DEBUG;
    private final WLDeploymentManager dm;
    private final ExecutorService service = Executors.newCachedThreadPool();
    private Process serverProcess;

    public WLStartServer(WLDeploymentManager wLDeploymentManager) {
        this.dm = wLDeploymentManager;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), new Integer(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean isDebuggable(Target target) {
        if (!WLStartServer.isServerInDebug(this.dm.getUri())) {
            return false;
        }
        return this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Process process = null;
        Object object = this;
        synchronized (object) {
            process = this.serverProcess;
        }
        if (!WLStartServer.isRunning(process)) {
            return false;
        }
        object = this.dm.getHost();
        int n = Integer.parseInt(this.dm.getPort().trim());
        return WLStartServer.ping((String)object, n, 10000);
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINER, "Starting server in debug mode");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)string));
        String string2 = this.dm.getUri();
        this.service.submit(new WLDebugStartTask(string2, wLServerProgress, this.dm));
        WLStartServer.addServerInDebug(string2);
        return wLServerProgress;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINER, "Starting server");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)string));
        String string2 = this.dm.getUri();
        this.service.submit(new WLStartTask(string2, wLServerProgress, this.dm));
        WLStartServer.removeServerInDebug(string2);
        return wLServerProgress;
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings profilerServerSettings) {
        LOGGER.log(Level.FINER, "Starting server in profiling mode");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)string));
        String string2 = this.dm.getUri();
        this.service.submit(new WLProfilingStartTask(string2, wLServerProgress, this.dm, profilerServerSettings));
        WLStartServer.removeServerInDebug(string2);
        return wLServerProgress;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINER, "Stopping server");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string));
        String string2 = this.dm.getUri();
        this.service.submit(new WLStopTask(string2, wLServerProgress, this.dm));
        WLStartServer.removeServerInDebug(string2);
        return wLServerProgress;
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    /*
     * Exception decompiling
     */
    private static boolean ping(String var0, int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized void addServerInDebug(String string) {
        if (SERVERS_IN_DEBUG == null) {
            SERVERS_IN_DEBUG = new HashSet<String>(1);
        }
        SERVERS_IN_DEBUG.add(string);
    }

    private static synchronized void removeServerInDebug(String string) {
        if (SERVERS_IN_DEBUG == null) {
            return;
        }
        SERVERS_IN_DEBUG.remove(string);
    }

    private static synchronized boolean isServerInDebug(String string) {
        return SERVERS_IN_DEBUG != null && SERVERS_IN_DEBUG.contains(string);
    }

    private static void startService(String string, Process process, ExecutorService executorService) {
        InputOutput inputOutput = UISupport.getServerIO((String)string);
        if (inputOutput == null) {
            return;
        }
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        inputOutput.select();
        executorService.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()), (InputProcessor)InputProcessors.printing((OutputWriter)inputOutput.getOut(), (boolean)true)));
        executorService.submit((Runnable)InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()), (InputProcessor)InputProcessors.printing((OutputWriter)inputOutput.getErr(), (boolean)false)));
    }

    private static void stopService(final ExecutorService executorService) {
        if (executorService != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    executorService.shutdownNow();
                    return null;
                }
            });
        }
    }

    private static boolean isRunning(Process process) {
        if (process != null) {
            try {
                process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean needsRestart(Target target) {
        return this.dm.isRestartNeeded();
    }

    private class WLStopTask
    implements Runnable {
        private static final int TIMEOUT = 300000;
        private static final int DELAY = 1000;
        private static final String SHUTDOWN_SH = "stopWebLogic.sh";
        private static final String SHUTDOWN_BAT = "stopWebLogic.cmd";
        private static final String KEY_UUID = "NB_EXEC_WL_STOP_PROCESS_UUID";
        private final String uri;
        private final WLServerProgress serverProgress;
        private final WLDeploymentManager dm;

        public WLStopTask(String string, WLServerProgress wLServerProgress, WLDeploymentManager wLDeploymentManager) {
            this.uri = string;
            this.serverProgress = wLServerProgress;
            this.dm = wLDeploymentManager;
        }

        @Override
        public void run() {
            String string = this.dm.getInstanceProperties().getProperty("username");
            String string2 = this.dm.getInstanceProperties().getProperty("password");
            String[] stringArray = this.uri.substring("deployer:WebLogic:http://".length()).split(":");
            String string3 = stringArray[0];
            String string4 = stringArray.length > 1 ? stringArray[1] : "";
            String string5 = this.dm.getInstanceProperties().getProperty("domainRoot");
            File file = new File(string5);
            if (!file.exists() || !file.isDirectory()) {
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_NO_DOMAIN_HOME"));
                return;
            }
            ExecutorService executorService = null;
            try {
                long l = System.currentTimeMillis();
                String string6 = UUID.randomUUID().toString();
                ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(Utilities.isWindows() ? new File(new File(file, "bin"), SHUTDOWN_BAT).getAbsolutePath() : new File(new File(file, "bin"), SHUTDOWN_SH).getAbsolutePath());
                externalProcessBuilder = externalProcessBuilder.workingDirectory(file).addEnvironmentVariable(KEY_UUID, string6).addArgument(string).addArgument(string2).addArgument("t3://" + string3 + ":" + string4);
                String string7 = this.dm.getProductProperties().getMiddlewareHome();
                if (string7 != null) {
                    externalProcessBuilder = externalProcessBuilder.addEnvironmentVariable("MW_HOME", string7);
                }
                Process process = externalProcessBuilder.call();
                executorService = Executors.newFixedThreadPool(2);
                WLStartServer.startService(this.uri, process, executorService);
                String string8 = this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - l < 300000L) {
                    if (WLStartServer.this.isRunning() && WLStartServer.isRunning(process)) {
                        this.serverProgress.notifyStop(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string8));
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_INTERRUPTED"));
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_INTERRUPTED"));
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_FAILED", (Object)string8));
                    } else {
                        this.serverProgress.notifyStop(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STOPPED", (Object)string8));
                    }
                    return;
                }
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_TIMEOUT"));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(KEY_UUID, string6);
                ExternalProcessSupport.destroy((Process)process, hashMap);
                WLStartServer.stopService(executorService);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
    }

    private class WLStartTask
    implements Runnable {
        private static final int TIMEOUT = 300000;
        private static final int DELAY = 1000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";
        private final String uri;
        private final WLServerProgress serverProgress;
        private final WLDeploymentManager dm;

        public WLStartTask(String string, WLServerProgress wLServerProgress, WLDeploymentManager wLDeploymentManager) {
            this.uri = string;
            this.serverProgress = wLServerProgress;
            this.dm = wLDeploymentManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = this.dm.getInstanceProperties().getProperty("domainRoot");
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_NO_DOMAIN_HOME"));
                return;
            }
            try {
                long l = System.currentTimeMillis();
                ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(Utilities.isWindows() ? new File(file, STARTUP_BAT).getAbsolutePath() : new File(file, STARTUP_SH).getAbsolutePath());
                externalProcessBuilder = externalProcessBuilder.workingDirectory(file);
                String string2 = this.dm.getProductProperties().getMiddlewareHome();
                if (string2 != null) {
                    externalProcessBuilder = externalProcessBuilder.addEnvironmentVariable("MW_HOME", string2);
                }
                externalProcessBuilder = this.initBuilder(externalProcessBuilder);
                Process process = null;
                Object object = WLStartServer.this;
                synchronized (object) {
                    WLStartServer.this.serverProcess = externalProcessBuilder.call();
                    process = WLStartServer.this.serverProcess;
                }
                object = Executors.newFixedThreadPool(2);
                WLStartServer.startService(this.uri, process, (ExecutorService)object);
                String string3 = this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - l < 300000L) {
                    if (this.isRunning()) {
                        this.dm.setRestartNeeded(false);
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)string3));
                        boolean bl = false;
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        if (bl) {
                            Thread.currentThread().interrupt();
                        } else {
                            WLStartServer.stopService((ExecutorService)object);
                        }
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_INTERRUPTED"));
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_TIMEOUT"));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }

        protected ExternalProcessBuilder initBuilder(ExternalProcessBuilder externalProcessBuilder) {
            return externalProcessBuilder;
        }

        protected boolean isRunning() {
            return WLStartServer.this.isRunning();
        }

        protected WLServerProgress getProgress() {
            return this.serverProgress;
        }
    }

    private class WLDebugStartTask
    extends WLStartTask {
        public WLDebugStartTask(String string, WLServerProgress wLServerProgress, WLDeploymentManager wLDeploymentManager) {
            super(string, wLServerProgress, wLDeploymentManager);
        }

        @Override
        protected ExternalProcessBuilder initBuilder(ExternalProcessBuilder externalProcessBuilder) {
            int n = 4000;
            n = Integer.parseInt(WLStartServer.this.dm.getInstanceProperties().getProperty("debuggerPort"));
            ExternalProcessBuilder externalProcessBuilder2 = externalProcessBuilder.addEnvironmentVariable("JAVA_OPTIONS", "-Xdebug -Xnoagent -Djava.compiler=none -Xrunjdwp:server=y,suspend=n,transport=dt_socket,address=" + n);
            return externalProcessBuilder2;
        }
    }

    private class WLProfilingStartTask
    extends WLStartTask {
        private final ProfilerServerSettings mySettings;

        public WLProfilingStartTask(String string, WLServerProgress wLServerProgress, WLDeploymentManager wLDeploymentManager, ProfilerServerSettings profilerServerSettings) {
            super(string, wLServerProgress, wLDeploymentManager);
            this.mySettings = profilerServerSettings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            int n = ProfilerSupport.getState();
            if (n == 0) {
                this.getProgress().notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_PROFILED_SERVER_FAILED", (Object)WLStartServer.this.dm.getInstanceProperties().getProperty("displayName")));
                Process process = null;
                WLStartServer wLStartServer = WLStartServer.this;
                synchronized (wLStartServer) {
                    process = WLStartServer.this.serverProcess;
                }
                process.destroy();
            }
        }

        @Override
        protected ExternalProcessBuilder initBuilder(ExternalProcessBuilder externalProcessBuilder) {
            ExternalProcessBuilder externalProcessBuilder2 = externalProcessBuilder;
            JavaPlatform javaPlatform = this.getSettings().getJavaPlatform();
            String string = javaPlatform.getVendor();
            String string2 = this.getJavaHome(javaPlatform);
            externalProcessBuilder2 = externalProcessBuilder2.addEnvironmentVariable("JAVA_HOME", string2);
            if (WLStartServer.SUN.equals(string)) {
                externalProcessBuilder2 = externalProcessBuilder2.addEnvironmentVariable("SUN_JAVA_HOME", string2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = this.getSettings().getJvmArgs();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(" ").append(stringArray[i]);
            }
            externalProcessBuilder2 = externalProcessBuilder2.addEnvironmentVariable("JAVA_OPTIONS", stringBuilder.toString());
            return externalProcessBuilder2;
        }

        @Override
        protected boolean isRunning() {
            int n = ProfilerSupport.getState();
            if (n == 2 || n == 3 || n == 4) {
                return true;
            }
            return super.isRunning();
        }

        private String getJavaHome(JavaPlatform javaPlatform) {
            FileObject fileObject = (FileObject)javaPlatform.getInstallFolders().iterator().next();
            return FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        }

        private ProfilerServerSettings getSettings() {
            return this.mySettings;
        }
    }
}

