/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SvnProperties
implements ActionListener {
    private static final HashSet<String> DIR_ONLY_PROPERTIES = new HashSet<String>(Arrays.asList("svn:ignore", "svn:externals"));
    private static final HashSet<String> FILE_ONLY_PROPERTIES = new HashSet<String>(Arrays.asList("svn:eol-style", "svn:executable", "svn:keywords", "svn:needs-lock", "svn:mime-type"));
    private static final HashSet<String> MIXED_PROPERTIES = new HashSet(DIR_ONLY_PROPERTIES.size() + FILE_ONLY_PROPERTIES.size());
    private PropertiesPanel panel;
    private File[] roots;
    private PropertiesTable propTable;
    private SvnProgressSupport support;
    private boolean loadedFromFile;
    private File loadedValueFile;
    private final Set<File> folders = new HashSet<File>();
    private final Set<File> files = new HashSet<File>();
    private final Map<String, Set<File>> filesPerProperty = new HashMap<String, Set<File>>();

    public SvnProperties(PropertiesPanel panel, PropertiesTable propTable, File[] files) {
        this.panel = panel;
        this.propTable = propTable;
        this.roots = files;
        propTable.getTable().addMouseListener(new TableMouseListener());
        panel.btnRefresh.addActionListener(this);
        panel.btnAdd.addActionListener(this);
        panel.btnRemove.addActionListener(this);
        panel.btnBrowse.addActionListener(this);
        panel.comboName.setEditable(true);
        for (File f : files) {
            if (f.isDirectory()) {
                this.folders.add(f);
                continue;
            }
            this.files.add(f);
        }
        panel.setForDirectory(!this.folders.isEmpty());
        if (this.folders.isEmpty()) {
            panel.setIllegalPropertyNames(DIR_ONLY_PROPERTIES.toArray(new String[DIR_ONLY_PROPERTIES.size()]), "PropertiesPanel.errInvalidPropertyForFile");
        } else {
            panel.setRecursiveProperties(FILE_ONLY_PROPERTIES);
        }
        this.setLoadedValueFile(null);
        this.initPropertyNameCbx();
        this.setLoadedFromFile(false);
        this.refreshProperties();
        panel.initInteraction();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel panel) {
        this.panel = panel;
    }

    public File[] getFiles() {
        return this.roots;
    }

    private void setLoadedValueFile(File file) {
        this.loadedValueFile = file;
    }

    private File getLoadedValueFile() {
        return this.loadedValueFile;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.panel.btnRefresh)) {
            this.refreshProperties();
        }
        if (source.equals(this.panel.btnAdd)) {
            this.setProperties();
        }
        if (source.equals(this.panel.btnRemove)) {
            this.removeProperties();
        }
        if (source.equals(this.panel.btnBrowse)) {
            this.loadFromFile();
        }
    }

    protected void initPropertyNameCbx() {
        if (this.panel.comboName.isEditable()) {
            this.panel.setPredefinedPropertyNames(this.folders.isEmpty() ? FILE_ONLY_PROPERTIES.toArray(new String[FILE_ONLY_PROPERTIES.size()]) : MIXED_PROPERTIES.toArray(new String[MIXED_PROPERTIES.size()]));
        }
    }

    protected String getPropertyValue() {
        return SvnUtils.fixLineEndings(this.panel.getPropertyValue());
    }

    protected String getPropertyName() {
        return this.panel.getPropertyName();
    }

    public boolean isLoadedFromFile() {
        return this.loadedFromFile;
    }

    public void setLoadedFromFile(boolean value) {
        this.loadedFromFile = value;
        if (this.loadedFromFile) {
            this.panel.setPropertyValueChangeListener(this);
        }
    }

    public void handleBinaryFile(File source) {
        this.setLoadedValueFile(source);
        StringBuilder txtValue = new StringBuilder();
        txtValue.append(NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content"));
        txtValue.append("\n");
        try {
            txtValue.append(source.getCanonicalPath());
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
        this.panel.txtAreaValue.setText(txtValue.toString());
        this.setLoadedFromFile(true);
    }

    public void loadFromFile() {
        AccessibleJFileChooser chooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnProperties.class, (String)"ACSD_Properties"));
        chooser.setDialogTitle(NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilters = chooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilters.length; ++i) {
            FileFilter fileFilter = fileFilters[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.setCurrentDirectory(this.roots[0].getParentFile());
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.exists();
            }

            @Override
            public String getDescription() {
                return "";
            }
        });
        chooser.setDialogType(0);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(SvnProperties.class, (String)"MNE_LoadValue").charAt(0));
        chooser.setApproveButtonText(NbBundle.getMessage(SvnProperties.class, (String)"CTL_LoadValue"));
        DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(SvnProperties.class, (String)"CTL_Load_Value_Title"));
        dd.setOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        chooser.addActionListener(new ActionListener((JFileChooser)chooser, dialog){
            final /* synthetic */ JFileChooser val$chooser;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$chooser = jFileChooser;
                this.val$dialog = dialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    File source = this.val$chooser.getSelectedFile();
                    if (Utils.isFileContentText((File)source)) {
                        if (source.canRead()) {
                            StringWriter sw = new StringWriter();
                            try {
                                Utils.copyStreamsCloseAll((Writer)sw, (Reader)new FileReader(source));
                                ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(sw.toString());
                            }
                            catch (IOException ex) {
                                Subversion.LOG.log(Level.SEVERE, null, ex);
                            }
                        }
                    } else {
                        SvnProperties.this.handleBinaryFile(source);
                    }
                }
                this.val$dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                HashMap<String, String> properties;

                @Override
                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                        this.properties = new HashMap();
                        for (File f : SvnProperties.this.roots) {
                            ISVNStatus status = this.client.getSingleStatus(f);
                            if (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) continue;
                            this.addProperties(f, this.client.getProperties(f));
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String[] propNames = new String[properties.size()];
                            SvnPropertiesNode[] svnProps = new SvnPropertiesNode[properties.size()];
                            int i = 0;
                            for (Map.Entry<String, String> e : properties.entrySet()) {
                                String name;
                                propNames[i] = name = e.getKey();
                                String value = e.getValue();
                                svnProps[i] = new SvnPropertiesNode(name, value);
                                ++i;
                            }
                            SvnProperties.this.propTable.setNodes(svnProps);
                            SvnProperties.this.panel.setExistingPropertyNames(propNames);
                        }
                    });
                }

                private void addProperties(File file, ISVNProperty[] toAddProps) {
                    for (ISVNProperty prop : toAddProps) {
                        String tmp;
                        String propName = prop.getName();
                        String propValue = SvnUtils.isBinary(prop.getData()) ? NbBundle.getMessage(SvnProperties.class, (String)"Binary_Content") : ((tmp = prop.getValue()) != null ? tmp : "");
                        String existingValue = this.properties.get(propName);
                        if (existingValue != null && !existingValue.equals(propValue)) {
                            propValue = NbBundle.getMessage(SvnProperties.class, (String)"SvnProperties.VariousValues");
                        }
                        this.properties.put(propName, propValue);
                        HashSet<File> filesPerProp = (HashSet<File>)SvnProperties.this.filesPerProperty.get(propName);
                        if (filesPerProp == null) {
                            filesPerProp = new HashSet<File>();
                            SvnProperties.this.filesPerProperty.put(propName, filesPerProp);
                        }
                        filesPerProp.add(file);
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;
                ISVNProperty[] isvnProps;

                @Override
                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    boolean recursively = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                    try {
                        String propName = SvnProperties.this.getPropertyName();
                        for (File root : SvnProperties.this.getAllowedFiles(propName, recursively)) {
                            SvnProperties.this.addFile(this.client, root, recursively);
                            if (SvnProperties.this.isLoadedFromFile()) {
                                try {
                                    this.client.propertySet(root, propName, SvnProperties.this.getLoadedValueFile(), recursively);
                                    continue;
                                }
                                catch (IOException ex) {
                                    Subversion.LOG.log(Level.SEVERE, null, ex);
                                    return;
                                }
                            }
                            this.client.propertySet(root, propName, SvnProperties.this.getPropertyValue(), recursively);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem("");
                            ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
                        }
                    });
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    private File[] getAllowedFiles(String propertyName, boolean recursively) {
        LinkedList<File> fileList = new LinkedList<File>();
        for (File root : this.roots) {
            boolean isFile = this.files.contains(root);
            if (isFile && DIR_ONLY_PROPERTIES.contains(propertyName) || !isFile && !recursively && FILE_ONLY_PROPERTIES.contains(propertyName)) continue;
            fileList.add(root);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private File[] getFilesWithProperty(String propertyName) {
        Set<File> filesWithProperty = this.filesPerProperty.get(propertyName);
        HashSet<File> fileList = new HashSet<File>();
        if (filesWithProperty != null) {
            fileList.addAll(filesWithProperty);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private void addFile(SvnClient client, File file, boolean recursively) throws SVNClientException {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        ISVNStatus status = client.getSingleStatus(file);
        if (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            client.addFile(file);
            if (recursively && file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) {
                    return;
                }
                for (File f : files) {
                    this.addFile(client, f, recursively);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperties() {
        SVNUrl repositoryUrl;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(this.roots[0]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final int[] rows = this.propTable.getSelectedItems();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client;

                @Override
                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(repositoryUrl);
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                    try {
                        boolean recursively = ((SvnProperties)SvnProperties.this).panel.cbxRecursively.isSelected();
                        SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                        List<SvnPropertiesNode> lstSvnPropertiesNodes = Arrays.asList(svnPropertiesNodes);
                        for (int i = rows.length - 1; i >= 0; --i) {
                            String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])].getName();
                            for (File root : SvnProperties.this.getFilesWithProperty(svnPropertyName)) {
                                this.client.propertyDel(root, svnPropertyName, recursively);
                            }
                            try {
                                lstSvnPropertiesNodes.remove(svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[i])]);
                                continue;
                            }
                            catch (UnsupportedOperationException e) {
                                // empty catch block
                            }
                        }
                        final SvnPropertiesNode[] remainingNodes = (SvnPropertiesNode[])lstSvnPropertiesNodes.toArray();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SvnProperties.this.propTable.setNodes(remainingNodes);
                                if (remainingNodes.length == 0) {
                                    SvnProperties.this.panel.setExistingPropertyNames(new String[0]);
                                } else {
                                    String[] propNames = new String[remainingNodes.length];
                                    for (int i = 0; i < propNames.length; ++i) {
                                        propNames[i] = remainingNodes[i].getName();
                                    }
                                    SvnProperties.this.panel.setExistingPropertyNames(propNames);
                                }
                            }
                        });
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
        this.refreshProperties();
    }

    public void propertyValueChanged() {
        assert (this.isLoadedFromFile());
        this.panel.removePropertyValueChangeListener();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText("");
            }
        });
        this.setLoadedFromFile(false);
    }

    static {
        MIXED_PROPERTIES.addAll(DIR_ONLY_PROPERTIES);
        MIXED_PROPERTIES.addAll(FILE_ONLY_PROPERTIES);
    }

    public class TableMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                int[] rows = SvnProperties.this.propTable.getSelectedItems();
                SvnPropertiesNode[] svnPropertiesNodes = SvnProperties.this.propTable.getNodes();
                if (svnPropertiesNodes == null) {
                    return;
                }
                final String svnPropertyName = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getName();
                final String svnPropertyValue = svnPropertiesNodes[SvnProperties.this.propTable.getModelIndex(rows[0])].getValue();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((SvnProperties)SvnProperties.this).panel.comboName.getEditor().setItem(svnPropertyName);
                        ((SvnProperties)SvnProperties.this).panel.txtAreaValue.setText(svnPropertyValue);
                    }
                });
            }
        }
    }
}

