/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.servicetag.RegistrationDocument;
import org.netbeans.modules.servicetag.ServiceTag;
import org.netbeans.modules.servicetag.SystemEnvironment;
import org.netbeans.modules.servicetag.Util;

public class RegistrationData {
    private final Map<String, String> environment = this.initEnvironment();
    private final Map<String, ServiceTag> svcTagMap = new LinkedHashMap<String, ServiceTag>();
    private final String urn;

    public RegistrationData() {
        this.urn = Util.generateURN();
        SystemEnvironment sysEnv = SystemEnvironment.getSystemEnvironment();
        this.setEnvironment("hostname", sysEnv.getHostname());
        this.setEnvironment("hostId", sysEnv.getHostId());
        this.setEnvironment("osName", sysEnv.getOsName());
        this.setEnvironment("osVersion", sysEnv.getOsVersion());
        this.setEnvironment("osArchitecture", sysEnv.getOsArchitecture());
        this.setEnvironment("systemModel", sysEnv.getSystemModel());
        this.setEnvironment("systemManufacturer", sysEnv.getSystemManufacturer());
        this.setEnvironment("cpuManufacturer", sysEnv.getCpuManufacturer());
        this.setEnvironment("serialNumber", sysEnv.getSerialNumber());
    }

    RegistrationData(String urn) {
        this.urn = urn;
    }

    private Map<String, String> initEnvironment() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("hostname", "");
        map.put("hostId", "");
        map.put("osName", "");
        map.put("osVersion", "");
        map.put("osArchitecture", "");
        map.put("systemModel", "");
        map.put("systemManufacturer", "");
        map.put("cpuManufacturer", "");
        map.put("serialNumber", "");
        return map;
    }

    public String getRegistrationURN() {
        return this.urn;
    }

    public Map<String, String> getEnvironmentMap() {
        return new LinkedHashMap<String, String>(this.environment);
    }

    public void setEnvironment(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.environment.containsKey(name)) {
            if ((name.equals("hostname") || name.equals("osName")) && value.length() == 0) {
                throw new IllegalArgumentException("\"" + name + "\" requires non-empty value.");
            }
        } else {
            throw new IllegalArgumentException("\"" + name + "\" is not an environment element.");
        }
        this.environment.put(name, value);
    }

    public Set<ServiceTag> getServiceTags() {
        return new HashSet<ServiceTag>(this.svcTagMap.values());
    }

    public synchronized ServiceTag addServiceTag(ServiceTag st) {
        ServiceTag svcTag = ServiceTag.newInstanceWithUrnTimestamp(st);
        String instanceURN = svcTag.getInstanceURN();
        if (this.svcTagMap.containsKey(instanceURN)) {
            throw new IllegalArgumentException("Instance_urn = " + instanceURN + " already exists in the registration data.");
        }
        this.svcTagMap.put(instanceURN, svcTag);
        return svcTag;
    }

    public synchronized ServiceTag getServiceTag(String instanceURN) {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        return this.svcTagMap.get(instanceURN);
    }

    public synchronized ServiceTag removeServiceTag(String instanceURN) {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        ServiceTag svcTag = null;
        if (this.svcTagMap.containsKey(instanceURN)) {
            svcTag = this.svcTagMap.remove(instanceURN);
        }
        return svcTag;
    }

    public synchronized ServiceTag updateServiceTag(String instanceURN, String productDefinedInstanceID) {
        ServiceTag svcTag = this.getServiceTag(instanceURN);
        if (svcTag == null) {
            return null;
        }
        svcTag = ServiceTag.newInstanceWithUrnTimestamp(svcTag);
        svcTag.setProductDefinedInstanceID(productDefinedInstanceID);
        this.svcTagMap.put(instanceURN, svcTag);
        return svcTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistrationData loadFromXML(InputStream in) throws IOException {
        try {
            RegistrationData registrationData = RegistrationDocument.load(in);
            return registrationData;
        }
        finally {
            in.close();
        }
    }

    public void storeToXML(OutputStream os) throws IOException {
        RegistrationDocument.store(os, this);
        os.flush();
    }

    public byte[] toXML() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.storeToXML(out);
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            return "Error creating the return string.";
        }
    }
}

