/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.letter;

import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.letter.CGLetter;
import com.sun.star.wizards.letter.CGLetterWizard;
import com.sun.star.wizards.letter.CGPaperElementLocation;
import com.sun.star.wizards.letter.LetterDocument;
import com.sun.star.wizards.letter.LetterWizardDialog;
import com.sun.star.wizards.letter.LocaleCodes;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextFrameHandler;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.ui.PathSelection;
import com.sun.star.wizards.ui.XPathSelectionListener;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.RadioDataAware;
import com.sun.star.wizards.ui.event.UnoDataAware;
import java.util.Vector;

public class LetterWizardDialogImpl
extends LetterWizardDialog {
    static LetterDocument myLetterDoc;
    static boolean running;
    XMultiServiceFactory xmsf;
    XTextDocument xTextDocument;
    PathSelection myPathSelection;
    CGLetterWizard myConfig;
    Vector mainDA = new Vector();
    Vector letterDA = new Vector();
    Vector businessDA = new Vector();
    String[][] BusinessFiles;
    String[][] OfficialFiles;
    String[][] PrivateFiles;
    String[] Norms;
    String[] NormPaths;
    String[] NormNames;
    String sTemplatePath;
    String sUserTemplatePath;
    String sBitmapPath;
    String sLetterPath;
    String sLetterLangPackPath;
    String sWorkPath;
    String sCurrentNorm;
    String sPath;
    boolean bEditTemplate;
    boolean bSaveSuccess = false;
    private boolean filenameChanged = false;
    LetterDocument.BusinessPaperObject BusCompanyLogo = null;
    LetterDocument.BusinessPaperObject BusCompanyAddress = null;
    LetterDocument.BusinessPaperObject BusCompanyAddressReceiver = null;
    LetterDocument.BusinessPaperObject BusFooter = null;
    static final int RM_TYPESTYLE = 1;
    static final int RM_BUSINESSPAPER = 2;
    static final int RM_ELEMENTS = 3;
    static final int RM_SENDERRECEIVER = 4;
    static final int RM_FOOTER = 5;
    static final int RM_FINALSETTINGS = 6;

    protected void enterStep(int n, int n2) {
    }

    protected void leaveStep(int n, int n2) {
    }

    public LetterWizardDialogImpl(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.xmsf = xMultiServiceFactory;
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=127.0.0.1,port=8100;urp,negotiate=0,forcesynchronous=1;StarOffice.ServiceManager";
        XMultiServiceFactory xMultiServiceFactory = null;
        try {
            xMultiServiceFactory = Desktop.connect(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LetterWizardDialogImpl letterWizardDialogImpl = new LetterWizardDialogImpl(xMultiServiceFactory);
        letterWizardDialogImpl.startWizard(xMultiServiceFactory, null);
    }

    public void startWizard(XMultiServiceFactory xMultiServiceFactory, Object[] objectArray) {
        running = true;
        try {
            int n;
            this.setMaxStep(6);
            myLetterDoc = new LetterDocument(xMultiServiceFactory, this);
            this.drawNaviBar();
            this.buildStep1();
            this.buildStep2();
            this.buildStep3();
            this.buildStep4();
            this.buildStep5();
            this.buildStep6();
            this.initializePaths();
            this.initializeNorms();
            this.initializeSalutation();
            this.initializeGreeting();
            this.insertPathSelectionControl();
            this.initConfiguration();
            this.myConfig.cp_BusinessLetter.cp_Norm = n = this.getOfficeLinguistic();
            this.myConfig.cp_PrivateOfficialLetter.cp_Norm = n;
            this.myConfig.cp_PrivateLetter.cp_Norm = n;
            this.initializeTemplates(xMultiServiceFactory);
            if (this.myConfig.cp_BusinessLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_BusinessLetter.cp_Greeting = this.resources.GreetingLabels[0];
            }
            if (this.myConfig.cp_BusinessLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_BusinessLetter.cp_Salutation = this.resources.SalutationLabels[0];
            }
            if (this.myConfig.cp_PrivateOfficialLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_PrivateOfficialLetter.cp_Greeting = this.resources.GreetingLabels[1];
            }
            if (this.myConfig.cp_PrivateOfficialLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_PrivateOfficialLetter.cp_Salutation = this.resources.SalutationLabels[1];
            }
            if (this.myConfig.cp_PrivateLetter.cp_Greeting.equals("")) {
                this.myConfig.cp_PrivateLetter.cp_Greeting = this.resources.GreetingLabels[2];
            }
            if (this.myConfig.cp_PrivateLetter.cp_Salutation.equals("")) {
                this.myConfig.cp_PrivateLetter.cp_Salutation = this.resources.SalutationLabels[2];
            }
            this.updateUI();
            if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
                this.myPathSelection.initializePath();
            }
            XWindow xWindow = LetterWizardDialogImpl.myLetterDoc.xFrame.getContainerWindow();
            XWindowPeer xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xWindow);
            this.createWindowPeer(xWindowPeer);
            this.insertRoadmap();
            this.setConfiguration();
            this.setDefaultForGreetingAndSalutation();
            this.initializeElements();
            LetterWizardDialogImpl.myLetterDoc.xFrame.getComponentWindow().setEnable(false);
            this.executeDialog((XInterface)LetterWizardDialogImpl.myLetterDoc.xFrame);
            this.removeTerminateListener();
            this.closeDocument();
            running = false;
        }
        catch (com.sun.star.uno.Exception exception) {
            this.removeTerminateListener();
            exception.printStackTrace(System.out);
            running = false;
            return;
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
        running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishWizard() {
        this.switchToStep(this.getCurrentStep(), this.getMaxStep());
        try {
            int n;
            FileAccess fileAccess = new FileAccess(this.xMSF);
            this.sPath = this.myPathSelection.getSelectedPath();
            if (this.sPath.equals("")) {
                this.myPathSelection.triggerPathPicker();
                this.sPath = this.myPathSelection.getSelectedPath();
            }
            this.sPath = fileAccess.getURL(this.sPath);
            if (!this.filenameChanged && fileAccess.exists(this.sPath, true) && (n = SystemDialog.showMessageBox(this.xMSF, this.xControl.getPeer(), "MessBox", -2130706432, this.resources.resOverwriteWarning)) == 3) {
                boolean bl = false;
                return bl;
            }
            myLetterDoc.setWizardTemplateDocInfo(this.resources.resLetterWizardDialog_title, this.resources.resTemplateDescription);
            myLetterDoc.killEmptyUserFields();
            boolean bl = LetterWizardDialogImpl.myLetterDoc.keepLogoFrame = this.chkUseLogo.getState() != 0;
            if (this.chkBusinessPaper.getState() != 0 && this.chkPaperCompanyLogo.getState() != 0) {
                LetterWizardDialogImpl.myLetterDoc.keepLogoFrame = false;
            }
            LetterWizardDialogImpl.myLetterDoc.keepBendMarksFrame = this.chkUseBendMarks.getState() != 0;
            LetterWizardDialogImpl.myLetterDoc.keepLetterSignsFrame = this.chkUseSigns.getState() != 0;
            boolean bl2 = LetterWizardDialogImpl.myLetterDoc.keepSenderAddressRepeatedFrame = this.chkUseAddressReceiver.getState() != 0;
            if (this.optBusinessLetter.getState()) {
                if (this.chkBusinessPaper.getState() != 0 && this.chkCompanyReceiver.getState() != 0) {
                    LetterWizardDialogImpl.myLetterDoc.keepSenderAddressRepeatedFrame = false;
                }
                if (this.chkBusinessPaper.getState() != 0 && this.chkPaperCompanyAddress.getState() != 0) {
                    LetterWizardDialogImpl.myLetterDoc.keepAddressFrame = false;
                }
            }
            myLetterDoc.killEmptyFrames();
            this.bSaveSuccess = OfficeDocument.store(this.xMSF, (XComponent)this.xTextDocument, this.sPath, "writer8_template", false, "Template could not be saved to " + this.sPath);
            if (this.bSaveSuccess) {
                this.saveConfiguration();
                XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)this.xMSF.createInstance("com.sun.star.comp.uui.UUIInteractionHandler"));
                PropertyValue[] propertyValueArray = new PropertyValue[4];
                propertyValueArray[0] = new PropertyValue();
                propertyValueArray[0].Name = "AsTemplate";
                propertyValueArray[1] = new PropertyValue();
                propertyValueArray[1].Name = "MacroExecutionMode";
                propertyValueArray[1].Value = new Short(2);
                propertyValueArray[2] = new PropertyValue();
                propertyValueArray[2].Name = "UpdateDocMode";
                propertyValueArray[2].Value = new Short(3);
                propertyValueArray[3] = new PropertyValue();
                propertyValueArray[3].Name = "InteractionHandler";
                propertyValueArray[3].Value = xInteractionHandler;
                propertyValueArray[0].Value = this.bEditTemplate ? Boolean.FALSE : Boolean.TRUE;
                Object object = OfficeDocument.load((XInterface)Desktop.getDesktop(this.xMSF), this.sPath, "_default", propertyValueArray);
                XTextDocument xTextDocument = (XTextDocument)object;
                XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
                ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, xTextDocument);
                viewHandler.setViewSetting("ZoomType", new Short(0));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.xDialog.endExecute();
            running = false;
        }
        return true;
    }

    public void closeDocument() {
        try {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)LetterWizardDialogImpl.myLetterDoc.xFrame);
            xCloseable.close(false);
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }

    public void optBusinessLetterItemChanged() {
        DataAware.setDataObject(this.letterDA, this.myConfig.cp_BusinessLetter, true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.FALSE);
        this.lstBusinessStyleItemChanged();
        this.enableSenderReceiver();
        this.setPossibleFooter(true);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optPrivOfficialLetterItemChanged() {
        DataAware.setDataObject(this.letterDA, this.myConfig.cp_PrivateOfficialLetter, true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.FALSE);
        this.lstPrivOfficialStyleItemChanged();
        this.disableBusinessPaper();
        this.enableSenderReceiver();
        this.setPossibleFooter(true);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optPrivateLetterItemChanged() {
        DataAware.setDataObject(this.letterDA, this.myConfig.cp_PrivateLetter, true);
        this.setControlProperty("lblBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstBusinessStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("chkBusinessPaper", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lstPrivOfficialStyle", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPrivateStyle", "Enabled", Boolean.TRUE);
        this.setControlProperty("lstPrivateStyle", "Enabled", Boolean.TRUE);
        this.lstPrivateStyleItemChanged();
        this.disableBusinessPaper();
        this.disableSenderReceiver();
        this.setPossibleFooter(false);
        if (this.myPathSelection.xSaveTextBox.getText().equalsIgnoreCase("")) {
            this.myPathSelection.initializePath();
        }
    }

    public void optSenderPlaceholderItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.FALSE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.FALSE);
        myLetterDoc.fillSenderWithUserData();
    }

    public void optSenderDefineItemChanged() {
        this.setControlProperty("lblSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("lblPostCodeCity", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderName", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderStreet", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderPostCode", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderState", "Enabled", Boolean.TRUE);
        this.setControlProperty("txtSenderCity", "Enabled", Boolean.TRUE);
        this.txtSenderNameTextChanged();
        this.txtSenderStreetTextChanged();
        this.txtSenderPostCodeTextChanged();
        this.txtSenderStateTextChanged();
        this.txtSenderCityTextChanged();
    }

    public void optCreateLetterItemChanged() {
        this.bEditTemplate = false;
    }

    public void optMakeChangesItemChanged() {
        this.bEditTemplate = true;
    }

    public void optReceiverPlaceholderItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, "OnNew", "StarBasic", "macro:///Template.Correspondence.Placeholder()");
    }

    public void optReceiverDatabaseItemChanged() {
        OfficeDocument.attachEventCall((XComponent)this.xTextDocument, "OnNew", "StarBasic", "macro:///Template.Correspondence.Database()");
    }

    public void lstBusinessStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.BusinessFiles[1][this.lstBusinessStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.chkBusinessPaperItemChanged();
        this.setElements(false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void lstPrivOfficialStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.OfficialFiles[1][this.lstPrivOfficialStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.setPossibleSenderData(true);
        this.setElements(false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void lstPrivateStyleItemChanged() {
        this.xTextDocument = myLetterDoc.loadAsPreview(this.PrivateFiles[1][this.lstPrivateStyle.getSelectedItemPos()], false);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.lockControllers();
        this.initializeElements();
        this.setElements(true);
        LetterWizardDialogImpl.myLetterDoc.xTextDocument.unlockControllers();
        this.activate();
    }

    public void numLogoHeightTextChanged() {
        this.BusCompanyLogo.iHeight = (int)(this.numLogoHeight.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoWidthTextChanged() {
        this.BusCompanyLogo.iWidth = (int)(this.numLogoWidth.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoXTextChanged() {
        this.BusCompanyLogo.iXPos = (int)(this.numLogoX.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numLogoYTextChanged() {
        this.BusCompanyLogo.iYPos = (int)(this.numLogoY.getValue() * 1000.0);
        this.BusCompanyLogo.setFramePosition();
    }

    public void numAddressWidthTextChanged() {
        this.BusCompanyAddress.iWidth = (int)(this.numAddressWidth.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressXTextChanged() {
        this.BusCompanyAddress.iXPos = (int)(this.numAddressX.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressYTextChanged() {
        this.BusCompanyAddress.iYPos = (int)(this.numAddressY.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numAddressHeightTextChanged() {
        this.BusCompanyAddress.iHeight = (int)(this.numAddressHeight.getValue() * 1000.0);
        this.BusCompanyAddress.setFramePosition();
    }

    public void numFooterHeightTextChanged() {
        this.BusFooter.iHeight = (int)(this.numFooterHeight.getValue() * 1000.0);
        this.BusFooter.iYPos = LetterWizardDialogImpl.myLetterDoc.DocSize.Height - this.BusFooter.iHeight;
        this.BusFooter.setFramePosition();
    }

    public void chkPaperCompanyLogoItemChanged() {
        if (this.chkPaperCompanyLogo.getState() != 0) {
            if (this.numLogoWidth.getValue() == 0.0) {
                this.numLogoWidth.setValue(0.1);
            }
            if (this.numLogoHeight.getValue() == 0.0) {
                this.numLogoHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            letterDocument.getClass();
            this.BusCompanyLogo = letterDocument.new LetterDocument.BusinessPaperObject("Company Logo", (int)(this.numLogoWidth.getValue() * 1000.0), (int)(this.numLogoHeight.getValue() * 1000.0), (int)(this.numLogoX.getValue() * 1000.0), (int)(this.numLogoY.getValue() * 1000.0));
            this.setControlProperty("numLogoHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoX", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoX", "Enabled", Boolean.TRUE);
            this.setControlProperty("numLogoY", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyLogoY", "Enabled", Boolean.TRUE);
            this.setPossibleLogo(false);
        } else {
            if (this.BusCompanyLogo != null) {
                this.BusCompanyLogo.removeFrame();
            }
            this.setControlProperty("numLogoHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoX", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoX", "Enabled", Boolean.FALSE);
            this.setControlProperty("numLogoY", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyLogoY", "Enabled", Boolean.FALSE);
            this.setPossibleLogo(true);
        }
    }

    public void chkPaperCompanyAddressItemChanged() {
        if (this.chkPaperCompanyAddress.getState() != 0) {
            if (this.numAddressWidth.getValue() == 0.0) {
                this.numAddressWidth.setValue(0.1);
            }
            if (this.numAddressHeight.getValue() == 0.0) {
                this.numAddressHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            letterDocument.getClass();
            this.BusCompanyAddress = letterDocument.new LetterDocument.BusinessPaperObject("Company Address", (int)(this.numAddressWidth.getValue() * 1000.0), (int)(this.numAddressHeight.getValue() * 1000.0), (int)(this.numAddressX.getValue() * 1000.0), (int)(this.numAddressY.getValue() * 1000.0));
            this.setControlProperty("numAddressHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressWidth", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressX", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressX", "Enabled", Boolean.TRUE);
            this.setControlProperty("numAddressY", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblCompanyAddressY", "Enabled", Boolean.TRUE);
            if (myLetterDoc.hasElement("Sender Address")) {
                myLetterDoc.switchElement("Sender Address", false);
            }
            if (this.chkCompanyReceiver.getState() != 0) {
                this.setPossibleSenderData(false);
            }
        } else {
            if (this.BusCompanyAddress != null) {
                this.BusCompanyAddress.removeFrame();
            }
            this.setControlProperty("numAddressHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressWidth", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressX", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressX", "Enabled", Boolean.FALSE);
            this.setControlProperty("numAddressY", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblCompanyAddressY", "Enabled", Boolean.FALSE);
            if (myLetterDoc.hasElement("Sender Address")) {
                myLetterDoc.switchElement("Sender Address", true);
            }
            this.setPossibleSenderData(true);
            if (this.optSenderDefine.getState()) {
                this.optSenderDefineItemChanged();
            }
            if (this.optSenderPlaceholder.getState()) {
                this.optSenderPlaceholderItemChanged();
            }
        }
    }

    public void chkCompanyReceiverItemChanged() {
        XTextFrame xTextFrame = null;
        if (this.chkCompanyReceiver.getState() != 0) {
            try {
                xTextFrame = TextFrameHandler.getFrameByName("Receiver Address", this.xTextDocument);
                Integer n = (Integer)Helper.getUnoPropertyValue(xTextFrame, "Width");
                int n2 = n;
                Integer n3 = (Integer)Helper.getUnoPropertyValue(xTextFrame, "HoriOrientPosition");
                int n4 = n3;
                Integer n5 = (Integer)Helper.getUnoPropertyValue(xTextFrame, "VertOrientPosition");
                int n6 = n5;
                int n7 = 500;
                LetterDocument letterDocument = myLetterDoc;
                letterDocument.getClass();
                this.BusCompanyAddressReceiver = letterDocument.new LetterDocument.BusinessPaperObject(" ", n2, n7, n4, n6 - n7);
                this.setPossibleAddressReceiver(false);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
            if (this.chkPaperCompanyAddress.getState() != 0) {
                this.setPossibleSenderData(false);
            }
        } else {
            if (this.BusCompanyAddressReceiver != null) {
                this.BusCompanyAddressReceiver.removeFrame();
            }
            this.setPossibleAddressReceiver(true);
            this.setPossibleSenderData(true);
            if (this.optSenderDefine.getState()) {
                this.optSenderDefineItemChanged();
            }
            if (this.optSenderPlaceholder.getState()) {
                this.optSenderPlaceholderItemChanged();
            }
        }
    }

    public void chkPaperFooterItemChanged() {
        if (this.chkPaperFooter.getState() != 0) {
            if (this.numFooterHeight.getValue() == 0.0) {
                this.numFooterHeight.setValue(0.1);
            }
            LetterDocument letterDocument = myLetterDoc;
            letterDocument.getClass();
            this.BusFooter = letterDocument.new LetterDocument.BusinessPaperObject("Footer", LetterWizardDialogImpl.myLetterDoc.DocSize.Width, (int)(this.numFooterHeight.getValue() * 1000.0), 0, (int)((double)LetterWizardDialogImpl.myLetterDoc.DocSize.Height - this.numFooterHeight.getValue() * 1000.0));
            this.setControlProperty("numFooterHeight", "Enabled", Boolean.TRUE);
            this.setControlProperty("lblFooterHeight", "Enabled", Boolean.TRUE);
            this.setPossibleFooter(false);
        } else {
            if (this.BusFooter != null) {
                this.BusFooter.removeFrame();
            }
            this.setControlProperty("numFooterHeight", "Enabled", Boolean.FALSE);
            this.setControlProperty("lblFooterHeight", "Enabled", Boolean.FALSE);
            this.setPossibleFooter(true);
        }
    }

    public void chkUseLogoItemChanged() {
        try {
            if (myLetterDoc.hasElement("Company Logo")) {
                boolean bl = AnyConverter.toBoolean((Object)this.getControlProperty("chkUseLogo", "Enabled")) && this.chkUseLogo.getState() != 0;
                myLetterDoc.switchElement("Company Logo", bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void chkUseAddressReceiverItemChanged() {
        try {
            if (myLetterDoc.hasElement("Sender Address Repeated")) {
                boolean bl = AnyConverter.toBoolean((Object)this.getControlProperty("chkUseAddressReceiver", "Enabled")) && this.chkUseAddressReceiver.getState() != 0;
                myLetterDoc.switchElement("Sender Address Repeated", bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void chkUseSignsItemChanged() {
        if (myLetterDoc.hasElement("Letter Signs")) {
            myLetterDoc.switchElement("Letter Signs", this.chkUseSigns.getState() != 0);
        }
    }

    public void chkUseSubjectItemChanged() {
        if (myLetterDoc.hasElement("Subject Line")) {
            myLetterDoc.switchElement("Subject Line", this.chkUseSubject.getState() != 0);
        }
    }

    public void chkUseBendMarksItemChanged() {
        if (myLetterDoc.hasElement("Bend Marks")) {
            myLetterDoc.switchElement("Bend Marks", this.chkUseBendMarks.getState() != 0);
        }
    }

    public void chkUseFooterItemChanged() {
        try {
            boolean bl;
            boolean bl2 = bl = this.chkUseFooter.getState() != 0 && AnyConverter.toBoolean((Object)this.getControlProperty("chkUseFooter", "Enabled"));
            if (this.chkFooterNextPages.getState() != 0) {
                myLetterDoc.switchFooter("First Page", false, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myLetterDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            } else {
                myLetterDoc.switchFooter("First Page", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
                myLetterDoc.switchFooter("Standard", bl, this.chkFooterPageNumbers.getState() != 0, this.txtFooter.getText());
            }
            XInterface xInterface = this.getRoadmapItemByID(5);
            Helper.setUnoPropertyValue(xInterface, "Enabled", new Boolean(bl));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void chkFooterNextPagesItemChanged() {
        this.chkUseFooterItemChanged();
    }

    public void chkFooterPageNumbersItemChanged() {
        this.chkUseFooterItemChanged();
    }

    private void setPossibleFooter(boolean bl) {
        this.setControlProperty("chkUseFooter", "Enabled", new Boolean(bl));
        this.chkUseFooterItemChanged();
    }

    private void setPossibleAddressReceiver(boolean bl) {
        if (myLetterDoc.hasElement("Sender Address Repeated")) {
            this.setControlProperty("chkUseAddressReceiver", "Enabled", new Boolean(bl));
            this.chkUseAddressReceiverItemChanged();
        }
    }

    private void setPossibleLogo(boolean bl) {
        if (myLetterDoc.hasElement("Company Logo")) {
            this.setControlProperty("chkUseLogo", "Enabled", new Boolean(bl));
            this.chkUseLogoItemChanged();
        }
    }

    public void txtFooterTextChanged() {
        this.chkUseFooterItemChanged();
    }

    public void txtSenderNameTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Company", this.txtSenderName.getText());
    }

    public void txtSenderStreetTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("Street", this.txtSenderStreet.getText());
    }

    public void txtSenderCityTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("City", this.txtSenderCity.getText());
    }

    public void txtSenderPostCodeTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("PostCode", this.txtSenderPostCode.getText());
    }

    public void txtSenderStateTextChanged() {
        TextFieldHandler textFieldHandler = new TextFieldHandler(LetterWizardDialogImpl.myLetterDoc.xMSF, this.xTextDocument);
        textFieldHandler.changeUserFieldContent("State", this.txtSenderState.getText());
    }

    public void txtTemplateNameTextChanged() {
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        XDocumentProperties xDocumentProperties = xDocumentPropertiesSupplier.getDocumentProperties();
        String string = this.txtTemplateName.getText();
        xDocumentProperties.setTitle(string);
    }

    public void chkUseSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        myLetterDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
        this.setControlProperty("lstSalutation", "Enabled", new Boolean(this.chkUseSalutation.getState() != 0));
    }

    public void lstSalutationItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        myLetterDoc.switchUserField("Salutation", xTextComponent.getText(), this.chkUseSalutation.getState() != 0);
    }

    public void lstSalutationTextChanged() {
    }

    public void chkUseGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting);
        myLetterDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
        this.setControlProperty("lstGreeting", "Enabled", new Boolean(this.chkUseGreeting.getState() != 0));
    }

    private void setDefaultForGreetingAndSalutation() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstSalutation);
        if (xTextComponent.getText().equals("")) {
            xTextComponent.setText(this.resources.SalutationLabels[0]);
        }
        if ((xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting)).getText().equals("")) {
            xTextComponent.setText(this.resources.GreetingLabels[0]);
        }
    }

    public void lstGreetingItemChanged() {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.lstGreeting);
        myLetterDoc.switchUserField("Greeting", xTextComponent.getText(), this.chkUseGreeting.getState() != 0);
    }

    public void lstGreetingTextChanged() {
    }

    public void chkBusinessPaperItemChanged() {
        if (this.chkBusinessPaper.getState() != 0) {
            this.enableBusinessPaper();
        } else {
            this.disableBusinessPaper();
            this.setPossibleSenderData(true);
        }
    }

    private int getOfficeLinguistic() {
        int n;
        int n2 = 0;
        boolean bl = false;
        String string = Configuration.getOfficeLinguistic(this.xMSF);
        for (n = 0; n < this.Norms.length; ++n) {
            if (!this.Norms[n].equalsIgnoreCase(string)) continue;
            n2 = n;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < this.Norms.length; ++n) {
                if (!this.Norms[n].equalsIgnoreCase("en-US")) continue;
                n2 = n;
                bl = true;
                break;
            }
        }
        return n2;
    }

    private void setPossibleSenderData(boolean bl) {
        this.setControlProperty("optSenderDefine", "Enabled", new Boolean(bl));
        this.setControlProperty("optSenderPlaceholder", "Enabled", new Boolean(bl));
        this.setControlProperty("lblSenderAddress", "Enabled", new Boolean(bl));
        if (!bl) {
            this.setControlProperty("txtSenderCity", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderName", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderPostCode", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderStreet", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderCity", "Enabled", new Boolean(bl));
            this.setControlProperty("txtSenderState", "Enabled", new Boolean(bl));
            this.setControlProperty("lblSenderName", "Enabled", new Boolean(bl));
            this.setControlProperty("lblSenderStreet", "Enabled", new Boolean(bl));
            this.setControlProperty("lblPostCodeCity", "Enabled", new Boolean(bl));
        }
    }

    private void enableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(4);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.TRUE);
    }

    private void disableSenderReceiver() {
        XInterface xInterface = this.getRoadmapItemByID(4);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.FALSE);
    }

    private void enableBusinessPaper() {
        XInterface xInterface = this.getRoadmapItemByID(2);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.TRUE);
        this.chkPaperCompanyLogoItemChanged();
        this.chkPaperCompanyAddressItemChanged();
        this.chkPaperFooterItemChanged();
        this.chkCompanyReceiverItemChanged();
    }

    private void disableBusinessPaper() {
        XInterface xInterface = this.getRoadmapItemByID(2);
        Helper.setUnoPropertyValue(xInterface, "Enabled", Boolean.FALSE);
        if (this.BusCompanyLogo != null) {
            this.BusCompanyLogo.removeFrame();
        }
        if (this.BusCompanyAddress != null) {
            this.BusCompanyAddress.removeFrame();
        }
        if (this.BusFooter != null) {
            this.BusFooter.removeFrame();
        }
        if (this.BusCompanyAddressReceiver != null) {
            this.BusCompanyAddressReceiver.removeFrame();
        }
        this.setPossibleAddressReceiver(true);
        this.setPossibleFooter(true);
        this.setPossibleLogo(true);
        if (myLetterDoc.hasElement("Sender Address")) {
            myLetterDoc.switchElement("Sender Address", true);
        }
    }

    public void lstLetterNormItemChanged() {
        this.sCurrentNorm = this.Norms[this.getCurrentLetter().cp_Norm];
        this.initializeTemplates(this.xMSF);
        if (this.optBusinessLetter.getState()) {
            this.lstBusinessStyleItemChanged();
        }
        if (this.optPrivOfficialLetter.getState()) {
            this.lstPrivOfficialStyleItemChanged();
        }
        if (this.optPrivateLetter.getState()) {
            this.lstPrivateStyleItemChanged();
        }
    }

    public void initializeSalutation() {
        this.setControlProperty("lstSalutation", "StringItemList", this.resources.SalutationLabels);
    }

    public void initializeGreeting() {
        this.setControlProperty("lstGreeting", "StringItemList", this.resources.GreetingLabels);
    }

    public void initializeNorms() {
        int n;
        String string;
        Object object;
        Object object2;
        String[] stringArray;
        LocaleCodes localeCodes = new LocaleCodes(this.xmsf);
        String[] stringArray2 = localeCodes.getIDs();
        Object[] objectArray = new Object[]{"", ""};
        String[] stringArray3 = new String[]{"", ""};
        String[] stringArray4 = new String[]{"", ""};
        String[] stringArray5 = new String[]{"", ""};
        Vector<String> vector = new Vector<String>();
        String string2 = "/wizard/letter/";
        try {
            int n2;
            this.sTemplatePath = FileAccess.deleteLastSlashfromUrl(this.sTemplatePath);
            stringArray = this.sTemplatePath.split("/");
            object2 = "";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                object2 = (String)object2 + stringArray[i] + "/";
            }
            object = object2;
            object = FileAccess.deleteLastSlashfromUrl((String)object);
            this.sLetterPath = (String)object + string2;
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            string = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            stringArray3 = string.getFolderContents((String)object, true);
            stringArray5 = string.getFolderContents(this.sLetterPath, true);
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                String string3 = FileAccess.getFilename(stringArray3[n2]);
                if (string3.equalsIgnoreCase("wizard")) continue;
                String string4 = FileAccess.deleteLastSlashfromUrl(stringArray3[n2] + string2);
                try {
                    stringArray4 = string.getFolderContents(string4, true);
                    for (n = 0; n < stringArray4.length; ++n) {
                        String string5 = FileAccess.getFilename(stringArray4[n]);
                        vector.add(stringArray3[n2] + string2 + string5);
                    }
                    continue;
                }
                catch (com.sun.star.uno.Exception exception) {
                    // empty catch block
                }
            }
            for (n2 = 0; n2 < stringArray5.length; ++n2) {
                boolean bl = false;
                for (n = 0; n < stringArray3.length; ++n) {
                    if (!FileAccess.getFilename(stringArray5[n2]).equalsIgnoreCase(FileAccess.getFilename(stringArray3[n]))) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.add(stringArray5[n2]);
            }
            objectArray = vector.toArray();
        }
        catch (CommandAbortedException commandAbortedException) {
            commandAbortedException.printStackTrace();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
        stringArray = new Vector();
        object2 = new Vector();
        object = new Vector();
        boolean bl = false;
        string = "";
        String string6 = "";
        boolean bl2 = false;
        for (n = 0; n < objectArray.length; ++n) {
            String[] stringArray6;
            int n3;
            bl = false;
            string = FileAccess.getFilename((String)objectArray[n]);
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                stringArray6 = stringArray2[n3].split(";");
                if (!string.equalsIgnoreCase(stringArray6[1])) continue;
                string6 = stringArray6[2];
                bl = true;
                n3 = stringArray2.length;
            }
            if (!bl) {
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    stringArray6 = stringArray2[n3].split(";");
                    if (!string.equalsIgnoreCase(stringArray6[1].substring(0, 2))) continue;
                    string6 = stringArray6[2];
                    bl = true;
                    n3 = stringArray2.length;
                }
            }
            if (!bl) continue;
            stringArray.add(string);
            ((Vector)object2).add((String)objectArray[n]);
            ((Vector)object).add(localeCodes.getLanguageString(string6));
        }
        this.Norms = new String[stringArray.size()];
        stringArray.toArray(this.Norms);
        this.NormPaths = new String[((Vector)object2).size()];
        ((Vector)object2).toArray(this.NormPaths);
        String[] stringArray7 = new String[((Vector)object).size()];
        ((Vector)object).toArray(stringArray7);
        this.setControlProperty("lstLetterNorm", "StringItemList", stringArray7);
    }

    private CGLetter getCurrentLetter() {
        switch (this.myConfig.cp_LetterType) {
            case 0: {
                return this.myConfig.cp_BusinessLetter;
            }
            case 1: {
                return this.myConfig.cp_PrivateOfficialLetter;
            }
            case 2: {
                return this.myConfig.cp_PrivateLetter;
            }
        }
        return null;
    }

    private void initializePaths() {
        try {
            this.sTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "share", "/wizard");
            this.sUserTemplatePath = FileAccess.getOfficePath(this.xMSF, "Template", "user", "");
            this.sBitmapPath = FileAccess.combinePaths(this.xMSF, this.sTemplatePath, "/wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            noValidPathException.printStackTrace();
        }
    }

    public boolean initializeTemplates(XMultiServiceFactory xMultiServiceFactory) {
        this.sCurrentNorm = this.Norms[this.getCurrentLetter().cp_Norm];
        String string = this.NormPaths[this.getCurrentLetter().cp_Norm];
        this.BusinessFiles = FileAccess.getFolderTitles(xMultiServiceFactory, "bus", string);
        this.OfficialFiles = FileAccess.getFolderTitles(xMultiServiceFactory, "off", string);
        this.PrivateFiles = FileAccess.getFolderTitles(xMultiServiceFactory, "pri", string);
        this.setControlProperty("lstBusinessStyle", "StringItemList", this.BusinessFiles[0]);
        this.setControlProperty("lstPrivOfficialStyle", "StringItemList", this.OfficialFiles[0]);
        this.setControlProperty("lstPrivateStyle", "StringItemList", this.PrivateFiles[0]);
        this.setControlProperty("lstBusinessStyle", "SelectedItems", new short[]{0});
        this.setControlProperty("lstPrivOfficialStyle", "SelectedItems", new short[]{0});
        this.setControlProperty("lstPrivateStyle", "SelectedItems", new short[]{0});
        return true;
    }

    public void initializeElements() {
        this.setControlProperty("chkUseLogo", "Enabled", new Boolean(myLetterDoc.hasElement("Company Logo")));
        this.setControlProperty("chkUseBendMarks", "Enabled", new Boolean(myLetterDoc.hasElement("Bend Marks")));
        this.setControlProperty("chkUseAddressReceiver", "Enabled", new Boolean(myLetterDoc.hasElement("Sender Address Repeated")));
        this.setControlProperty("chkUseSubject", "Enabled", new Boolean(myLetterDoc.hasElement("Subject Line")));
        this.setControlProperty("chkUseSigns", "Enabled", new Boolean(myLetterDoc.hasElement("Letter Signs")));
        myLetterDoc.updateDateFields();
    }

    public void setConfiguration() {
        if (this.optBusinessLetter.getState()) {
            this.optBusinessLetterItemChanged();
        }
        if (this.optPrivOfficialLetter.getState()) {
            this.optPrivOfficialLetterItemChanged();
        }
        if (this.optPrivateLetter.getState()) {
            this.optPrivateLetterItemChanged();
        }
    }

    public void setElements(boolean bl) {
        if (this.optSenderDefine.getState()) {
            this.optSenderDefineItemChanged();
        }
        if (this.optSenderPlaceholder.getState()) {
            this.optSenderPlaceholderItemChanged();
        }
        this.chkUseSignsItemChanged();
        this.chkUseSubjectItemChanged();
        this.chkUseSalutationItemChanged();
        this.chkUseGreetingItemChanged();
        this.chkUseBendMarksItemChanged();
        this.chkUseAddressReceiverItemChanged();
        this.txtTemplateNameTextChanged();
        if (this.optReceiverDatabase.getState() && !bl) {
            this.optReceiverDatabaseItemChanged();
        }
        if (this.optReceiverPlaceholder.getState() && !bl) {
            this.optReceiverPlaceholderItemChanged();
        }
        if (this.optCreateLetter.getState()) {
            this.optCreateLetterItemChanged();
        }
        if (this.optMakeChanges.getState()) {
            this.optMakeChangesItemChanged();
        }
    }

    public void insertRoadmap() {
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.resources.RoadmapLabels[1], 1);
        n = this.insertRoadmapItem(n, false, this.resources.RoadmapLabels[2], 2);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[3], 3);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[4], 4);
        n = this.insertRoadmapItem(n, false, this.resources.RoadmapLabels[5], 5);
        n = this.insertRoadmapItem(n, true, this.resources.RoadmapLabels[6], 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    public void insertPathSelectionControl() {
        this.myPathSelection = new PathSelection(this.xMSF, this, 0, 1);
        this.myPathSelection.insert(6, 97, 70, 205, (short)45, this.resources.reslblTemplatePath_value, true, "HID:40815", "HID:40816");
        this.myPathSelection.sDefaultDirectory = this.sUserTemplatePath;
        this.myPathSelection.sDefaultName = "myLetterTemplate.ott";
        this.myPathSelection.sDefaultFilter = "writer8_template";
        this.myPathSelection.addSelectionListener(new myPathSelectionListener());
    }

    public void initConfiguration() {
        try {
            this.myConfig = new CGLetterWizard();
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Letter", false);
            this.myConfig.readConfiguration(object, "cp_");
            this.mainDA.add(RadioDataAware.attachRadioButtons(this.myConfig, "cp_LetterType", new Object[]{this.optBusinessLetter, this.optPrivOfficialLetter, this.optPrivateLetter}, null, true));
            this.mainDA.add(UnoDataAware.attachListBox(this.myConfig.cp_BusinessLetter, "cp_Style", this.lstBusinessStyle, null, true));
            this.mainDA.add(UnoDataAware.attachListBox(this.myConfig.cp_PrivateOfficialLetter, "cp_Style", this.lstPrivOfficialStyle, null, true));
            this.mainDA.add(UnoDataAware.attachListBox(this.myConfig.cp_PrivateLetter, "cp_Style", this.lstPrivateStyle, null, true));
            this.mainDA.add(UnoDataAware.attachCheckBox(this.myConfig.cp_BusinessLetter, "cp_BusinessPaper", this.chkBusinessPaper, null, true));
            CGLetter cGLetter = this.myConfig.cp_BusinessLetter;
            CGPaperElementLocation cGPaperElementLocation = this.myConfig.cp_BusinessLetter.cp_CompanyLogo;
            CGPaperElementLocation cGPaperElementLocation2 = this.myConfig.cp_BusinessLetter.cp_CompanyAddress;
            this.businessDA.add(UnoDataAware.attachCheckBox(cGPaperElementLocation, "cp_Display", this.chkPaperCompanyLogo, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation, "cp_Width", this.numLogoWidth, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation, "cp_Height", this.numLogoHeight, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation, "cp_X", this.numLogoX, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation, "cp_Y", this.numLogoY, null, true));
            this.businessDA.add(UnoDataAware.attachCheckBox(cGPaperElementLocation2, "cp_Display", this.chkPaperCompanyAddress, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation2, "cp_Width", this.numAddressWidth, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation2, "cp_Height", this.numAddressHeight, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation2, "cp_X", this.numAddressX, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGPaperElementLocation2, "cp_Y", this.numAddressY, null, true));
            this.businessDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PaperCompanyAddressReceiverField", this.chkCompanyReceiver, null, true));
            this.businessDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PaperFooter", this.chkPaperFooter, null, true));
            this.businessDA.add(UnoDataAware.attachNumericControl(cGLetter, "cp_PaperFooterHeight", this.numFooterHeight, null, true));
            this.letterDA.add(UnoDataAware.attachListBox(cGLetter, "cp_Norm", this.lstLetterNorm, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintCompanyLogo", this.chkUseLogo, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintCompanyAddressReceiverField", this.chkUseAddressReceiver, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintLetterSigns", this.chkUseSigns, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintSubjectLine", this.chkUseSubject, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintSalutation", this.chkUseSalutation, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintBendMarks", this.chkUseBendMarks, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintGreeting", this.chkUseGreeting, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_PrintFooter", this.chkUseFooter, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_Salutation", this.lstSalutation, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_Greeting", this.lstGreeting, null, true));
            this.letterDA.add(RadioDataAware.attachRadioButtons(cGLetter, "cp_SenderAddressType", new Object[]{this.optSenderDefine, this.optSenderPlaceholder}, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_SenderCompanyName", this.txtSenderName, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_SenderStreet", this.txtSenderStreet, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_SenderPostCode", this.txtSenderPostCode, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_SenderState", this.txtSenderState, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_SenderCity", this.txtSenderCity, null, true));
            this.letterDA.add(RadioDataAware.attachRadioButtons(cGLetter, "cp_ReceiverAddressType", new Object[]{this.optReceiverDatabase, this.optReceiverPlaceholder}, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_Footer", this.txtFooter, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_FooterOnlySecondPage", this.chkFooterNextPages, null, true));
            this.letterDA.add(UnoDataAware.attachCheckBox(cGLetter, "cp_FooterPageNumbers", this.chkFooterPageNumbers, null, true));
            this.letterDA.add(RadioDataAware.attachRadioButtons(cGLetter, "cp_CreationType", new Object[]{this.optCreateLetter, this.optMakeChanges}, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_TemplateName", this.txtTemplateName, null, true));
            this.letterDA.add(UnoDataAware.attachEditControl(cGLetter, "cp_TemplatePath", this.myPathSelection.xSaveTextBox, null, true));
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateUI() {
        UnoDataAware.updateUI(this.mainDA);
        UnoDataAware.updateUI(this.letterDA);
        UnoDataAware.updateUI(this.businessDA);
    }

    public void saveConfiguration() {
        try {
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.Office.Writer/Wizards/Letter", true);
            this.myConfig.writeConfiguration(object, "cp_");
            Configuration.commit(object);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    private class myPathSelectionListener
    implements XPathSelectionListener {
        private myPathSelectionListener() {
        }

        public void validatePath() {
            if (LetterWizardDialogImpl.this.myPathSelection.usedPathPicker) {
                LetterWizardDialogImpl.this.filenameChanged = true;
            }
            LetterWizardDialogImpl.this.myPathSelection.usedPathPicker = false;
        }
    }
}

