/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FileHandler
extends Handler {
    private String date = "";
    private String directory = null;
    private String prefix = null;
    private String suffix = null;
    private PrintWriter writer = null;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String directory, String prefix, String suffix) {
        this.directory = directory;
        this.prefix = prefix;
        this.suffix = suffix;
        this.configure();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        String tsDate = tsString.substring(0, 10);
        if (!this.date.equals(tsDate)) {
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                if (!this.date.equals(tsDate)) {
                    this.close();
                    this.date = tsDate;
                    this.open();
                }
            }
        }
        String result = null;
        try {
            result = this.getFormatter().format(record);
        }
        catch (Exception e) {
            this.reportError(null, e, 5);
            return;
        }
        try {
            this.writer.write(result);
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 1);
            return;
        }
    }

    public void close() {
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = "";
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
    }

    private void configure() {
        String formatterName;
        String encoding;
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        this.date = tsString.substring(0, 10);
        String className = FileHandler.class.getName();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (this.directory == null) {
            this.directory = this.getProperty(className + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(className + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(className + ".suffix", ".log");
        }
        if ((encoding = this.getProperty(className + ".encoding", null)) != null && encoding.length() > 0) {
            try {
                this.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(className + ".level", "" + Level.ALL)));
        String filterName = this.getProperty(className + ".filter", null);
        if (filterName != null) {
            try {
                this.setFilter((Filter)cl.loadClass(filterName).newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((formatterName = this.getProperty(className + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)cl.loadClass(formatterName).newInstance());
            }
            catch (Exception e) {}
        } else {
            this.setFormatter(new SimpleFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    private void open() {
        File dir = new File(this.directory);
        dir.mkdirs();
        try {
            String pathname = dir.getAbsolutePath() + File.separator + this.prefix + this.date + this.suffix;
            String encoding = this.getEncoding();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pathname, true));
            this.writer = new PrintWriter((Writer)(encoding != null ? new OutputStreamWriter((OutputStream)os, encoding) : new OutputStreamWriter(os)), true);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
        }
    }
}

