/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import msfgui.MsfguiApp;
import msfgui.OptionsDialog;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class MulticommandOptionsDialog
extends OptionsDialog {
    private JButton chooseButton;
    private JButton commandFileButton;
    private JTextField commandFileField;
    private JTextArea commandsArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JTextField outputFileField;

    public MulticommandOptionsDialog(Frame parent) {
        super(parent, "Upload Exec Options", true);
        this.initComponents();
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.chooseButton = new JButton();
        this.outputFileField = new JTextField();
        this.commandFileField = new JTextField();
        this.commandFileButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.commandsArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MulticommandOptionsDialog.this.closeDialog(evt);
            }
        });
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(MulticommandOptionsDialog.class);
        this.okButton.setText(resourceMap.getString("okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MulticommandOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.chooseButton.setText(resourceMap.getString("chooseButton.text", new Object[0]));
        this.chooseButton.setName("chooseButton");
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MulticommandOptionsDialog.this.chooseButtonActionPerformed(evt);
            }
        });
        this.outputFileField.setText(resourceMap.getString("outputFileField.text", new Object[0]));
        this.outputFileField.setName("outputFileField");
        this.commandFileField.setText(resourceMap.getString("commandFileField.text", new Object[0]));
        this.commandFileField.setName("commandFileField");
        this.commandFileButton.setText(resourceMap.getString("commandFileButton.text", new Object[0]));
        this.commandFileButton.setName("commandFileButton");
        this.commandFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MulticommandOptionsDialog.this.commandFileButtonActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.commandsArea.setColumns(20);
        this.commandsArea.setRows(5);
        this.commandsArea.setName("commandsArea");
        this.jScrollPane1.setViewportView(this.commandsArea);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.chooseButton).addComponent(this.commandFileButton).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 396, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addComponent(this.commandFileField, GroupLayout.Alignment.LEADING, -1, 396, Short.MAX_VALUE).addComponent(this.outputFileField, GroupLayout.Alignment.LEADING, -1, 396, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFileField, -2, -1, -2).addComponent(this.chooseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commandFileField, -2, -1, -2).addComponent(this.commandFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        StringBuilder cmd = new StringBuilder("multicommand ");
        if (this.outputFileField.getText().length() > 0) {
            cmd.append(" -f \"").append(MsfguiApp.doubleBackslashes(this.outputFileField.getText())).append("\"");
        }
        String commandList = this.commandsArea.getText();
        if (this.commandFileField.getText().length() > 0) {
            cmd.append(" -rc \"").append(MsfguiApp.doubleBackslashes(this.commandFileField.getText())).append("\"");
        } else if (commandList.length() > 0) {
            String[] cmds = commandList.split("\n");
            cmd.append(" -cl ");
            for (int i = 0; i < cmds.length; ++i) {
                cmd.append("\"").append(MsfguiApp.doubleBackslashes(cmds[i].trim())).append("\"");
                if (i >= cmds.length - 1) continue;
                cmd.append(',');
            }
        }
        this.command = cmd.toString();
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        if (MsfguiApp.fileChooser.showOpenDialog(this) == 0) {
            this.outputFileField.setText(MsfguiApp.fileChooser.getSelectedFile().getPath());
        }
    }

    private void commandFileButtonActionPerformed(ActionEvent evt) {
        if (MsfguiApp.fileChooser.showOpenDialog(this) == 0) {
            this.commandFileField.setText(MsfguiApp.fileChooser.getSelectedFile().getPath());
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

