/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetThread
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
        ObjectReference tRef = this.m_debugger.getStore().get(uniqueID);
        if (tRef == null) {
            throw new JDEException("No such thread exists");
        }
        if (!(tRef instanceof ThreadReference)) {
            throw new JDEException("No such thread exists (anymore?)");
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, Rep.getThreadRep((ThreadReference)tRef, true), true, false);
    }

    public Object clone() {
        return new GetThread();
    }
}

