# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from node import Node

class Drawable(Node):

    def absolute_x__set(self, x):
        position = self.get_position()
        self.set_position(x, position[1], position[2])

    def absolute_x__get(self):
        return self.get_position()[0]

    absolute_x = property(absolute_x__get, absolute_x__set)

    def absolute_y__set(self, y):
        position = self.get_position()
        self.set_position(position[0], y, position[2])

    def absolute_y__get(self):
        return self.get_position()[1]

    absolute_y = property(absolute_y__get, absolute_y__set)

    def absolute_z__set(self, z):
        position = self.get_position()
        self.set_position(position[0], position[1], z)

    def absolute_z__get(self):
        return self.get_position()[2]

    absolute_z = property(absolute_z__get, absolute_z__set)

    def absolute_position__set(self, position):
        self.set_position(position[0], position[1], position[2])

    def absolute_position__get(self):
        return self.get_position()

    absolute_position = property(absolute_position__get, absolute_position__set)

    def absolute_width__set(self, width):
        height = self.get_size()[1]
        self.set_size(width, height)

    def absolute_width__get(self):
        return self.get_size()[0]

    absolute_width = property(absolute_width__get, absolute_width__set)

    def absolute_height__set(self, height):
        width = self.get_size()[0]
        self.set_size(width, height)

    def absolute_height__get(self):
        return self.get_size()[1]

    absolute_height = property(absolute_height__get, absolute_height__set)

    def absolute_size__set(self, size):
        self.set_size(size[0], size[1])

    def absolute_size__get(self):
        return self.get_size()

    absolute_size = property(absolute_size__get, absolute_size__set)

    def absolute_visible__set(self, visible):
        if visible:
            self.show()
        else:
            self.hide()

    def absolute_visible__get(self):
        return self.is_visible()

    absolute_visible = property(absolute_visible__get, absolute_visible__set)

    def absolute_opacity__set(self, opacity):
        self.set_opacity(opacity)

    def absolute_opacity__get(self):
        return self.get_opacity()

    absolute_opacity = property(absolute_opacity__get, absolute_opacity__set)
