<?php
/**
 * Piwik - Open source web analytics
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 * @version $Id: Languages.php 3139 2010-09-12 19:58:18Z vipsoft $
 *
 * @category Piwik
 * @package DataFiles
 */

/*
 * Language database
 */
if(!isset($GLOBALS['Piwik_LanguageList']))
{
	// Reference: ISO 639-1 alpha-2
	$GLOBALS['Piwik_LanguageList'] = array(
		'aa' => 'Afar',
		'ab' => 'Abkhazian',
		'ae' => 'Avestan',
		'af' => 'Afrikaans',
		'ak' => 'Akan',
		'am' => 'Amharic',
		'an' => 'Aragonese',
		'ar' => 'Arabic',
		'as' => 'Assamese',
		'av' => 'Avaric',
		'ay' => 'Aymara',
		'az' => 'Azerbaijani',
		'ba' => 'Bashkir',
		'be' => 'Belarusian',
		'bg' => 'Bulgarian',
		'bh' => 'Bihari', // 'Bihari languages',
		'bi' => 'Bislama',
		'bm' => 'Bambara',
		'bn' => 'Bengali',
		'bo' => 'Tibetan',
		'br' => 'Breton',
		'bs' => 'Bosnian',
		'ca' => array('Catalan', 'Valencian'),
		'ce' => 'Chechen',
		'ch' => 'Chamorro',
		'co' => 'Corsican',
		'cr' => 'Cree',
		'cs' => 'Czech',
		'cu' => array('Church Slavic', 'Old Slavonic', 'Church Slavonic', 'Old Bulgarian', 'Old Church Slavonic'),
		'cv' => 'Chuvash',
		'cy' => 'Welsh',
		'da' => 'Danish',
		'de' => 'German',
		'dv' => array('Divehi', 'Dhivehi', 'Maldivian'),
		'dz' => 'Dzongkha',
		'ee' => 'Ewe',
		'el' => array('Greek', 'Modern Greek'), // Greek, Modern (1453-)
		'en' => 'English',
		'eo' => 'Esperanto',
		'es' => array('Spanish', 'Castilian'),
		'et' => 'Estonian',
		'eu' => 'Basque',
		'fa' => 'Persian',
		'ff' => 'Fulah',
		'fi' => 'Finnish',
		'fj' => 'Fijian',
		'fo' => 'Faroese',
		'fr' => 'French',
		'fy' => 'Western Frisian',
		'ga' => 'Irish',
		'gd' => array('Gaelic', 'Scottish Gaelic'),
		'gl' => 'Galician',
		'gn' => 'Guarani',
		'gu' => 'Gujarati',
		'gv' => 'Manx',
		'ha' => 'Hausa',
		'he' => 'Hebrew',
		'hi' => 'Hindi',
		'ho' => 'Hiri Motu',
		'hr' => 'Croatian',
		'ht' => array('Haitian', 'Haitian Creole'),
		'hu' => 'Hungarian',
		'hy' => 'Armenian',
		'hz' => 'Herero',
		'ia' => 'Interlingua', // 'Interlingua (International Auxiliary Language Association)',
		'id' => 'Indonesian',
		'ie' => array('Interlingue', 'Occidental'),
		'ig' => 'Igbo',
		'ii' => array('Sichuan Yi', 'Nuosu'),
		'ik' => 'Inupiaq',
		'io' => 'Ido',
		'is' => 'Icelandic',
		'it' => 'Italian',
		'iu' => 'Inuktitut',
		'ja' => 'Japanese',
		'jv' => 'Javanese',
		'ka' => 'Georgian',
		'kg' => 'Kongo',
		'ki' => array('Kikuyu', 'Gikuyu'),
		'kj' => array('Kuanyama', 'Kwanyama'),
		'kk' => 'Kazakh',
		'kl' => array('Kalaallisut', 'Greenlandic'),
		'km' => 'Central Khmer',
		'kn' => 'Kannada',
		'ko' => 'Korean',
		'kr' => 'Kanuri',
		'ks' => 'Kashmiri',
		'ku' => 'Kurdish',
		'kv' => 'Komi',
		'kw' => 'Cornish',
		'ky' => array('Kirghiz', 'Kyrgyz'),
		'la' => 'Latin',
		'lb' => array('Luxembourgish', 'Letzeburgesch'),
		'lg' => 'Ganda',
		'li' => array('Limburgan', 'Limburger', 'Limburgish'),
		'ln' => 'Lingala',
		'lo' => 'Lao',
		'lt' => 'Lithuanian',
		'lu' => 'Luba-Katanga',
		'lv' => 'Latvian',
		'mg' => 'Malagasy',
		'mh' => 'Marshallese',
		'mi' => 'Maori',
		'mk' => 'Macedonian',
		'ml' => 'Malayalam',
		'mn' => 'Mongolian',
//		'mo' => 'Moldavian', // deprecated
		'mr' => 'Marathi',
		'ms' => 'Malay',
		'mt' => 'Maltese',
		'my' => 'Burmese',
		'na' => 'Nauru',
		'nb' => 'Norwegian Bokmål',
		'nd' => 'North Ndebele',
		'ne' => 'Nepali',
		'ng' => 'Ndonga',
		'nl' => array('Dutch', 'Flemish'),
		'nn' => 'Norwegian Nynorsk',
		'no' => 'Norwegian',
		'nr' => 'South Ndebele',
		'nv' => array('Navajo', 'Navaho'),
		'ny' => array('Chichewa', 'Chewa', 'Nyanja'),
		'oc' => array('Occitan', 'Provençal'), // Occitan (post 1500)
		'oj' => 'Ojibwa',
		'om' => 'Oromo',
		'or' => 'Oriya',
		'os' => array('Ossetian', 'Ossetic'),
		'pa' => array('Panjabi', 'Punjabi'),
		'pi' => 'Pali',
		'pl' => 'Polish',
		'ps' => array('Pushto', 'Pashto'),
		'pt' => 'Portuguese',
		'qu' => 'Quechua',
		'rm' => 'Romansh',
		'rn' => 'Rundi',
		'ro' => array('Romanian', 'Moldavian', 'Moldovan'),
		'ru' => 'Russian',
		'rw' => 'Kinyarwanda',
		'sa' => 'Sanskrit',
		'sc' => 'Sardinian',
		'sd' => 'Sindhi',
		'se' => 'Northern Sami',
		'sg' => 'Sango',
//		'sh' => 'Serbo-Croatian', // deprecated
		'si' => array('Sinhala', 'Sinhalese'),
		'sk' => 'Slovak',
		'sl' => 'Slovenian',
		'sm' => 'Samoan',
		'sn' => 'Shona',
		'so' => 'Somali',
		'sq' => 'Albanian',
		'sr' => 'Serbian',
		'ss' => 'Swati',
		'st' => 'Southern Soth',
		'su' => 'Sundanese',
		'sv' => 'Swedish',
		'sw' => 'Swahili',
		'ta' => 'Tamil',
		'te' => 'Telugu',
		'tg' => 'Tajik',
		'th' => 'Thai',
		'ti' => 'Tigrinya',
		'tk' => 'Turkmen',
		'tl' => 'Tagalog',
		'tn' => 'Tswana',
		'to' => 'Tonga', // Tonga (Tonga Islands)
		'tr' => 'Turkish',
		'ts' => 'Tsonga',
		'tt' => 'Tatar',
		'tw' => 'Twi',
		'ty' => 'Tahitian',
		'ug' => array('Uighur', 'Uyghur'),
		'uk' => 'Ukrainian',
		'ur' => 'Urdu',
		'uz' => 'Uzbek',
		've' => 'Venda',
		'vi' => 'Vietnamese',
		'vo' => 'Volapük',
		'wa' => 'Walloon',
		'wo' => 'Wolof',
		'xh' => 'Xhosa',
		'yi' => 'Yiddish',
		'yo' => 'Yoruba',
		'za' => array('Zhuang', 'Chuang'),
		'zh' => 'Chinese',
		'zu' => 'Zulu',
	);
}
