/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.net;

import com.darwinsys.net.StreamServer;
import com.darwinsys.net.StreamServerHandler;
import com.darwinsys.net.StreamServerHandlerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class StreamServerDemo {
    private static void doConversation(Socket sock) throws IOException {
        String line;
        System.out.println("StreamServerDemo.doConversation(): accepted connection");
        BufferedReader is = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        while ((line = is.readLine()) != null) {
            System.out.println(line);
        }
        PrintWriter out = new PrintWriter(sock.getOutputStream());
        out.println("OK");
        sock.close();
    }

    public static void main(String[] args) throws Throwable {
        StreamServer server = new StreamServer(4567, new MyStreamHandlerFactory());
        System.out.printf("Server listening in %d%n", server.getPort());
        server.runServer();
    }

    static class MyStreamHandlerFactory
    implements StreamServerHandlerFactory,
    StreamServerHandler {
        MyStreamHandlerFactory() {
        }

        public StreamServerHandler getHandler(ServerSocket serverSock, Socket clientSocket) {
            return this;
        }

        public void handle(Socket sock) throws IOException {
            StreamServerDemo.doConversation(sock);
        }
    }
}

