/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SQLServerDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.18 $";
    private static final Logger logger = Logger.getLogger(SQLServerDDLGenerator.class);
    private static HashSet reservedWords = new HashSet();

    public boolean isReservedWord(String word) {
        return reservedWords.contains(word.toUpperCase());
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower SQLServer 2000 DDL Generator $Revision: 1.18 $ --");
    }

    public void writeDDLTransactionBegin() {
    }

    public void writeDDLTransactionEnd() {
        this.println("GO");
    }

    public String getStatementTerminator() {
        return "";
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, false, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 2000L, "0x", null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, false, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("IMAGE", 2004, Integer.MAX_VALUE, "0x", null, 1, true, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 8000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("TEXT", 2005, Integer.MAX_VALUE, "'", "'", 1, true, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATETIME", 91, 23L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("REAL", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INT", 4, 10L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("IMAGE", -4, Integer.MAX_VALUE, "0x", null, 1, true, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("TEXT", -1, Integer.MAX_VALUE, "'", "'", 1, true, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("DATETIME", 92, 23L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("DATETIME", 93, 23L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 3L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 8000L, null, null, 1, true, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 8000L, "'", "'", 1, true, false));
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap();
        this.profileFunctionMap.put("bit", new ProfileFunctionDescriptor("bit", -7, true, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("tinyint", new ProfileFunctionDescriptor("INTEGER", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("tinyint identity", new ProfileFunctionDescriptor("INTEGER", -6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("bigint", new ProfileFunctionDescriptor("INTEGER", -5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("bigint identity", new ProfileFunctionDescriptor("INTEGER", -5, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("numeric", new ProfileFunctionDescriptor("numeric", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("numeric()", new ProfileFunctionDescriptor("numeric", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("decimal", new ProfileFunctionDescriptor("decimal", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("decimal()", new ProfileFunctionDescriptor("decimal", 2, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int identity", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("smallint", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("smallint identity", new ProfileFunctionDescriptor("INTEGER", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("real", new ProfileFunctionDescriptor("real", 7, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("money", new ProfileFunctionDescriptor("money", 2, true, true, true, true, false, false, false, true));
        this.profileFunctionMap.put("smallmoney", new ProfileFunctionDescriptor("smallmoney", 7, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("text", new ProfileFunctionDescriptor("text", 2005, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("ntext", new ProfileFunctionDescriptor("ntext", 2005, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("image", new ProfileFunctionDescriptor("image", 2004, false, false, false, false, false, false, false, false));
        this.profileFunctionMap.put("datetime", new ProfileFunctionDescriptor("datetime", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("smalldatetime", new ProfileFunctionDescriptor("smalldatetime", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("varbinary", new ProfileFunctionDescriptor("varbinary", -3, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("binary", new ProfileFunctionDescriptor("binary", -2, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("char", new ProfileFunctionDescriptor("char", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("nchar", new ProfileFunctionDescriptor("nchar", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("varchar", new ProfileFunctionDescriptor("varchar", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("nvarchar", new ProfileFunctionDescriptor("nvarchar", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("sysname", new ProfileFunctionDescriptor("sysname", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timestamp", new ProfileFunctionDescriptor("timestamp", 2006, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("uniqueidentifier", new ProfileFunctionDescriptor("uniqueidentifier", 2006, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("sql_variant", new ProfileFunctionDescriptor("sql_variant", 2006, true, true, true, false, true, true, true, true));
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public String getSchemaTerm() {
        return "Owner";
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        logger.debug((Object)("getting physical name for: " + logicalName));
        String ident = logicalName.replace(' ', '_');
        logger.debug((Object)("after replace of spaces: " + ident));
        ident = ident.replaceAll("[^a-zA-Z0-9_@$#]", "_");
        if (physicalName == null) {
            if (ident.length() < 129) {
                return ident;
            }
            logger.debug((Object)("truncating identifier: " + ident));
            String base = ident.substring(0, 125);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            logger.debug((Object)("new identifier: " + base + tiebreaker));
            return base + tiebreaker;
        }
        logger.debug((Object)("physical identifier is not unique, regenerating: " + physicalName));
        String base = ident;
        if (ident.length() > 125) {
            base = ident.substring(0, 125);
        }
        int tiebreaker = ((ident + physicalName).hashCode() % 1000 + 1000) % 1000;
        logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        return base + tiebreaker;
    }

    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    public String getStringLengthSQLFunctionName(String expression) {
        return "LEN(" + expression + ")";
    }

    public String getAverageSQLFunctionName(String expression) {
        return "AVG(CONVERT(DECIMAL," + expression + "))";
    }

    public void addIndex(SQLIndex index) throws ArchitectException {
        if (index.getType() == SQLIndex.IndexType.STATISTIC) {
            return;
        }
        this.checkDupIndexname(index);
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(DDLUtils.toQualifiedName(null, null, index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParentTable()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren()) {
            if (!first) {
                this.print(", ");
            }
            this.print(c.getName());
            first = false;
        }
        this.print(" )\n");
        this.endStatement(DDLStatement.StatementType.CREATE, index);
    }

    static {
        reservedWords.add("ADD");
        reservedWords.add("ALL");
        reservedWords.add("ALTER");
        reservedWords.add("AND");
        reservedWords.add("ANY");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("AUTHORIZATION");
        reservedWords.add("BACKUP");
        reservedWords.add("BEGIN");
        reservedWords.add("BETWEEN");
        reservedWords.add("BREAK");
        reservedWords.add("BROWSE");
        reservedWords.add("BULK");
        reservedWords.add("BY");
        reservedWords.add("CASCADE");
        reservedWords.add("CASE");
        reservedWords.add("CHECK");
        reservedWords.add("CHECKPOINT");
        reservedWords.add("CLOSE");
        reservedWords.add("CLUSTERED");
        reservedWords.add("COALESCE");
        reservedWords.add("COLLATE");
        reservedWords.add("COLUMN");
        reservedWords.add("COMMIT");
        reservedWords.add("COMPUTE");
        reservedWords.add("CONSTRAINT");
        reservedWords.add("CONTAINS");
        reservedWords.add("CONTAINSTABLE");
        reservedWords.add("CONTINUE");
        reservedWords.add("CONVERT");
        reservedWords.add("CREATE");
        reservedWords.add("CROSS");
        reservedWords.add("CURRENT");
        reservedWords.add("CURRENT_DATE");
        reservedWords.add("CURRENT_TIME");
        reservedWords.add("CURRENT_TIMESTAMP");
        reservedWords.add("CURRENT_USER");
        reservedWords.add("CURSOR");
        reservedWords.add("DATABASE");
        reservedWords.add("DBCC");
        reservedWords.add("DEALLOCATE");
        reservedWords.add("DECLARE");
        reservedWords.add("DEFAULT");
        reservedWords.add("DELETE");
        reservedWords.add("DENY");
        reservedWords.add("DESC");
        reservedWords.add("DISK");
        reservedWords.add("DISTINCT");
        reservedWords.add("DISTRIBUTED");
        reservedWords.add("DOUBLE");
        reservedWords.add("DROP");
        reservedWords.add("DUMMY");
        reservedWords.add("DUMP");
        reservedWords.add("ELSE");
        reservedWords.add("END");
        reservedWords.add("ERRLVL");
        reservedWords.add("ESCAPE");
        reservedWords.add("EXCEPT");
        reservedWords.add("EXEC");
        reservedWords.add("EXECUTE");
        reservedWords.add("EXISTS");
        reservedWords.add("EXIT");
        reservedWords.add("FETCH");
        reservedWords.add("FILE");
        reservedWords.add("FILLFACTOR");
        reservedWords.add("FOR");
        reservedWords.add("FOREIGN");
        reservedWords.add("FREETEXT");
        reservedWords.add("FREETEXTTABLE");
        reservedWords.add("FROM");
        reservedWords.add("FULL");
        reservedWords.add("FUNCTION");
        reservedWords.add("GOTO");
        reservedWords.add("GRANT");
        reservedWords.add("GROUP");
        reservedWords.add("HAVING");
        reservedWords.add("HOLDLOCK");
        reservedWords.add("IDENTITY");
        reservedWords.add("IDENTITY_INSERT");
        reservedWords.add("IDENTITYCOL");
        reservedWords.add("IF");
        reservedWords.add("IN");
        reservedWords.add("INDEX");
        reservedWords.add("INNER");
        reservedWords.add("INSERT");
        reservedWords.add("INTERSECT");
        reservedWords.add("INTO");
        reservedWords.add("IS");
        reservedWords.add("JOIN");
        reservedWords.add("KEY");
        reservedWords.add("KILL");
        reservedWords.add("LEFT");
        reservedWords.add("LIKE");
        reservedWords.add("LINENO");
        reservedWords.add("LOAD");
        reservedWords.add("NATIONAL");
        reservedWords.add("NOCHECK");
        reservedWords.add("NONCLUSTERED");
        reservedWords.add("NOT");
        reservedWords.add("NULL");
        reservedWords.add("NULLIF");
        reservedWords.add("OF");
        reservedWords.add("OFF");
        reservedWords.add("OFFSETS");
        reservedWords.add("ON");
        reservedWords.add("OPEN");
        reservedWords.add("OPENDATASOURCE");
        reservedWords.add("OPENQUERY");
        reservedWords.add("OPENROWSET");
        reservedWords.add("OPENXML");
        reservedWords.add("OPTION");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("OUTER");
        reservedWords.add("OVER");
        reservedWords.add("PERCENT");
        reservedWords.add("PLAN");
        reservedWords.add("PRECISION");
        reservedWords.add("PRIMARY");
        reservedWords.add("PRINT");
        reservedWords.add("PROC");
        reservedWords.add("PROCEDURE");
        reservedWords.add("PUBLIC");
        reservedWords.add("RAISERROR");
        reservedWords.add("READ");
        reservedWords.add("READTEXT");
        reservedWords.add("RECONFIGURE");
        reservedWords.add("REFERENCES");
        reservedWords.add("REPLICATION");
        reservedWords.add("RESTORE");
        reservedWords.add("RESTRICT");
        reservedWords.add("RETURN");
        reservedWords.add("REVOKE");
        reservedWords.add("RIGHT");
        reservedWords.add("ROLLBACK");
        reservedWords.add("ROWCOUNT");
        reservedWords.add("ROWGUIDCOL");
        reservedWords.add("RULE");
        reservedWords.add("SAVE");
        reservedWords.add("SCHEMA");
        reservedWords.add("SELECT");
        reservedWords.add("SESSION_USER");
        reservedWords.add("SET");
        reservedWords.add("SETUSER");
        reservedWords.add("SHUTDOWN");
        reservedWords.add("SOME");
        reservedWords.add("STATISTICS");
        reservedWords.add("SYSTEM_USER");
        reservedWords.add("TABLE");
        reservedWords.add("TEXTSIZE");
        reservedWords.add("THEN");
        reservedWords.add("TO");
        reservedWords.add("TOP");
        reservedWords.add("TRAN");
        reservedWords.add("TRANSACTION");
        reservedWords.add("TRIGGER");
        reservedWords.add("TRUNCATE");
        reservedWords.add("TSEQUAL");
        reservedWords.add("UNION");
        reservedWords.add("UNIQUE");
        reservedWords.add("UPDATE");
        reservedWords.add("UPDATETEXT");
        reservedWords.add("USE");
        reservedWords.add("USER");
        reservedWords.add("VALUES");
        reservedWords.add("VARYING");
        reservedWords.add("VIEW");
        reservedWords.add("WAITFOR");
        reservedWords.add("WHEN");
        reservedWords.add("WHERE");
        reservedWords.add("WHILE");
        reservedWords.add("WITH");
        reservedWords.add("WRITETEXT");
    }
}

