/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.Lister;
import ca.sqlpower.architect.swingui.ListerProgressBarUpdater;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.architect.swingui.WizardPanel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickStartPanel1
implements WizardPanel {
    private static final Logger logger = Logger.getLogger(WizardPanel.class);
    private QuickStartWizard wizard;
    private DBTree dbTree;
    private JProgressBar progressBar;
    private JLabel label;
    private JPanel panel;

    public QuickStartPanel1(QuickStartWizard wizard) {
        this.wizard = wizard;
    }

    @Override
    public JComponent getPanel() {
        List databases = QuickStartWizard.getDatabases();
        try {
            this.dbTree = new DBTree(databases);
        }
        catch (ArchitectException e) {
            logger.error((Object)"problem loading database list", (Throwable)e);
        }
        this.progressBar = ((WizardDialog)this.wizard.getParentDialog()).getProgressBar();
        this.label = ((WizardDialog)this.wizard.getParentDialog()).getProgressLabel();
        this.label.setText("Loading Database.....");
        this.dbTree.addTreeSelectionListener(new MyTreeSelectionListener(this.progressBar));
        this.dbTree.addTreeWillExpandListener(new MyTreeSelectionListener(this.progressBar));
        JScrollPane scrollPane = new JScrollPane(this.dbTree);
        FormLayout layout = new FormLayout("3dlu, 30dlu, 5dlu, fill:200dlu:grow, 3dlu", "10dlu, pref, 4dlu, fill:150dlu:grow, 4dlu, 20dlu");
        PanelBuilder pb = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel("Choose source database and tables"), cc.xyw(2, 2, 2, "l,c"));
        pb.add((Component)scrollPane, cc.xyw(2, 4, 4));
        pb.add((Component)this.label, cc.xy(2, 6));
        pb.add((Component)this.progressBar, cc.xy(4, 6));
        this.panel = new JPanel();
        this.panel.add(pb.getPanel());
        return this.panel;
    }

    @Override
    public boolean applyChanges() {
        TreePath[] paths = this.dbTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            JOptionPane.showMessageDialog(this.getPanel(), "You must select at least one table or view.", "Error", 0);
            return false;
        }
        ArrayList<SQLTable> list = new ArrayList<SQLTable>();
        for (TreePath tp : Arrays.asList(paths)) {
            Object lastObj = tp.getLastPathComponent();
            if (lastObj instanceof SQLTable) {
                logger.debug((Object)("adding table: " + ((SQLTable)lastObj).getName()));
                list.add((SQLTable)lastObj);
                continue;
            }
            if (this.getTables((SQLObject)lastObj, list)) continue;
            return false;
        }
        this.wizard.setSourceTables(list);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getTables(SQLObject sqlObj, List<SQLTable> list) {
        if (sqlObj instanceof SQLSchema) {
            logger.debug((Object)("adding schema: " + ((SQLSchema)sqlObj).getName()));
            try {
                list.addAll(((SQLSchema)sqlObj).getChildren());
                return true;
            }
            catch (ArchitectException e) {
                JOptionPane.showMessageDialog(this.getPanel(), "Schema " + ((SQLSchema)sqlObj).getName() + " reading error:" + e.getMessage(), "Error", 0);
                return false;
            }
        } else if (sqlObj instanceof SQLCatalog) {
            logger.debug((Object)("adding catalog: " + ((SQLCatalog)sqlObj).getName()));
            try {
                ((SQLCatalog)sqlObj).populate();
                if (((SQLCatalog)sqlObj).getChildType() == null) return true;
                if (((SQLCatalog)sqlObj).getChildType() == SQLTable.class) {
                    list.addAll(((SQLCatalog)sqlObj).getChildren());
                    return true;
                }
                if (((SQLCatalog)sqlObj).getChildType() == SQLSchema.class) {
                    for (SQLSchema schema : ((SQLCatalog)sqlObj).getChildren()) {
                        if (this.getTables(schema, list)) continue;
                        return false;
                    }
                    return true;
                }
                JOptionPane.showMessageDialog(this.getPanel(), "Catalog " + ((SQLCatalog)sqlObj).getName() + " contains unknown child type: " + ((SQLCatalog)sqlObj).getChildType(), "Error", 0);
                return false;
            }
            catch (ArchitectException e) {
                JOptionPane.showMessageDialog(this.getPanel(), "Catalog " + ((SQLCatalog)sqlObj).getName() + " reading error:" + e.getMessage(), "Error", 0);
                return false;
            }
        } else if (sqlObj instanceof SQLDatabase) {
            logger.debug((Object)("adding database: " + ((SQLDatabase)sqlObj).getName()));
            try {
                ((SQLDatabase)sqlObj).populate();
                if (((SQLDatabase)sqlObj).getChildType() == null) return true;
                if (((SQLDatabase)sqlObj).getChildType() == SQLTable.class) {
                    list.addAll(((SQLDatabase)sqlObj).getChildren());
                    return true;
                }
                if (((SQLDatabase)sqlObj).getChildType() == SQLSchema.class) {
                    for (SQLSchema schema : ((SQLDatabase)sqlObj).getChildren()) {
                        if (this.getTables(schema, list)) continue;
                        return false;
                    }
                    return true;
                }
                if (((SQLDatabase)sqlObj).getChildType() == SQLCatalog.class) {
                    for (SQLCatalog cat : ((SQLDatabase)sqlObj).getChildren()) {
                        if (this.getTables(cat, list)) continue;
                        return false;
                    }
                    return true;
                }
                JOptionPane.showMessageDialog(this.getPanel(), "Database " + ((SQLDatabase)sqlObj).getName() + " contains unknown child type: " + ((SQLDatabase)sqlObj).getChildType(), "Error", 0);
                return false;
            }
            catch (ArchitectException e1) {
                JOptionPane.showMessageDialog(this.getPanel(), "Catalog " + ((SQLCatalog)sqlObj).getName() + " reading error:" + e1.getMessage(), "Error", 0);
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this.getPanel(), "Unknown selected Object type: " + sqlObj.getName() + " (" + sqlObj.getClass() + ")", "Error", 0);
            return false;
        }
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public String getTitle() {
        return "Architect Quick Start - Step 1 of 5 - Select Source Tables";
    }

    public class MyTreeSelectionListener
    extends ArchitectSwingWorker
    implements TreeSelectionListener,
    TreeWillExpandListener,
    Lister {
        private JProgressBar progressBar;
        protected SQLDatabase.PopulateProgressMonitor progressMonitor;
        private ArrayList<SQLDatabase> databaseList;
        private ArrayList<SQLDatabase.PopulateProgressMonitor> progressMonitorList;

        public MyTreeSelectionListener(JProgressBar progressBar) {
            this.progressBar = progressBar;
            this.databaseList = new ArrayList();
            this.progressMonitorList = new ArrayList();
        }

        public void cleanup() throws Exception {
            if (this.progressBar != null) {
                this.progressBar.setVisible(false);
            }
        }

        public void doStuff() throws Exception {
            try {
                ListerProgressBarUpdater progressBarUpdater = new ListerProgressBarUpdater(this.progressBar, this);
                ArrayList<JComponent> l = new ArrayList<JComponent>();
                l.add(((WizardDialog)QuickStartPanel1.this.wizard.getParentDialog()).getNextButton());
                progressBarUpdater.setDisableEnableList(l);
                ArrayList<JComponent> l2 = new ArrayList<JComponent>();
                l2.add(QuickStartPanel1.this.label);
                progressBarUpdater.setVisableInvisableList(l2);
                new Timer(100, progressBarUpdater).start();
                for (SQLDatabase database : this.databaseList) {
                    database.populate();
                }
            }
            catch (ArchitectException e) {
                logger.debug((Object)"Unexpected architect exception in ConnectionListener", (Throwable)e);
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = QuickStartPanel1.this.dbTree.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            for (TreePath tp : Arrays.asList(paths)) {
                SQLObject lastObj = (SQLObject)tp.getLastPathComponent();
                if (!(lastObj instanceof SQLDatabase)) continue;
                this.databaseList.add((SQLDatabase)lastObj);
                try {
                    this.progressMonitorList.add(((SQLDatabase)lastObj).getProgressMonitor());
                }
                catch (ArchitectException e1) {
                    logger.debug((Object)"Error getting progressMonitor", (Throwable)e1);
                }
            }
            new Thread(this).start();
        }

        public Integer getJobSize() throws ArchitectException {
            int size = 0;
            for (SQLDatabase.PopulateProgressMonitor progress : this.progressMonitorList) {
                if (progress == null || progress.getJobSize() == null) continue;
                size += progress.getJobSize().intValue();
            }
            if (size > 0) {
                return new Integer(size);
            }
            return null;
        }

        public int getProgress() throws ArchitectException {
            int size = 0;
            for (SQLDatabase.PopulateProgressMonitor progress : this.progressMonitorList) {
                if (progress == null) continue;
                size += progress.getProgress();
            }
            return size;
        }

        public boolean isFinished() throws ArchitectException {
            for (SQLDatabase.PopulateProgressMonitor progress : this.progressMonitorList) {
                if (progress == null || progress.isFinished()) continue;
                return false;
            }
            return true;
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            SQLObject lastObj = (SQLObject)path.getLastPathComponent();
            if (lastObj instanceof SQLDatabase) {
                this.databaseList.add((SQLDatabase)lastObj);
                try {
                    this.progressMonitorList.add(((SQLDatabase)lastObj).getProgressMonitor());
                }
                catch (ArchitectException e1) {
                    logger.debug((Object)"Error getting progressMonitor", (Throwable)e1);
                }
            }
            new Thread(this).start();
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }
}

