/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ConnectionComboBoxModel;
import ca.sqlpower.architect.swingui.DataSourceRenderer;
import ca.sqlpower.architect.swingui.QuickStartWizard;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.architect.swingui.WizardPanel;
import ca.sqlpower.architect.swingui.event.CatalogComboBoxListener;
import ca.sqlpower.architect.swingui.event.DatabaseComboBoxListener;
import ca.sqlpower.architect.swingui.event.NewDatabaseListener;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class QuickStartPanel2
implements WizardPanel {
    private static final Logger logger = Logger.getLogger(QuickStartPanel2.class);
    private QuickStartWizard wizard;
    private JPanel panel;
    private JComboBox targetConnectionsBox;
    private JComboBox targetCatalog;
    private JComboBox targetSchema;
    private JProgressBar progressBar;
    private SQLDatabase database;
    private SQLCatalog catalog;
    private SQLSchema schema;
    DatabaseComboBoxListener dcl;
    private JLabel label;
    private ListCellRenderer dataSourceRenderer = new DataSourceRenderer();

    public QuickStartPanel2(QuickStartWizard wizard) {
        this.wizard = wizard;
        wizard.setPlExport(new PLExport());
        this.targetConnectionsBox = new JComboBox();
        this.targetConnectionsBox.setModel(new ConnectionComboBoxModel());
        this.targetConnectionsBox.setRenderer(this.dataSourceRenderer);
        this.targetCatalog = new JComboBox();
        this.targetSchema = new JComboBox();
        this.progressBar = ((WizardDialog)wizard.getParentDialog()).getProgressBar();
        this.label = ((WizardDialog)wizard.getParentDialog()).getProgressLabel();
        this.label.setText("Loading Database.....");
        this.targetCatalog.setEnabled(false);
        this.targetSchema.setEnabled(false);
        this.dcl = new DatabaseComboBoxListener((JPanel)this.getPanel(), this.targetConnectionsBox, this.targetCatalog, this.targetSchema, this.progressBar);
        ArrayList<JComponent> l1 = new ArrayList<JComponent>();
        l1.add(this.label);
        this.dcl.setVisableInvisableList(l1);
        ArrayList<JComponent> l2 = new ArrayList<JComponent>();
        l2.add(((WizardDialog)wizard.getParentDialog()).getNextButton());
        l2.add(((WizardDialog)wizard.getParentDialog()).getBackButton());
        this.dcl.setDisableEnableList(l2);
        this.targetConnectionsBox.addActionListener(this.dcl);
        JButton newTargetButton = new JButton(" New ");
        newTargetButton.addActionListener(new NewDatabaseListener(ArchitectFrame.getMainInstance(), "New Target Database", this.targetConnectionsBox));
        this.targetCatalog.addActionListener(new CatalogComboBoxListener((JPanel)this.getPanel(), this.targetConnectionsBox, this.targetCatalog, this.targetSchema));
        FormLayout layout = new FormLayout("10dlu, 80dlu,10dlu, 5dlu,fill:100dlu:grow, 10dlu, 40dlu,30dlu", "30dlu, 20dlu, 4dlu, 20dlu, 4dlu, 20dlu, 30dlu, 20dlu");
        PanelBuilder pb = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel("Target Connection"), cc.xy(2, 2, "r,c"));
        pb.add((Component)this.targetConnectionsBox, cc.xyw(4, 2, 2));
        pb.add((Component)newTargetButton, cc.xy(7, 2));
        pb.add((Component)new JLabel("Target Catalog"), cc.xy(2, 4, "r,c"));
        pb.add((Component)this.targetCatalog, cc.xyw(4, 4, 2));
        pb.add((Component)new JLabel("Target Schema"), cc.xy(2, 6, "r,c"));
        pb.add((Component)this.targetSchema, cc.xyw(4, 6, 2));
        this.panel = new JPanel();
        this.panel.add(pb.getPanel());
    }

    public JComponent getPanel() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyChanges() {
        logger.debug((Object)"Applying target database changes to the PLExport object");
        PLExport plexp = this.wizard.getPlExport();
        plexp.setTargetDataSource((ArchitectDataSource)this.targetConnectionsBox.getSelectedItem());
        this.database = this.dcl.getDatabase();
        Connection con = null;
        try {
            con = this.database.getConnection();
            if (con == null) {
                JOptionPane.showMessageDialog(this.getPanel(), "Couldn't connect to target database.", "Database Error", 0);
                boolean bl = false;
                return bl;
            }
        }
        catch (ArchitectException e) {
            JOptionPane.showMessageDialog(this.getPanel(), e.getMessage(), "Database Error", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Couldn't close connection", (Throwable)e);
            }
        }
        this.catalog = (SQLCatalog)this.targetCatalog.getSelectedItem();
        this.schema = (SQLSchema)this.targetSchema.getSelectedItem();
        if (this.database == null || this.targetConnectionsBox.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this.getPanel(), "No Database is selected, cannot continue.", "Database Error", 0);
            return false;
        }
        try {
            if (this.database.isCatalogContainer() && this.catalog == null) {
                return false;
            }
            if (this.database.isSchemaContainer() && this.schema == null) {
                return false;
            }
            if (this.catalog != null && this.catalog.isSchemaContainer() && this.schema == null) {
                return false;
            }
        }
        catch (ArchitectException e) {
            JOptionPane.showMessageDialog(this.getPanel(), "Database populate Erorr", "Error", 0);
            return false;
        }
        plexp.setTargetDataSource(this.database.getDataSource());
        plexp.setTargetCatalog(this.catalog);
        plexp.setTargetSchema(this.schema);
        this.wizard.addTargetDatabase(this.database.getDataSource());
        return true;
    }

    public void discardChanges() {
    }

    public String getTitle() {
        return "Architect Quick Start - Step 2 of 5 - Select Target";
    }
}

