/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public abstract class AbstractTableTargetedAction
extends AbstractAction
implements SelectionListener {
    protected PlayPen pp;
    protected DBTree dbt;

    public AbstractTableTargetedAction() {
    }

    public AbstractTableTargetedAction(String name, Icon icon) {
        super(name, icon);
    }

    public AbstractTableTargetedAction(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            if (evt.getActionCommand().equals("PlayPen")) {
                List<PlayPenComponent> selection = this.pp.getSelectedItems();
                if (selection.size() < 1) {
                    JOptionPane.showMessageDialog(this.pp, "Select a table (by clicking on it) and try again.");
                } else if (selection.size() > 1) {
                    JOptionPane.showMessageDialog(this.pp, "You have selected multiple items, but you can only edit one at a time.");
                } else if (selection.get(0) instanceof TablePane) {
                    TablePane tp = (TablePane)selection.get(0);
                    this.processTablePane(tp);
                } else {
                    JOptionPane.showMessageDialog(this.pp, "The selected item type is not recognised");
                }
            } else if (evt.getActionCommand().equals("DBTree")) {
                TreePath[] selections = this.dbt.getSelectionPaths();
                if (selections == null || selections.length != 1) {
                    JOptionPane.showMessageDialog(this.dbt, "To indicate where you would like to insert a column, please select a single item.");
                } else {
                    TreePath tp = selections[0];
                    SQLObject so = (SQLObject)tp.getLastPathComponent();
                    this.processSQLObject(so);
                }
            } else {
                JOptionPane.showMessageDialog(null, "InsertColumnAction: Unknown Action Command \"" + evt.getActionCommand() + "\"", "Internal Architect Error", 0);
            }
        }
        catch (ArchitectException ex) {
            ASUtils.showExceptionDialog("Column could not be inserted:\n" + ex.getMessage(), ex);
        }
    }

    abstract void processTablePane(TablePane var1) throws ArchitectException;

    abstract void processSQLObject(SQLObject var1) throws ArchitectException;

    public void setPlayPen(PlayPen pp) {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
        }
        this.pp = pp;
        pp.addSelectionListener(this);
        this.setupAction(pp.getSelectedItems());
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }

    public void setupAction(List selectedItems) {
        if (selectedItems.size() == 0) {
            this.disableAction();
        } else {
            Selectable item = (Selectable)selectedItems.get(0);
            if (item instanceof TablePane) {
                this.setEnabled(true);
            }
        }
    }

    public abstract void disableAction();

    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }

    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }
}

