/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.swingui.table.TableTextConverter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelSearchDecorator
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(TableModelSearchDecorator.class);
    private TableTextConverter tableTextConverter;
    protected TableModel tableModel;
    private List<Integer> rowMapping = null;
    protected Document doc;
    private String searchText = null;
    private DocumentListener docListener = new DocumentListener(){

        private String getSearchText(DocumentEvent e) {
            String searchText = null;
            try {
                searchText = e.getDocument().getText(0, e.getDocument().getLength());
            }
            catch (BadLocationException e1) {
                ASUtils.showExceptionDialog("Internal Error (search profile)!", e1);
            }
            return searchText;
        }

        public void insertUpdate(DocumentEvent e) {
            TableModelSearchDecorator.this.search(this.getSearchText(e));
        }

        public void removeUpdate(DocumentEvent e) {
            TableModelSearchDecorator.this.search(this.getSearchText(e));
        }

        public void changedUpdate(DocumentEvent e) {
            TableModelSearchDecorator.this.search(this.getSearchText(e));
        }
    };

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    public TableModelSearchDecorator(TableModel model) {
        this.tableModel = model;
        this.setDoc(new DefaultStyledDocument());
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                TableModelSearchDecorator.this.search(TableModelSearchDecorator.this.searchText);
            }
        });
    }

    private void search(String searchText) {
        this.rowMapping = null;
        this.fireTableDataChanged();
        ArrayList<Integer> newRowMap = new ArrayList<Integer>();
        String[] searchWords = searchText == null ? null : searchText.split(" ");
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            boolean match = false;
            if (searchWords == null) {
                match = true;
            } else {
                int i;
                for (i = 0; i < searchWords.length; ++i) {
                    match = false;
                    for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
                        String value = this.tableTextConverter.getTextForCell(row, column);
                        if (value.toLowerCase().indexOf(searchWords[i].toLowerCase()) < 0) continue;
                        match = true;
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Match: " + value.toLowerCase() + " contains " + searchWords[i] + "     " + value.toLowerCase().indexOf(searchWords[i].toLowerCase())));
                        break;
                    }
                    if (!match) break;
                }
                if (i < searchWords.length) {
                    match = false;
                }
            }
            if (!match) continue;
            newRowMap.add(this.tableTextConverter.modelIndex(row));
        }
        this.setSearchText(searchText);
        this.rowMapping = newRowMap;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("new row mapping after search: " + this.rowMapping));
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.rowMapping == null) {
            return this.tableModel.getRowCount();
        }
        return this.rowMapping.size();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(this.rowToModel(rowIndex), columnIndex);
    }

    private int rowToModel(int rowIndex) {
        int modelRow = this.rowMapping == null ? rowIndex : this.rowMapping.get(rowIndex);
        return modelRow;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.fireTableStructureChanged();
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        if (this.doc != null) {
            doc.removeDocumentListener(this.docListener);
        }
        this.doc = doc;
        if (doc != null) {
            doc.addDocumentListener(this.docListener);
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public TableTextConverter getTableTextConverter() {
        return this.tableTextConverter;
    }

    public void setTableTextConverter(TableTextConverter tableTextConverter) {
        this.tableTextConverter = tableTextConverter;
    }
}

