/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;

public class AnyMethodReturnValueStreamFactory
implements StreamFactory {
    private ObjectType baseClassType;
    private String bugType;

    public AnyMethodReturnValueStreamFactory(String streamBase) {
        this.baseClassType = ObjectTypeFactory.getInstance((String)streamBase);
        this.bugType = null;
    }

    public AnyMethodReturnValueStreamFactory setBugType(String bugType) {
        this.bugType = bugType;
        return this;
    }

    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        Instruction ins = location.getHandle().getInstruction();
        try {
            if (ins instanceof InvokeInstruction) {
                if (!Hierarchy.isSubtype((ReferenceType)type, (ReferenceType)this.baseClassType)) {
                    return null;
                }
                Stream stream = new Stream(location, type.getClassName(), this.baseClassType.getClassName()).setIsOpenOnCreation(true).setIgnoreImplicitExceptions(true);
                if (this.bugType != null) {
                    stream.setInteresting(this.bugType);
                }
                return stream;
            }
        }
        catch (ClassNotFoundException e) {
            lookupFailureCallback.reportMissingClass(e);
        }
        return null;
    }
}

