/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.model;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.rubypeople.rdt.internal.debug.core.RubyDebuggerProxy;
import org.rubypeople.rdt.internal.debug.core.SuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;

public class RubyThread
extends PlatformObject
implements IThread {
    private RubyStackFrame[] frames;
    private IDebugTarget target;
    private boolean isSuspended = false;
    private boolean isTerminated = false;
    private boolean isStepping = false;
    private String name;
    private int id;

    public RubyThread(IDebugTarget iDebugTarget, int n) {
        this.target = iDebugTarget;
        this.setId(n);
        this.createName();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.frames == null) {
            return new RubyStackFrame[0];
        }
        return this.frames;
    }

    public int getStackFramesSize() {
        return this.frames.length;
    }

    public boolean hasStackFrames() {
        if (this.frames == null) {
            return false;
        }
        return this.frames.length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.frames == null || this.frames.length == 0) {
            return null;
        }
        return this.frames[0];
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[]{DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.rubypeople.rdt.debug")[0]};
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public boolean canResume() {
        return this.isSuspended;
    }

    public boolean canSuspend() {
        return !this.isSuspended;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    protected void setSuspended(boolean bl) {
        this.isSuspended = bl;
    }

    protected void prepareForResume() {
        this.isSuspended = false;
        this.createName();
        this.frames = null;
        DebugEvent debugEvent = new DebugEvent((Object)this, 1, 32);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public void resume() throws DebugException {
        this.prepareForResume();
        ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy().resume(this);
    }

    public void doSuspend(SuspensionPoint suspensionPoint) {
        this.getRubyDebuggerProxy().readFrames(this);
        this.createName(suspensionPoint);
        this.suspend();
    }

    public void suspend() {
        this.isStepping = false;
        this.isSuspended = true;
        DebugEvent debugEvent = new DebugEvent((Object)this, 2, 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    public boolean canStepInto() {
        return this.isSuspended && this.hasStackFrames();
    }

    public boolean canStepOver() {
        return this.isSuspended && this.hasStackFrames();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        this.createName();
        this.frames = null;
        this.frames[0].stepInto();
    }

    public void stepOver() throws DebugException {
        this.isStepping = true;
        this.createName();
        this.frames = null;
        this.frames[0].stepOver();
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
        this.isTerminated = true;
        this.frames = null;
    }

    public RubyDebuggerProxy getRubyDebuggerProxy() {
        return ((RubyDebugTarget)this.getDebugTarget()).getRubyDebuggerProxy();
    }

    public void setStackFrames(RubyStackFrame[] rubyStackFrameArray) {
        this.frames = rubyStackFrameArray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void createName() {
        this.createName(null);
    }

    protected void createName(SuspensionPoint suspensionPoint) {
        this.name = "Ruby Thread - " + this.getId();
        if (suspensionPoint != null) {
            this.name = String.valueOf(this.name) + " (" + suspensionPoint + ")";
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }
}

