/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.SourceRefElementInfo;

public abstract class SourceRefElement
extends RubyElement
implements ISourceReference {
    public int occurrenceCount = 1;

    public SourceRefElement(RubyElement rubyElement) {
        super(rubyElement);
    }

    public IOpenable getOpenableParent() {
        IRubyElement iRubyElement = this.getParent();
        while (iRubyElement != null) {
            if (iRubyElement instanceof IOpenable) {
                return (IOpenable)((Object)iRubyElement);
            }
            iRubyElement = iRubyElement.getParent();
        }
        return null;
    }

    public IResource getCorrespondingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    public boolean isStructureKnown() throws RubyModelException {
        return true;
    }

    public String getSource() throws RubyModelException {
        IOpenable iOpenable = this.getOpenableParent();
        IBuffer iBuffer = iOpenable.getBuffer();
        if (iBuffer == null) {
            return null;
        }
        ISourceRange iSourceRange = this.getSourceRange();
        int n = iSourceRange.getOffset();
        int n2 = iSourceRange.getLength();
        if (n == -1 || n2 == 0) {
            return null;
        }
        try {
            return iBuffer.getText(n, n2);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() throws RubyModelException {
        SourceRefElementInfo sourceRefElementInfo = (SourceRefElementInfo)this.getElementInfo();
        return sourceRefElementInfo.getSourceRange();
    }

    public IPath getPath() {
        return this.getParent().getPath();
    }

    public IResource getResource() {
        return this.getParent().getResource();
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    protected void closing(Object object) throws RubyModelException {
    }

    protected void generateInfos(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws RubyModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable == null) {
            return;
        }
        RubyElementInfo rubyElementInfo = (RubyElementInfo)RubyModelManager.getRubyModelManager().getInfo(openable);
        if (rubyElementInfo == null) {
            openable.generateInfos(openable.createElementInfo(), hashMap, iProgressMonitor);
        }
    }

    protected Object createElementInfo() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceRefElement)) {
            return false;
        }
        return this.occurrenceCount == ((SourceRefElement)object).occurrenceCount && super.equals(object);
    }
}

