/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListManager;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.RefreshAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiBusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class RefreshUDDIBusinessAction
extends RefreshAction {
    public RefreshUDDIBusinessAction(Controller controller) {
        super(controller);
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "uddiLinks", "viewId", 3);
        return transformers;
    }

    public boolean run() {
        return this.executeSingleLinkAction();
    }

    protected boolean executeMultipleLinkAction() {
        return this.executeSingleLinkAction();
    }

    public boolean executeSingleLinkAction() {
        boolean result = true;
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        TreeElement selectedElement = selectedNode.getTreeElement();
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        MessageQueue messageQueue = wsilPerspective.getMessageQueue();
        if (selectedElement instanceof WsilElement) {
            WsilElement wsilElement = (WsilElement)selectedElement;
            ListManager lm = wsilElement.getAllUDDILinks();
            Vector<WsilUddiBusinessElement> uddiBusinessElements = new Vector<WsilUddiBusinessElement>();
            String[] viewIDs = this.getViewIds();
            int i = 0;
            while (i < viewIDs.length) {
                int viewID = Integer.parseInt(viewIDs[i]);
                WsilUddiBusinessElement uddiBusinessElement = (WsilUddiBusinessElement)((Object)lm.getElementWithViewId(viewID).getObject());
                uddiBusinessElements.add(uddiBusinessElement);
                ++i;
            }
            wsilElement.refreshServiceProvidersFromRegistry(uddiBusinessElements);
            Iterator it = uddiBusinessElements.iterator();
            while (it.hasNext()) {
                WsilUddiBusinessElement uddiBusinessElement = (WsilUddiBusinessElement)((Object)it.next());
                String name = uddiBusinessElement.getName();
                if (name == null || name.length() <= 0) {
                    name = uddiBusinessElement.getUDDILinkBusinessKey();
                }
                if (uddiBusinessElement.getServiceProvider() != null) {
                    messageQueue.addMessage(wsilPerspective.getMessage("MSG_INFO_REFRESH_SUCCESSFUL", name));
                    continue;
                }
                messageQueue.addMessage(wsilPerspective.getMessage("MSG_ERROR_BUSINESS_NOT_FOUND", name));
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }
}

