/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;

public class EditOutputFolderOperation
extends ClasspathModifierOperation {
    private boolean fShowOutputFolders = false;

    public EditOutputFolderOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip, 7);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        CPListElementAttribute result = null;
        this.fException = null;
        try {
            CPListElement selElement;
            Object selection = this.getSelectedElements().get(0);
            IJavaProject project = this.fInformationProvider.getJavaProject();
            if (selection instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)selection;
                IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(javaElement.getPath(), project, 3);
                selElement = CPListElement.createFromExisting(entry, project);
            } else {
                selElement = ((CPListElementAttribute)selection).getParent();
            }
            ClasspathModifierQueries.IOutputLocationQuery query = this.fInformationProvider.getOutputLocationQuery();
            result = this.editOutputFolder(selElement, project, query, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        ArrayList<CPListElementAttribute> resultList = new ArrayList<CPListElementAttribute>();
        if (result != null) {
            resultList.add(result);
        }
        super.handleResult(resultList, monitor);
    }

    public void showOutputFolders(boolean show) {
        this.fShowOutputFolders = show;
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() != 1 || !this.fShowOutputFolders) {
            return false;
        }
        IJavaProject project = this.fInformationProvider.getJavaProject();
        Object element = elements.get(0);
        if (element instanceof IJavaProject) {
            if (!EditOutputFolderOperation.isSourceFolder(project)) {
                return false;
            }
        } else if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 1;
        }
        return element instanceof CPListElementAttribute;
    }

    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_EditOutputFolder;
    }
}

