/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class JavaSearchEditorOpener {
    private ReusedEditorWatcher fReusedEditorWatcher;

    public IEditorPart openElement(Object element) throws PartInitException, JavaModelException {
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(element, wbPage);
        }
        return this.showWithoutReuse(element, wbPage);
    }

    public IEditorPart openMatch(Match match) throws PartInitException, JavaModelException {
        Object element = this.getElementToOpen(match);
        return this.openElement(element);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element, IWorkbenchPage wbPage) throws PartInitException, JavaModelException {
        return EditorUtility.openInEditor(element, false);
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws JavaModelException, PartInitException {
        IFile file = this.getFile(element);
        if (file != null) {
            String editorID = this.getEditorID(file);
            return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file), editorID);
        }
        IClassFile cf = this.getClassFile(element);
        if (cf != null) {
            return this.showInEditor(wbPage, new InternalClassFileEditorInput(cf), "org.eclipse.jdt.ui.ClassFileEditor");
        }
        return null;
    }

    private IFile getFile(Object element) throws JavaModelException {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IJavaElement) {
            IJavaElement jElement = (IJavaElement)element;
            ICompilationUnit cu = (ICompilationUnit)jElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getCorrespondingResource();
            }
            IClassFile cf = (IClassFile)jElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getCorrespondingResource();
            }
        }
        return null;
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return JavaPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            IEditorPart reusedEditor = this.getReusedEditor();
            boolean isOpen = false;
            if (reusedEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = reusedEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !reusedEditor.isDirty() && !this.isPinned(reusedEditor);
            boolean bl = showsSameInputType = reusedEditor != null && reusedEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(reusedEditor, false);
                this.setReusedEditor(null);
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)reusedEditor).setInput(input);
                page.bringToTop((IWorkbenchPart)reusedEditor);
                editor = reusedEditor;
            } else {
                try {
                    editor = page.openEditor(input, editorId, false);
                    if (editor instanceof IReusableEditor) {
                        this.setReusedEditor(editor);
                    } else {
                        this.setReusedEditor(null);
                    }
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.Search_Error_openEditor_title, (String)SearchMessages.Search_Error_openEditor_message);
                    return null;
                }
            }
        }
        return editor;
    }

    private IEditorPart getReusedEditor() {
        if (this.fReusedEditorWatcher != null) {
            return this.fReusedEditorWatcher.getReusedEditor();
        }
        return null;
    }

    private void setReusedEditor(IEditorPart editor) {
        if (this.fReusedEditorWatcher == null) {
            this.fReusedEditorWatcher = new ReusedEditorWatcher();
        }
        this.fReusedEditorWatcher.initialize(editor);
    }

    private IClassFile getClassFile(Object element) {
        if (!(element instanceof IJavaElement)) {
            return null;
        }
        if (element instanceof IClassFile) {
            return (IClassFile)element;
        }
        IJavaElement jElement = (IJavaElement)element;
        if (jElement instanceof IMember) {
            return ((IMember)jElement).getClassFile();
        }
        return null;
    }

    private static class ReusedEditorWatcher
    implements IPartListener {
        private IEditorPart fReusedEditor = null;
        private IPartService fPartService = null;

        public IEditorPart getReusedEditor() {
            return this.fReusedEditor;
        }

        public void initialize(IEditorPart editor) {
            if (this.fReusedEditor != null) {
                this.fPartService.removePartListener((IPartListener)this);
            }
            this.fReusedEditor = editor;
            if (editor != null) {
                this.fPartService = editor.getSite().getWorkbenchWindow().getPartService();
                this.fPartService.addPartListener((IPartListener)this);
            } else {
                this.fPartService = null;
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this.fReusedEditor) {
                this.initialize(null);
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    }
}

