/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.JavaElementChangeListener;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.FeatureRebuilder;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class PDECore
extends Plugin
implements IEnvironmentVariables {
    public static final String PLUGIN_ID = "org.eclipse.pde.core";
    public static final String BINARY_PROJECT_VALUE = "binary";
    public static final String BINARY_REPOSITORY_PROVIDER = "org.eclipse.pde.core.BinaryRepositoryProvider";
    public static final String CLASSPATH_CONTAINER_ID = "org.eclipse.pde.core.requiredPlugins";
    public static final String JAVA_SEARCH_CONTAINER_ID = "org.eclipse.pde.core.externalJavaSearch";
    public static final String ECLIPSE_HOME_VARIABLE = "ECLIPSE_HOME";
    public static final QualifiedName EXTERNAL_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");
    public static final String EXTERNAL_PROJECT_VALUE = "external";
    private static PDECore inst;
    private static boolean isDevLaunchMode;
    private PluginModelManager fModelManager;
    private ExternalModelManager fExternalModelManager;
    private WorkspaceModelManager fWorkspaceModelManager;
    private FeatureModelManager fFeatureModelManager;
    private TargetDefinitionManager fTargetProfileManager;
    private SchemaRegistry fSchemaRegistry;
    private SourceLocationManager fSourceLocationManager;
    private JavadocLocationManager fJavadocLocationManager;
    private TracingOptionsManager fTracingOptionsManager;
    private BundleContext fBundleContext;
    private ServiceTracker fTracker;
    private JavaElementChangeListener fJavaElementChangeListener;
    private FeatureRebuilder fFeatureRebuilder;

    static {
        isDevLaunchMode = false;
    }

    public static boolean compare(String id1, String version1, String id2, String version2, int match) {
        if (!id1.equals(id2)) {
            return false;
        }
        if (version1 == null) {
            return true;
        }
        if (version2 == null) {
            return false;
        }
        PluginVersionIdentifier pid1 = null;
        PluginVersionIdentifier pid2 = null;
        try {
            pid1 = new PluginVersionIdentifier(version1);
            pid2 = new PluginVersionIdentifier(version2);
        }
        catch (RuntimeException runtimeException) {
            return version2.equals(version1);
        }
        switch (match) {
            case 0: 
            case 2: {
                if (!pid2.isCompatibleWith(pid1)) break;
                return true;
            }
            case 1: {
                if (!pid2.isEquivalentTo(pid1)) break;
                return true;
            }
            case 3: {
                if (!pid2.isPerfect(pid1)) break;
                return true;
            }
            case 4: {
                if (!pid2.isGreaterOrEqualTo(pid1)) break;
                return true;
            }
        }
        return false;
    }

    public static PDECore getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PDECore.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, PDECore.getPluginId(), 0, e.getMessage(), e);
        }
        PDECore.log(status);
    }

    public static void logErrorMessage(String message) {
        PDECore.log((IStatus)new Status(4, PDECore.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e) {
        PDECore.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDECore.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static boolean isDevLaunchMode() {
        String[] args = Platform.getApplicationArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-pdelaunch")) {
                isDevLaunchMode = true;
            }
            ++i;
        }
        return isDevLaunchMode;
    }

    public PDECore() {
        inst = this;
    }

    public URL getInstallURL() {
        try {
            return FileLocator.resolve((URL)PDECore.getDefault().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IPluginExtensionPoint findExtensionPoint(String fullID) {
        if (fullID == null || fullID.length() == 0) {
            return null;
        }
        int lastDot = fullID.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String pluginID = fullID.substring(0, lastDot);
        IPlugin plugin = this.findPlugin(pluginID);
        if (plugin == null) {
            return PDEManager.findExtensionPoint(fullID);
        }
        String pointID = fullID.substring(lastDot + 1);
        IPluginExtensionPoint[] points = plugin.getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            IPluginExtensionPoint point = points[i];
            if (point.getId().equals(pointID)) {
                return point;
            }
            ++i;
        }
        IFragmentModel[] fragments = PDEManager.findFragmentsFor(plugin.getPluginModel());
        int i2 = 0;
        while (i2 < fragments.length) {
            points = fragments[i2].getPluginBase().getExtensionPoints();
            int j = 0;
            while (j < points.length) {
                if (points[j].getId().equals(pointID)) {
                    return points[j];
                }
                ++j;
            }
            ++i2;
        }
        return PDEManager.findExtensionPoint(fullID);
    }

    private IFeature findFeature(IFeatureModel[] models, String id, String version, int match) {
        int i = 0;
        while (i < models.length) {
            String pversion;
            IFeatureModel model = models[i];
            IFeature feature = model.getFeature();
            String pid = feature.getId();
            if (PDECore.compare(id, version, pid, pversion = feature.getVersion(), match)) {
                return feature;
            }
            ++i;
        }
        return null;
    }

    public IFeature findFeature(String id) {
        IFeatureModel[] models = this.getFeatureModelManager().findFeatureModels(id);
        if (models.length > 0) {
            return models[0].getFeature();
        }
        return null;
    }

    public IFeature findFeature(String id, String version, int match) {
        IFeatureModel[] models = this.getFeatureModelManager().findFeatureModels(id);
        return this.findFeature(models, id, version, match);
    }

    public IPlugin findPlugin(String id) {
        return this.findPlugin(id, null, 0);
    }

    public IPlugin findPlugin(String id, String version, int match) {
        IPluginModel model = this.getModelManager().findPluginModel(id);
        return model != null && model.isEnabled() ? model.getPlugin() : null;
    }

    public ExternalModelManager getExternalModelManager() {
        this.initializeModels();
        return this.fExternalModelManager;
    }

    public PluginModelManager getModelManager() {
        this.initializeModels();
        return this.fModelManager;
    }

    public TargetDefinitionManager getTargetProfileManager() {
        if (this.fTargetProfileManager == null) {
            this.fTargetProfileManager = new TargetDefinitionManager();
        }
        return this.fTargetProfileManager;
    }

    public FeatureModelManager getFeatureModelManager() {
        this.initializeModels();
        return this.fFeatureModelManager;
    }

    public JavaElementChangeListener getJavaElementChangeListener() {
        return this.fJavaElementChangeListener;
    }

    public SchemaRegistry getSchemaRegistry() {
        if (this.fSchemaRegistry == null) {
            this.fSchemaRegistry = new SchemaRegistry();
        }
        return this.fSchemaRegistry;
    }

    public SourceLocationManager getSourceLocationManager() {
        if (this.fSourceLocationManager == null) {
            this.fSourceLocationManager = new SourceLocationManager();
        }
        return this.fSourceLocationManager;
    }

    public JavadocLocationManager getJavadocLocationManager() {
        if (this.fJavadocLocationManager == null) {
            this.fJavadocLocationManager = new JavadocLocationManager();
        }
        return this.fJavadocLocationManager;
    }

    public TracingOptionsManager getTracingOptionsManager() {
        if (this.fTracingOptionsManager == null) {
            this.fTracingOptionsManager = new TracingOptionsManager();
        }
        return this.fTracingOptionsManager;
    }

    public WorkspaceModelManager getWorkspaceModelManager() {
        this.initializeModels();
        return this.fWorkspaceModelManager;
    }

    public boolean areModelsInitialized() {
        return this.fModelManager != null;
    }

    private synchronized void initializeModels() {
        if (this.fModelManager != null && this.fExternalModelManager != null && this.fWorkspaceModelManager != null) {
            return;
        }
        this.fExternalModelManager = new ExternalModelManager();
        this.fWorkspaceModelManager = new WorkspaceModelManager();
        this.fModelManager = new PluginModelManager(this.fWorkspaceModelManager, this.fExternalModelManager);
        this.fFeatureModelManager = new FeatureModelManager(this.fWorkspaceModelManager);
        this.fFeatureRebuilder = new FeatureRebuilder();
        this.fFeatureRebuilder.start();
    }

    public void releasePlatform() {
        if (this.fTracker == null) {
            return;
        }
        this.fTracker.close();
        this.fTracker = null;
    }

    public PlatformAdmin acquirePlatform() {
        if (this.fTracker == null) {
            this.fTracker = new ServiceTracker(this.fBundleContext, PlatformAdmin.class.getName(), null);
            this.fTracker.open();
        }
        PlatformAdmin result = (PlatformAdmin)this.fTracker.getService();
        while (result == null) {
            try {
                this.fTracker.waitForService(1000L);
                result = (PlatformAdmin)this.fTracker.getService();
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        CompilerFlags.initializeDefaults();
        this.fJavaElementChangeListener = new JavaElementChangeListener();
        this.fJavaElementChangeListener.start();
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public void stop(BundleContext context) throws CoreException {
        PDECore.getDefault().savePluginPreferences();
        if (this.fJavaElementChangeListener != null) {
            this.fJavaElementChangeListener.shutdown();
            this.fJavaElementChangeListener = null;
        }
        if (this.fFeatureRebuilder != null) {
            this.fFeatureRebuilder.stop();
            this.fFeatureRebuilder = null;
        }
        if (this.fSchemaRegistry != null) {
            this.fSchemaRegistry.shutdown();
            this.fSchemaRegistry = null;
        }
        if (this.fModelManager != null) {
            this.fModelManager.shutdown();
            this.fModelManager = null;
        }
        if (this.fFeatureModelManager != null) {
            this.fFeatureModelManager.shutdown();
            this.fFeatureModelManager = null;
        }
        if (this.fExternalModelManager != null) {
            this.fExternalModelManager.shutdown();
            this.fExternalModelManager = null;
        }
        if (this.fWorkspaceModelManager != null) {
            this.fWorkspaceModelManager.shutdown();
            this.fWorkspaceModelManager = null;
        }
        if (this.fTargetProfileManager != null) {
            this.fTargetProfileManager.shutdown();
            this.fTargetProfileManager = null;
        }
    }
}

