/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.file;

import gnu.javax.sound.midi.file.ExtendedMidiFileFormat;
import gnu.javax.sound.midi.file.MidiDataInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class MidiFileReader
extends javax.sound.midi.spi.MidiFileReader {
    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        int n;
        float f;
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        if (dataInputStream.readInt() != 1297377380) {
            throw new InvalidMidiDataException("Invalid MIDI chunk header.");
        }
        int n2 = dataInputStream.readInt();
        if (n2 < 6) {
            throw new InvalidMidiDataException("Invalid MIDI chunk header length: " + n2);
        }
        short s = dataInputStream.readShort();
        if (s < 0 || s > 2) {
            throw new InvalidMidiDataException("Invalid MIDI file type value: " + s);
        }
        short s2 = dataInputStream.readShort();
        if (s2 <= 0) {
            throw new InvalidMidiDataException("Invalid number of MIDI tracks: " + s2);
        }
        int n3 = dataInputStream.readShort();
        if ((n3 & 0x8000) != 0) {
            n3 = -(n3 >>> 8 & 0xFF);
            switch (n3) {
                case 24: {
                    f = 24.0f;
                    break;
                }
                case 25: {
                    f = 25.0f;
                    break;
                }
                case 29: {
                    f = 29.97f;
                    break;
                }
                case 30: {
                    f = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid MIDI frame division type: " + n3);
                }
            }
            n = n3 & 0xFF;
        } else {
            f = 0.0f;
            n = n3 & Short.MAX_VALUE;
        }
        dataInputStream.skip(n2 - 6);
        return new ExtendedMidiFileFormat(s, f, n, -1, -1, s2);
    }

    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            midiFileFormat = this.getMidiFileFormat(inputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileFormat midiFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            midiFileFormat = this.getMidiFileFormat(fileInputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return midiFileFormat;
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        MidiDataInputStream midiDataInputStream = new MidiDataInputStream(inputStream);
        ExtendedMidiFileFormat extendedMidiFileFormat = (ExtendedMidiFileFormat)this.getMidiFileFormat(midiDataInputStream);
        Sequence sequence = new Sequence(extendedMidiFileFormat.getDivisionType(), extendedMidiFileFormat.getResolution());
        int n = extendedMidiFileFormat.getNumberTracks();
        while (n-- > 0) {
            Track track = sequence.createTrack();
            int n2 = midiDataInputStream.readInt();
            if (n2 != 1297379947) {
                throw new InvalidMidiDataException("Invalid MIDI track header.");
            }
            int n3 = midiDataInputStream.readInt();
            int n4 = -1;
            int n5 = 0;
            boolean bl = false;
            block11: while (!bl) {
                Object object;
                Object object2;
                int n6 = midiDataInputStream.readVariableLengthInt();
                n5 += n6;
                int n7 = midiDataInputStream.readUnsignedByte();
                if (n7 < 240) {
                    ShortMessage shortMessage;
                    block0 : switch (n7 & 0xF0) {
                        case 128: 
                        case 144: 
                        case 160: 
                        case 176: 
                        case 224: 
                        case 242: {
                            shortMessage = new ShortMessage();
                            shortMessage.setMessage(n7, midiDataInputStream.readByte(), midiDataInputStream.readByte());
                            n4 = n7;
                            break;
                        }
                        case 192: 
                        case 208: 
                        case 243: 
                        case 245: {
                            shortMessage = new ShortMessage();
                            shortMessage.setMessage(n7, midiDataInputStream.readByte(), 0);
                            n4 = n7;
                            break;
                        }
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 254: 
                        case 255: {
                            shortMessage = new ShortMessage();
                            shortMessage.setMessage(n7, 0, 0);
                            n4 = n7;
                            break;
                        }
                        default: {
                            if (n4 != -1) {
                                switch (n4 & 0xF0) {
                                    case 128: 
                                    case 144: 
                                    case 160: 
                                    case 176: 
                                    case 224: 
                                    case 242: {
                                        shortMessage = new ShortMessage();
                                        shortMessage.setMessage(n4, n7, midiDataInputStream.readByte());
                                        break block0;
                                    }
                                    case 192: 
                                    case 208: 
                                    case 243: 
                                    case 245: {
                                        ShortMessage shortMessage2 = new ShortMessage();
                                        shortMessage2.setMessage(n4, n7, 0);
                                        continue block11;
                                    }
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 250: 
                                    case 251: 
                                    case 252: 
                                    case 254: 
                                    case 255: {
                                        ShortMessage shortMessage3 = new ShortMessage();
                                        shortMessage3.setMessage(n4, 0, 0);
                                        continue block11;
                                    }
                                }
                                throw new InvalidMidiDataException("Invalid Short MIDI Event: " + n7);
                            }
                            throw new InvalidMidiDataException("Invalid Short MIDI Event: " + n7);
                        }
                    }
                    object2 = shortMessage;
                } else if (n7 == 240 || n7 == 247) {
                    int n8 = midiDataInputStream.readVariableLengthInt();
                    byte[] byArray = new byte[n8];
                    midiDataInputStream.readFully(byArray);
                    object = new SysexMessage();
                    ((SysexMessage)object).setMessage(n7, byArray, n8);
                    object2 = object;
                    n4 = -1;
                } else if (n7 == 255) {
                    byte by = midiDataInputStream.readByte();
                    int n9 = midiDataInputStream.readVariableLengthInt();
                    object = new byte[n9];
                    midiDataInputStream.readFully((byte[])object);
                    MetaMessage metaMessage = new MetaMessage();
                    metaMessage.setMessage(by, (byte[])object, n9);
                    object2 = metaMessage;
                    if (by == 47) {
                        bl = true;
                    }
                    n4 = -1;
                } else {
                    throw new InvalidMidiDataException("Invalid status byte: " + n7);
                }
                track.add(new MidiEvent((MidiMessage)object2, n5));
            }
        }
        return sequence;
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        Sequence sequence;
        InputStream inputStream = uRL.openStream();
        try {
            sequence = this.getSequence(inputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return sequence;
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Sequence sequence;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            sequence = this.getSequence(fileInputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return sequence;
    }
}

