/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.peer.TextAreaPeer;
import java.io.Serializable;
import java.util.HashSet;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleStateSet;

public class TextArea
extends TextComponent
implements Serializable {
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private static final long serialVersionUID = 3692302836626095722L;
    private int columns;
    private int rows;
    private int scrollbarVisibility;
    private static transient long next_text_number;

    public TextArea() {
        this("", 0, 0, 0);
    }

    public TextArea(String string) {
        this(string, 0, 0, 0);
    }

    public TextArea(int n, int n2) {
        this("", n, n2, 0);
    }

    public TextArea(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public TextArea(String string, int n, int n2, int n3) {
        super(string);
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.rows = n < 0 ? 0 : n;
        this.columns = n2 < 0 ? 0 : n2;
        this.scrollbarVisibility = n3 < 0 || n3 > 4 ? 0 : n3;
        HashSet hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        this.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        this.setFocusTraversalKeys(1, hashSet);
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + n);
        }
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public synchronized void setRows(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Value is less than one: " + n);
        }
        this.rows = n;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows(), this.getColumns());
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.getRows(), this.getColumns());
    }

    public Dimension minimumSize(int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.getPeer();
        if (textAreaPeer == null) {
            return new Dimension(0, 0);
        }
        return textAreaPeer.getMinimumSize(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows(), this.getColumns());
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n, n2);
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.getRows(), this.getColumns());
    }

    public Dimension preferredSize(int n, int n2) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.getPeer();
        if (textAreaPeer == null) {
            return new Dimension(0, 0);
        }
        return textAreaPeer.getPreferredSize(n, n2);
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisibility;
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            this.setPeer(this.getToolkit().createTextArea(this));
        }
    }

    public void append(String string) {
        this.appendText(string);
    }

    public void appendText(String string) {
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.getPeer();
        if (textAreaPeer != null) {
            textAreaPeer.insert(string, textAreaPeer.getText().length());
        } else {
            this.setText(this.getText() + string);
        }
    }

    public void insert(String string, int n) {
        this.insertText(string, n);
    }

    public void insertText(String string, int n) {
        String string2 = null;
        String string3 = null;
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.getPeer();
        if (textAreaPeer != null) {
            textAreaPeer.insert(string, n);
        } else {
            string2 = this.getText().substring(0, n);
            string3 = this.getText().substring(n, this.getText().length());
            this.setText(string2 + string + string3);
        }
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceText(string, n, n2);
    }

    public void replaceText(String string, int n, int n2) {
        String string2 = null;
        String string3 = null;
        TextAreaPeer textAreaPeer = (TextAreaPeer)this.getPeer();
        if (textAreaPeer != null) {
            textAreaPeer.replaceRange(string, n, n2);
        } else {
            string2 = this.getText().substring(0, n);
            string3 = this.getText().substring(n2, this.getText().length());
            this.setText(string2 + string + string3);
        }
    }

    protected String paramString() {
        String string = "";
        switch (this.scrollbarVisibility) {
            case 0: {
                string = "both";
                break;
            }
            case 1: {
                string = "vertical-only";
                break;
            }
            case 2: {
                string = "horizontal-only";
                break;
            }
            case 3: {
                string = "none";
            }
        }
        String string2 = "";
        if (this.isEditable()) {
            string2 = "editable,";
        }
        return this.getName() + "," + this.getX() + "," + this.getY() + "," + this.getWidth() + "x" + this.getHeight() + "," + "text=" + this.getText() + "," + string2 + "selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd() + ",rows=" + this.rows + ",columns=" + this.columns + ",scrollbarVisibility=" + string;
    }

    String generateName() {
        return "text" + TextArea.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_text_number++;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextArea(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTTextArea
    extends TextComponent.AccessibleAWTTextComponent {
        private /* synthetic */ TextArea this$0;
        private static final long serialVersionUID = 3472827823632144419L;

        protected AccessibleAWTTextArea(TextArea textArea) {
            this.this$0 = textArea;
            super(textArea);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }
    }
}

