/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;

    private /* synthetic */ void finit$() {
        this.popupMenu = null;
        this.menuEvent = new MenuEvent(this);
    }

    public JMenu() {
        this.finit$();
        this.setOpaque(false);
        this.setDelay(200);
    }

    public JMenu(String string) {
        super(string);
        this.finit$();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
        this.setDelay(200);
    }

    public JMenu(Action action) {
        super(action);
        this.finit$();
        this.createActionChangeListener(this);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
        this.setDelay(200);
    }

    public JMenu(String string, boolean bl) {
        this(string);
        this.setDelay(200);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        return this.getPopupMenu().add(jMenuItem);
    }

    public Component add(Component component) {
        this.getPopupMenu().insert(component, -1);
        return component;
    }

    public Component add(Component component, int n) {
        return this.getPopupMenu().add(component, n);
    }

    public JMenuItem add(String string) {
        return this.getPopupMenu().add(string);
    }

    public JMenuItem add(Action action) {
        return this.getPopupMenu().add(action);
    }

    public void remove(JMenuItem jMenuItem) {
        this.getPopupMenu().remove(jMenuItem);
    }

    public void remove(int n) {
        if (n < 0 || n > 0 && this.getMenuComponentCount() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.getMenuComponentCount() > 0) {
            this.popupMenu.remove(n);
        }
    }

    public void remove(Component component) {
        int n = this.getPopupMenu().getComponentIndex(component);
        if (n >= 0) {
            this.getPopupMenu().remove(n);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public void insert(String string, int n) {
        this.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.getPopupMenu().insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        JMenuItem jMenuItem = new JMenuItem(action);
        this.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel buttonModel) {
        super.setModel(buttonModel);
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    private void setSelectedHelper(boolean bl, boolean bl2, boolean bl3) {
        if (bl && bl2) {
            super.setArmed(true);
            super.setSelected(true);
            if (this.isShowing()) {
                this.fireMenuSelected();
                int n = 0;
                int n2 = 0;
                if (bl3) {
                    if (this.menuLocation == null) {
                        if (this.isTopLevelMenu()) {
                            n2 = this.getHeight();
                        } else {
                            n = this.getWidth();
                        }
                        this.getPopupMenu().show(this, n, n2);
                    } else {
                        this.getPopupMenu().show(this, this.menuLocation.x, this.menuLocation.y);
                    }
                }
            }
        } else {
            super.setSelected(false);
            super.setArmed(false);
            this.fireMenuDeselected();
            this.getPopupMenu().setVisible(false);
        }
    }

    public void setSelected(boolean bl) {
        this.setSelectedHelper(bl, true, false);
    }

    public boolean isPopupMenuVisible() {
        return this.getPopupMenu().isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (this.getModel().isEnabled()) {
            this.getPopupMenu().setVisible(bl);
        }
    }

    protected Point getPopupMenuOrigin() {
        if (this.isTopLevelMenu()) {
            return new Point(0, this.getHeight());
        }
        return new Point(this.getWidth(), 0);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = n;
    }

    public void setMenuLocation(int n, int n2) {
        this.menuLocation = new Point(n, n2);
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(this, jMenuItem);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        if (this.getItemCount() == 0) {
            return null;
        }
        Component component = this.popupMenu.getComponentAtIndex(n);
        if (component instanceof JMenuItem) {
            return (JMenuItem)component;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("The method isTearOff() has not yet been implemented.");
    }

    public int getMenuComponentCount() {
        return this.getPopupMenu().getComponentCount();
    }

    public Component getMenuComponent(int n) {
        if (this.getPopupMenu() == null || this.getMenuComponentCount() == 0) {
            return null;
        }
        return this.popupMenu.getComponentAtIndex(n);
    }

    public Component[] getMenuComponents() {
        return this.getPopupMenu().getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
        }
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(JMenu.class$("javax.swing.event.MenuListener"), menuListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(JMenu.class$("javax.swing.event.MenuListener"), menuListener);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
    }

    protected void fireMenuSelected() {
        MenuListener[] menuListenerArray = this.getMenuListeners();
        for (int i = 0; i < menuListenerArray.length; ++i) {
            menuListenerArray[i].menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuCanceled(this.menuEvent);
        }
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(this, jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelectedHelper(bl, this.isEnabled(), true);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
    }

    public void doClick(int n) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu(this);
        }
        return this.accessibleContext;
    }

    MenuElement[] createPath(JMenu jMenu) {
        JComponent jComponent;
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = null;
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                jComponent = component;
                arrayList.add(0, jComponent);
                component = ((JPopupMenu)jComponent).getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                jComponent = (JMenu)component;
                arrayList.add(0, jComponent);
                component = jComponent.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        jComponent = (JMenuBar)component;
        arrayList.add(0, jComponent);
        objectArray = new MenuElement[arrayList.size()];
        objectArray = (MenuElement[])arrayList.toArray(objectArray);
        return objectArray;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        private /* synthetic */ JMenu this$0;
        private JMenuItem menuItem;

        public ActionChangedListener(JMenu jMenu, JMenuItem jMenuItem) {
            this.this$0 = jMenu;
            this.menuItem = jMenuItem;
            Action action = jMenuItem.getAction();
            if (action != null) {
                action.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private /* synthetic */ JMenu this$0;
        private static final long serialVersionUID = -6415815570638474823L;

        public WinListener(JMenu jMenu, JPopupMenu jPopupMenu) {
            this.this$0 = jMenu;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.this$0.setSelected(false);
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private /* synthetic */ JMenu this$0;
        private static final long serialVersionUID = -8131864021059524309L;

        protected AccessibleJMenu(JMenu jMenu) {
            this.this$0 = jMenu;
            super(jMenu);
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = this.this$0.getMenuComponents();
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = this.this$0.getMenuComponents();
            int n2 = 0;
            Accessible accessible = null;
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    accessible = (Accessible)((Object)componentArray[i]);
                    break;
                }
                ++n2;
            }
            return accessible;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            MenuSelectionManager menuSelectionManager;
            MenuElement[] menuElementArray;
            Accessible accessible = null;
            if (n == 0 && (menuElementArray = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()) != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] == this.this$0) {
                        do {
                            if (!(menuElementArray[i] instanceof Accessible)) continue;
                            accessible = (Accessible)((Object)menuElementArray[i]);
                            break;
                        } while (++i < menuElementArray.length);
                    }
                    if (accessible != null) break;
                }
            }
            return accessible;
        }

        public boolean isAccessibleChildSelected(int n) {
            boolean bl = false;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray != null) {
                Accessible accessible = this.getAccessibleChild(n);
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != accessible) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            int n = 0;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != this.this$0 || i + 1 >= menuElementArray.length) continue;
                    n = 1;
                    break;
                }
            }
            return n;
        }

        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null && accessible instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)accessible;
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(this.this$0.createPath(this.this$0));
            }
        }

        public void removeAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != accessible) continue;
                    MenuElement[] menuElementArray2 = new MenuElement[i - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i - 1);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    break;
                }
            }
        }

        public void clearAccessibleSelection() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (menuElementArray[i] != this.this$0) continue;
                MenuElement[] menuElementArray2 = new MenuElement[i];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i);
                menuSelectionManager.setSelectedPath(menuElementArray2);
                break;
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

