/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.PluginAppletWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;

class PluginAppletViewer {
    static HashMap appletWindows = new HashMap();
    private static BufferedReader pluginInputStream;
    private static BufferedWriter pluginOutputStream;

    static void start(InputStream inputStream, OutputStream outputStream) throws MalformedURLException, IOException {
        pluginInputStream = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
        pluginOutputStream = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
        PluginAppletViewer.write("running");
        String string = PluginAppletViewer.read();
        PluginAppletWindow pluginAppletWindow = null;
        while (true) {
            if (string.startsWith("instance")) {
                String string2 = string.substring(9);
                if (appletWindows.get(string2) == null) {
                    appletWindows.put(string2, new PluginAppletWindow());
                }
                pluginAppletWindow = (PluginAppletWindow)appletWindows.get(string2);
            } else if (string.startsWith("tag")) {
                int n = string.indexOf(32, 4);
                String string3 = string.substring(4, n);
                String string4 = string.substring(n + 1);
                pluginAppletWindow.setParser(string4, string3);
            } else if (string.startsWith("handle")) {
                long l = Long.parseLong(string.substring(7));
                pluginAppletWindow.setHandle(l);
            } else if (string.startsWith("width")) {
                int n = Integer.parseInt(string.substring(6));
                pluginAppletWindow.setSize(n, pluginAppletWindow.getHeight());
            } else if (string.startsWith("height")) {
                int n = Integer.parseInt(string.substring(7));
                pluginAppletWindow.setSize(pluginAppletWindow.getWidth(), n);
            } else if (string.startsWith("destroy")) {
                appletWindows.remove(pluginAppletWindow);
                pluginAppletWindow.dispose();
            }
            string = PluginAppletViewer.read();
        }
    }

    static void write(String string) throws IOException {
        pluginOutputStream.write(string, 0, string.length());
        pluginOutputStream.newLine();
        pluginOutputStream.flush();
        System.err.println("  PIPE: applet viewer wrote: " + string);
    }

    static String read() throws IOException {
        String string = pluginInputStream.readLine();
        System.err.println("  PIPE: applet viewer read: " + string);
        if (string == null || string.equals("shutdown")) {
            pluginInputStream.close();
            pluginOutputStream.close();
            System.err.println("appletviewer: exiting plugin applet viewer");
            System.exit(0);
        }
        return string;
    }

    PluginAppletViewer() {
    }
}

