#!/bin/sh
echo 'name: atom
version: 1.0.7
id: atom-1.0.7-47891fa00a4c08b4b6e12d49a965f132

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit
hidden-modules:
import-dirs: /usr/local/lib/ghc/atom-1.0.7
library-dirs: /usr/local/lib/ghc/atom-1.0.7
hs-libraries: HSatom-1.0.7
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.2.0.2-578c91f7479ca9d00c13da2ed514f7ac
         mtl-1.1.0.2-9e35d291e0ab20c6aa18823de23bc2de
         process-1.0.1.3-2568ceba2d6dc7c48536c5d78397f116
         syb-0.1.0.2-0917873f366b0be90a48082271223b4e
         uniplate-1.6-37d562b83c97493009e7de94e639962a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.7/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
